<?php

// Script test sederhana untuk GET dengan body data
echo "=== TEST GET WITH BODY DATA ===\n";

// Simulate GET request with body data
$testData = [
    'id' => 123,
    'nama' => 'Test User GET',
    'alamat' => 'Test Address GET',
    'gender' => 'male',
    'data' => [
        'key' => 'value',
        'nested' => [
            'data' => 'example'
        ]
    ]
];

$jsonData = json_encode($testData);

echo "1. Test Data:\n";
echo "   JSON: " . $jsonData . "\n";
echo "   Size: " . strlen($jsonData) . " bytes\n";

// 2. Try to bootstrap Laravel
echo "\n2. Laravel Bootstrap:\n";
try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    echo "   ✅ Laravel bootstrapped successfully\n";
    
    // 3. Test database connection
    echo "\n3. Database Test:\n";
    try {
        $pdo = new PDO(
            'mysql:host=' . env('DB_HOST', 'localhost') . 
            ';dbname=' . env('DB_DATABASE', 'database') . 
            ';charset=utf8mb4',
            env('DB_USERNAME', 'root'),
            env('DB_PASSWORD', '')
        );
        echo "   ✅ Database connection successful\n";
        
        // 4. Check receiver
        echo "\n4. Receiver Check:\n";
        $endpoint = 'ujicoba';
        $stmt = $pdo->query("SELECT endpoint, name, target_table, auto_create_table, is_active FROM api_receivers WHERE endpoint = '$endpoint'");
        $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($receiver) {
            echo "   ✅ Receiver found: " . $receiver['name'] . "\n";
            echo "   📊 Target table: " . $receiver['target_table'] . "\n";
            echo "   🔧 Auto create: " . ($receiver['auto_create_table'] ? 'Yes' : 'No') . "\n";
            echo "   ✅ Is active: " . ($receiver['is_active'] ? 'Yes' : 'No') . "\n";
            
            // 5. Test table creation and data insertion
            echo "\n5. Table and Data Test:\n";
            
            $tableName = $receiver['target_table'];
            
            // Check if table exists
            $stmt = $pdo->query("SHOW TABLES LIKE '$tableName'");
            $tableExists = $stmt->rowCount() > 0;
            echo "   Table exists: " . ($tableExists ? 'Yes' : 'No') . "\n";
            
            if (!$tableExists && $receiver['auto_create_table']) {
                echo "   📋 Creating table...\n";
                $createSQL = "CREATE TABLE $tableName (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    external_id INT NULL,
                    nama VARCHAR(255) NULL,
                    alamat VARCHAR(255) NULL,
                    gender VARCHAR(50) NULL,
                    data JSON NULL,
                    created_at TIMESTAMP NULL,
                    updated_at TIMESTAMP NULL
                )";
                $pdo->exec($createSQL);
                echo "   ✅ Table created\n";
                $tableExists = true;
            }
            
            if ($tableExists) {
                // Prepare test data
                $insertData = [
                    'external_id' => $testData['id'],
                    'nama' => $testData['nama'],
                    'alamat' => $testData['alamat'],
                    'gender' => $testData['gender'],
                    'data' => json_encode($testData['data']),
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ];
                
                // Insert data
                $columns = implode(', ', array_keys($insertData));
                $placeholders = ':' . implode(', :', array_keys($insertData));
                $sql = "INSERT INTO $tableName ($columns) VALUES ($placeholders)";
                
                $stmt = $pdo->prepare($sql);
                $result = $stmt->execute($insertData);
                
                if ($result) {
                    $id = $pdo->lastInsertId();
                    echo "   ✅ Data inserted successfully\n";
                    echo "   📊 Insert ID: $id\n";
                    
                    // Verify data
                    $stmt = $pdo->prepare("SELECT * FROM $tableName WHERE id = ?");
                    $stmt->execute([$id]);
                    $savedData = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($savedData) {
                        echo "   ✅ Data verified in database\n";
                        echo "   📊 Saved data: " . json_encode($savedData) . "\n";
                    } else {
                        echo "   ❌ Data not found in database\n";
                    }
                } else {
                    echo "   ❌ Failed to insert data\n";
                    $error = $stmt->errorInfo();
                    echo "   Error: " . $error[2] . "\n";
                }
            } else {
                echo "   ❌ Table does not exist and auto-create is disabled\n";
            }
            
        } else {
            echo "   ❌ Receiver '$endpoint' not found\n";
        }
        
    } catch (PDOException $e) {
        echo "   ❌ Database error: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Laravel error: " . $e->getMessage() . "\n";
}

echo "\n=== END TEST ===\n"; 