<?php

// Script test manual penyimpanan data untuk hosting
echo "=== MANUAL SAVE TEST ===\n";

try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    
    echo "✅ Laravel bootstrapped successfully\n";
    
    use Illuminate\Support\Facades\DB;
    use Illuminate\Support\Facades\Schema;
    
    $tableName = 'ujicoba';
    
    echo "\n1. Testing table creation...\n";
    
    if (!Schema::hasTable($tableName)) {
        echo "   📋 Creating table '$tableName'...\n";
        
        Schema::create($tableName, function ($table) {
            $table->id();
            $table->integer('external_id')->nullable();
            $table->string('nama')->nullable();
            $table->string('alamat')->nullable();
            $table->string('gender')->nullable();
            $table->json('data')->nullable();
            $table->timestamps();
        });
        
        echo "   ✅ Table created successfully\n";
    } else {
        echo "   ✅ Table '$tableName' already exists\n";
    }
    
    echo "\n2. Testing data insertion...\n";
    
    $testData = [
        'external_id' => 999,
        'nama' => 'Test User Hosting',
        'alamat' => 'Test Address Hosting',
        'gender' => 'male',
        'data' => json_encode([
            'key' => 'value',
            'nested' => [
                'data' => 'example'
            ]
        ]),
        'created_at' => now(),
        'updated_at' => now()
    ];
    
    echo "   📝 Inserting test data...\n";
    echo "   Data: " . json_encode($testData) . "\n";
    
    $id = DB::table($tableName)->insertGetId($testData);
    echo "   ✅ Data inserted with ID: $id\n";
    
    echo "\n3. Verifying data...\n";
    
    $savedData = DB::table($tableName)->where('id', $id)->first();
    if ($savedData) {
        echo "   ✅ Data found in database\n";
        echo "   📊 Saved data: " . json_encode($savedData) . "\n";
    } else {
        echo "   ❌ Data not found in database\n";
    }
    
    echo "\n4. Checking table structure...\n";
    
    $columns = Schema::getColumnListing($tableName);
    echo "   📋 Table columns: " . implode(', ', $columns) . "\n";
    
    // Check JSON columns
    try {
        $columnTypes = DB::select("
            SELECT COLUMN_NAME, DATA_TYPE 
            FROM INFORMATION_SCHEMA.COLUMNS 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = ? 
            AND DATA_TYPE = 'json'
        ", [$tableName]);
        
        $jsonColumns = [];
        foreach ($columnTypes as $column) {
            $jsonColumns[] = $column->COLUMN_NAME;
        }
        
        echo "   🗃️  JSON columns: " . implode(', ', $jsonColumns) . "\n";
    } catch (Exception $e) {
        echo "   ⚠️  Could not check JSON columns: " . $e->getMessage() . "\n";
    }
    
    echo "\n5. Checking total records...\n";
    
    $count = DB::table($tableName)->count();
    echo "   📊 Total records in table: $count\n";
    
    echo "\n✅ Manual save test completed successfully!\n";
    
} catch (Exception $e) {
    echo "❌ Error during test: " . $e->getMessage() . "\n";
    echo "📋 Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== END MANUAL SAVE TEST ===\n"; 