Write-Host "QUICK CONNECTION TEST" -ForegroundColor Yellow
Write-Host "=====================" -ForegroundColor Yellow

$server = "copilotproduction.site"
$username = "ftpapi@copilotproduction.site"
$password = "6ey?bb]*QgqIGN&."

# Test 1: DNS Resolution
Write-Host "DNS: " -NoNewline
try {
    $dns = [System.Net.Dns]::GetHostEntry($server)
    Write-Host "OK ($($dns.AddressList[0]))" -ForegroundColor Green
} catch {
    Write-Host "FAILED" -ForegroundColor Red
}

# Test 2: Ping
Write-Host "PING: " -NoNewline
$ping = Test-Connection -ComputerName $server -Count 1 -Quiet
if ($ping) {
    Write-Host "OK" -ForegroundColor Green
} else {
    Write-Host "FAILED" -ForegroundColor Red
}

# Test 3: Port 21
Write-Host "PORT 21: " -NoNewline
$port21 = Test-NetConnection -ComputerName $server -Port 21 -WarningAction SilentlyContinue
if ($port21.TcpTestSucceeded) {
    Write-Host "OPEN" -ForegroundColor Green
} else {
    Write-Host "CLOSED" -ForegroundColor Red
}

# Test 4: FTP Login
Write-Host "FTP LOGIN: " -NoNewline
try {
    $ftp = [System.Net.FtpWebRequest]::Create("ftp://$server/")
    $ftp.Credentials = New-Object System.Net.NetworkCredential($username, $password)
    $ftp.Method = [System.Net.WebRequestMethods+Ftp]::PrintWorkingDirectory
    $ftp.Timeout = 10000
    $ftp.UsePassive = $true
    
    $response = $ftp.GetResponse()
    Write-Host "SUCCESS" -ForegroundColor Green
    $response.Close()
} catch {
    Write-Host "FAILED ($($_.Exception.Message.Split('.')[0]))" -ForegroundColor Red
}

# Test 5: Alternative ports
Write-Host "ALT PORTS: " -NoNewline
$altPorts = @(22, 2121, 990)
$openPorts = @()
foreach ($port in $altPorts) {
    $test = Test-NetConnection -ComputerName $server -Port $port -WarningAction SilentlyContinue
    if ($test.TcpTestSucceeded) {
        $openPorts += $port
    }
}
if ($openPorts.Count -gt 0) {
    Write-Host "OPEN: $($openPorts -join ', ')" -ForegroundColor Green
} else {
    Write-Host "ALL CLOSED" -ForegroundColor Red
}

Write-Host "=====================" -ForegroundColor Yellow 