@extends('layouts.app')

@section('title', 'Analytics')

@section('breadcrumb')
    <li class="breadcrumb-item active">Analytics</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-chart-pie me-2"></i>Analytics Dashboard
        </h1>
        <div class="btn-group">
            <button type="button" class="btn btn-outline-primary" onclick="setTimeRange('today')">Today</button>
            <button type="button" class="btn btn-outline-primary" onclick="setTimeRange('week')">This Week</button>
            <button type="button" class="btn btn-outline-primary active" onclick="setTimeRange('month')">This Month</button>
        </div>
    </div>

    <!-- Analytics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total API Calls
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\ApiLog::count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-globe fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Success Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                @php
                                    $totalCalls = \App\Models\ApiLog::count();
                                    $successCalls = \App\Models\ApiLog::where('status_code', '>=', 200)->where('status_code', '<', 300)->count();
                                    $successRate = $totalCalls > 0 ? round(($successCalls / $totalCalls) * 100, 1) : 0;
                                @endphp
                                {{ $successRate }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Avg Response Time
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format(\App\Models\ApiLog::avg('response_time') ?? 0, 2) }}s
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Active Sources
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\ApiSource::where('status', 'active')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-database fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- API Usage Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">API Usage Overview</h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="usageChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status Distribution -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Response Status Distribution</h6>
                </div>
                <div class="card-body">
                    <div class="chart-pie pt-4 pb-2">
                        <canvas id="statusChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top API Sources -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Top API Sources</h6>
                </div>
                <div class="card-body">
                    @php
                        $topSources = \App\Models\ApiSource::withCount('apiLogs')
                            ->orderBy('api_logs_count', 'desc')
                            ->limit(5)
                            ->get();
                    @endphp
                    
                    @foreach($topSources as $source)
                        <div class="d-flex align-items-center mb-3">
                            <div class="me-3">
                                <div class="icon-circle bg-primary">
                                    <i class="fas fa-database text-white"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <div class="font-weight-bold">{{ $source->name }}</div>
                                <div class="small text-gray-500">{{ $source->api_logs_count }} requests</div>
                            </div>
                            <div class="text-end">
                                <div class="progress" style="width: 100px;">
                                    <div class="progress-bar bg-primary" role="progressbar" 
                                         style="width: {{ $topSources->max('api_logs_count') > 0 ? ($source->api_logs_count / $topSources->max('api_logs_count')) * 100 : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Errors</h6>
                </div>
                <div class="card-body">
                    @php
                        $recentErrors = \App\Models\ApiLog::with('apiSource')
                            ->where('status_code', '>=', 400)
                            ->latest()
                            ->limit(5)
                            ->get();
                    @endphp
                    
                    @if($recentErrors->count() > 0)
                        @foreach($recentErrors as $error)
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <div class="icon-circle bg-danger">
                                        <i class="fas fa-exclamation-triangle text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="font-weight-bold">{{ $error->apiSource->name ?? 'Unknown' }}</div>
                                    <div class="small text-gray-500">
                                        {{ $error->created_at->format('d M Y, H:i') }} - 
                                        Status: {{ $error->status_code }}
                                    </div>
                                    @if($error->error_message)
                                        <div class="small text-danger">{{ Str::limit($error->error_message, 60) }}</div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="text-center py-3">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <p class="text-muted">No recent errors found</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Usage Chart
const usageCtx = document.getElementById('usageChart').getContext('2d');
const usageChart = new Chart(usageCtx, {
    type: 'line',
    data: {
        labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
        datasets: [{
            label: 'API Calls',
            data: [12, 19, 3, 5, 2, 3, 9],
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Status Chart
const statusCtx = document.getElementById('statusChart').getContext('2d');
const statusChart = new Chart(statusCtx, {
    type: 'doughnut',
    data: {
        labels: ['Success (2xx)', 'Client Error (4xx)', 'Server Error (5xx)'],
        datasets: [{
            data: [{{ $successCalls }}, {{ \App\Models\ApiLog::where('status_code', '>=', 400)->where('status_code', '<', 500)->count() }}, {{ \App\Models\ApiLog::where('status_code', '>=', 500)->count() }}],
            backgroundColor: ['#28a745', '#ffc107', '#dc3545']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

function setTimeRange(range) {
    // Remove active class from all buttons
    document.querySelectorAll('.btn-group .btn').forEach(btn => btn.classList.remove('active'));
    
    // Add active class to clicked button
    event.target.classList.add('active');
    
    // Here you would typically reload data based on the selected time range
    console.log('Time range set to:', range);
}
</script>
@endsection 