@extends('layouts.app')

@section('title', 'API Client Details')

@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('api-clients.index') }}">API Clients</a>
    </li>
    <li class="breadcrumb-item active">{{ $apiClient->name }}</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Alert Messages -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-user-cog me-2"></i>{{ $apiClient->name }}
                </h1>
                <div>
                    <a href="{{ route('api-clients.edit', $apiClient) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <a href="{{ route('api-clients.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Client Information -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>Client Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Client Name:</label>
                                <p class="text-gray-800">{{ $apiClient->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Status:</label>
                                <p>
                                    @if($apiClient->is_active)
                                        <span class="badge bg-success">
                                            <i class="fas fa-check me-1"></i>Active
                                        </span>
                                    @else
                                        <span class="badge bg-danger">
                                            <i class="fas fa-times me-1"></i>Inactive
                                        </span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>

                    @if($apiClient->description)
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description:</label>
                            <p class="text-gray-800">{{ $apiClient->description }}</p>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Rate Limit:</label>
                                <p class="text-gray-800">
                                    {{ $apiClient->rate_limit ?? 'Unlimited' }} 
                                    @if($apiClient->rate_limit)
                                        requests/minute
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Last Used:</label>
                                <p class="text-gray-800">
                                    {{ $apiClient->last_used_at ? $apiClient->last_used_at->format('M d, Y H:i:s') : 'Never' }}
                                </p>
                            </div>
                        </div>
                    </div>

                    @if($apiClient->allowed_ips)
                        <div class="mb-3">
                            <label class="form-label fw-bold">Allowed IP Addresses:</label>
                            <div>
                                @foreach($apiClient->allowed_ips as $ip)
                                    <span class="badge bg-info me-1">{{ $ip }}</span>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Created:</label>
                                <p class="text-gray-800">{{ $apiClient->created_at->format('M d, Y H:i:s') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Updated:</label>
                                <p class="text-gray-800">{{ $apiClient->updated_at->format('M d, Y H:i:s') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- API Credentials -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-key me-2"></i>API Credentials
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Client ID:</label>
                        <div class="input-group">
                            <input type="text" class="form-control font-monospace" value="{{ $apiClient->client_id }}" 
                                   id="clientId" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('clientId')">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Client Secret:</label>
                        <div class="input-group">
                            <input type="password" class="form-control font-monospace" value="{{ $apiClient->client_secret }}" 
                                   id="clientSecret" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="toggleSecret()">
                                <i class="fas fa-eye" id="secretIcon"></i>
                            </button>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('clientSecret')">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                        <small class="text-danger">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            Keep this secret secure and never share it publicly.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Usage Statistics -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-chart-bar me-2"></i>Usage Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Total Tokens:</label>
                        <p class="text-gray-800">{{ $apiClient->tokens()->count() }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Active Tokens:</label>
                        <p class="text-gray-800">{{ $apiClient->tokens()->where('is_revoked', false)->count() }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(element.value);
    
    // Show feedback
    const button = event.target.closest('button');
    const originalIcon = button.innerHTML;
    button.innerHTML = '<i class="fas fa-check text-success"></i>';
    
    setTimeout(() => {
        button.innerHTML = originalIcon;
    }, 2000);
}

function toggleSecret() {
    const secretField = document.getElementById('clientSecret');
    const icon = document.getElementById('secretIcon');
    
    if (secretField.type === 'password') {
        secretField.type = 'text';
        icon.className = 'fas fa-eye-slash';
    } else {
        secretField.type = 'password';
        icon.className = 'fas fa-eye';
    }
}
</script>
@endsection 