@extends('layouts.app')

@section('title', 'API Receivers')

@section('content')
@php
    // Ensure $stats is always defined with default values
    $stats = $stats ?? [
        'total_receivers' => 0,
        'active_receivers' => 0,
        'get_endpoints' => 0,
        'post_endpoints' => 0,
        'total_requests' => 0,
        'recent_requests' => 0,
    ];
@endphp
<div class="container-fluid px-4">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-inbox me-2"></i>API Receivers
        </h1>
        <div>
            <a href="{{ route('api-receivers.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add New Receiver
            </a>
            <button type="button" class="btn btn-info ms-2" onclick="testJavaScript()">
                <i class="fas fa-bug me-2"></i>Test JS
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-primary border-4 shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs fw-bold text-primary text-uppercase mb-1">
                                Total Receivers
                            </div>
                            <div class="h5 mb-0 fw-bold text-gray-800">
                                {{ $api_receivers->total() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-inbox fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-success border-4 shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs fw-bold text-success text-uppercase mb-1">
                                Active Receivers
                            </div>
                            <div class="h5 mb-0 fw-bold text-gray-800">
                                {{ $stats['active_receivers'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-info border-4 shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs fw-bold text-info text-uppercase mb-1">
                                GET Endpoints
                            </div>
                            <div class="h5 mb-0 fw-bold text-gray-800">
                                {{ $stats['get_endpoints'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-download fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-warning border-4 shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs fw-bold text-warning text-uppercase mb-1">
                                POST Endpoints
                            </div>
                            <div class="h5 mb-0 fw-bold text-gray-800">
                                {{ $stats['post_endpoints'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-upload fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-primary border-4 shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col me-2">
                            <div class="text-xs fw-bold text-primary text-uppercase mb-1">
                                Total Requests
                            </div>
                            <div class="h5 mb-0 fw-bold text-gray-800">
                                {{ $stats['total_requests'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-lg-12">
            <!-- API Receivers Table -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-primary">
                        <i class="fas fa-list me-2"></i>API Receivers
                    </h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Actions:</div>
                            <a class="dropdown-item" href="{{ route('api-receivers.create') }}">
                                <i class="fas fa-plus fa-sm fa-fw me-2 text-gray-400"></i>
                                Add New Receiver
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="#" onclick="refreshPage()">
                                <i class="fas fa-sync fa-sm fa-fw me-2 text-gray-400"></i>
                                Refresh
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if($api_receivers->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Name & Description</th>
                                        <th>Endpoint</th>
                                        <th>Methods</th>
                                        <th>Target Table</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($api_receivers as $receiver)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <div class="icon-circle bg-{{ $receiver->is_active ? 'success' : 'secondary' }}">
                                                            <i class="fas fa-inbox text-dark"></i>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold text-dark">{{ $receiver->name }}</div>
                                                        @if($receiver->description)
                                                            <div class="small text-muted">{{ Str::limit($receiver->description, 50) }}</div>
                                                        @else
                                                            <div class="small text-muted">No description</div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="fw-bold text-primary">/api/in/{{ $receiver->endpoint }}</div>
                                                <div class="small text-muted">
                                                    <i class="fas fa-link me-1"></i>
                                                    <a href="{{ url('/api/in/' . $receiver->endpoint) }}" target="_blank" class="text-decoration-none">
                                                        Test Endpoint
                                                        <i class="fas fa-external-link-alt ms-1"></i>
                                                    </a>
                                                </div>
                                            </td>
                                            <td>
                                                @if($receiver->allowed_methods)
                                                    @php
                                                        $methods = explode(',', $receiver->allowed_methods);
                                                    @endphp
                                                    <div class="methods-container">
                                                        @foreach($methods as $method)
                                                            @php
                                                                $methodTrimmed = trim($method);
                                                                $badgeClass = 'secondary';
                                                                if ($methodTrimmed === 'GET') {
                                                                    $badgeClass = 'success';
                                                                } elseif ($methodTrimmed === 'POST') {
                                                                    $badgeClass = 'primary';
                                                                } elseif ($methodTrimmed === 'PUT') {
                                                                    $badgeClass = 'warning';
                                                                } elseif ($methodTrimmed === 'DELETE') {
                                                                    $badgeClass = 'danger';
                                                                }
                                                            @endphp
                                                            <span class="badge bg-{{ $badgeClass }} me-1 mb-1">
                                                                {{ $methodTrimmed }}
                                                            </span>
                                                        @endforeach
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <code class="bg-light p-1 rounded small">{{ $receiver->target_table }}</code>
                                                <div class="small text-muted mt-1">
                                                    @if($receiver->auto_create_table)
                                                        <i class="fas fa-magic text-info" title="Auto-create table"></i>
                                                        <span class="text-info">Auto-create</span>
                                                    @else
                                                        <i class="fas fa-table text-secondary" title="Manual table"></i>
                                                        <span class="text-secondary">Manual</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-column">
                                                    <span class="badge bg-{{ $receiver->is_active ? 'success' : 'secondary' }} mb-1">
                                                        {{ $receiver->is_active ? 'Active' : 'Inactive' }}
                                                    </span>
                                                    <small class="text-muted">
                                                        <i class="fas fa-shield-alt me-1"></i>
                                                        {{ ucfirst(str_replace('_', ' ', $receiver->auth_type)) }}
                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-wrap gap-1">
                                                    <a href="{{ route('api-receivers.show', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-info" title="View Details">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('api-receivers.edit', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="{{ route('api-receivers.logs', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-warning" title="View Logs">
                                                        <i class="fas fa-list"></i>
                                                    </a>
                                                    <a href="{{ route('api-receivers.preview-pdf', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-success" title="Preview PDF" target="_blank">
                                                        <i class="fas fa-eye"></i> Preview
                                                    </a>
                                                    <a href="{{ route('api-receivers.export-pdf', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-danger" title="Export PDF" target="_blank">
                                                        <i class="fas fa-file-pdf"></i> PDF
                                                    </a>
                                                    <a href="{{ route('api-receivers.delete', $receiver) }}" 
                                                       class="btn btn-sm btn-outline-danger delete-receiver-btn" 
                                                       onclick="return confirm('Are you sure you want to delete {{ $receiver->name }}? This action cannot be undone.')"
                                                       title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing {{ $api_receivers->firstItem() }} to {{ $api_receivers->lastItem() }} of {{ $api_receivers->total() }} results
                            </div>
                            {{ $api_receivers->links() }}
                        </div>
                    @else
                        <!-- Empty State -->
                        <div class="text-center py-5">
                            <i class="fas fa-inbox fa-4x text-gray-300 mb-4"></i>
                            <h4 class="text-gray-500 mb-2">No API Receivers Found</h4>
                            <p class="text-gray-400 mb-4">
                                Start by creating your first API receiver to accept incoming data from external sources.
                            </p>
                            <a href="{{ route('api-receivers.create') }}" class="btn btn-primary btn-lg">
                                <i class="fas fa-plus me-2"></i>Create Your First Receiver
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Cards Row -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 fw-bold text-primary">
                        <i class="fas fa-chart-bar me-2"></i>Status Overview
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="h4 mb-0 text-success fw-bold">{{ $api_receivers->where('is_active', true)->count() }}</div>
                            <div class="small text-gray-500 fw-bold">Active</div>
                        </div>
                        <div class="col-4">
                            <div class="h4 mb-0 text-warning fw-bold">{{ $api_receivers->where('is_active', false)->count() }}</div>
                            <div class="small text-gray-500 fw-bold">Inactive</div>
                        </div>
                        <div class="col-4">
                            <div class="h4 mb-0 text-info fw-bold">{{ $api_receivers->count() }}</div>
                            <div class="small text-gray-500 fw-bold">Total</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 fw-bold text-primary">
                        <i class="fas fa-shield-alt me-2"></i>Authentication Types
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="h4 mb-0 text-warning fw-bold">{{ $api_receivers->where('auth_type', 'none')->count() }}</div>
                            <div class="small text-gray-500 fw-bold">None</div>
                        </div>
                        <div class="col-4">
                            <div class="h4 mb-0 text-info fw-bold">{{ $api_receivers->where('auth_type', 'api_key')->count() }}</div>
                            <div class="small text-gray-500 fw-bold">API Key</div>
                        </div>
                        <div class="col-4">
                            <div class="h4 mb-0 text-success fw-bold">{{ $api_receivers->where('auth_type', 'bearer_token')->count() }}</div>
                            <div class="small text-gray-500 fw-bold">Bearer Token</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">
                    <i class="fas fa-exclamation-triangle text-danger me-2"></i>Confirm Delete
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="deleteForm" method="POST" style="display: block;">
                @csrf
                @method('DELETE')
                <div class="modal-body">
                    <p>Are you sure you want to delete the API Receiver "<strong><span id="deleteReceiverName"></span></strong>"?</p>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Warning:</strong> This action cannot be undone. All associated data and logs will be permanently removed.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-2"></i>Delete Receiver
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function refreshPage() {
    location.reload();
}

function testJavaScript() {
    alert('JavaScript is working!');
    console.log('Test JavaScript function called');
}

setInterval(function() {
    var modals = document.querySelectorAll('.modal.show');
    if (modals.length === 0) {
        location.reload();
    }
}, 60000);

document.addEventListener('DOMContentLoaded', function() {
    console.log('API Receivers page loaded');
    
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title]'));
    var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Add global error handling
    window.addEventListener('error', function(e) {
        console.error('JavaScript Error:', e.error);
    });
    
    console.log('API Receivers page initialization complete');
});
</script>
@endsection

@section('styles')
<style>
.card {
    border: none;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.icon-circle {
    height: 2.5rem;
    width: 2.5rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.table td {
    vertical-align: middle;
    padding: 1rem 0.75rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    color: #5a5c69;
    padding: 1rem 0.75rem;
}

.methods-container {
    min-height: 24px;
}

.badge {
    font-size: 0.75em;
    font-weight: 600;
}

.btn-group .btn {
    border-radius: 0.375rem !important;
    margin-right: 2px;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.text-gray-300 {
    color: #dddfeb !important;
}

.text-gray-400 {
    color: #858796 !important;
}

.text-gray-500 {
    color: #6c757d !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.border-start {
    border-left: var(--bs-border-width) var(--bs-border-style) var(--bs-border-color) !important;
}

.border-4 {
    border-width: 4px !important;
}

.fw-bold {
    font-weight: 700 !important;
}

.text-xs {
    font-size: 0.75rem;
}

@media (max-width: 768px) {
    .btn-group {
        flex-direction: column;
    }
    
    .btn-group .btn {
        margin-right: 0;
        margin-bottom: 2px;
    }
    
    .table-responsive {
        font-size: 0.875rem;
    }
}

.card {
    transition: transform 0.2s ease-in-out;
}

.card:hover {
    transform: translateY(-2px);
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
}
</style>
@endsection