@extends('layouts.app')

@section('title', 'API Receiver Logs')

@section('styles')
<style>
/* Badge Colors */
.badge.bg-success {
    color: #2b4a34 !important;
    background-color: #9de3bf !important;
}

.badge.bg-primary {
    color: #1a365d !important;
    background-color: #9ec5fe !important;
}

.badge.bg-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7 !important;
}

.badge.bg-warning {
    color: #603b00 !important;
    background-color: #ffd699 !important;
}

.badge.bg-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea !important;
}

.badge.bg-danger {
    color: #fff !important;
    background-color: #dc3545 !important;
}
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-list me-2"></i>Logs for {{ $apiReceiver->name }}
        </h1>
        <div class="btn-group">
            <a href="{{ route('api-receivers.show', $apiReceiver) }}" class="btn btn-primary">
                <i class="fas fa-eye me-2"></i>View Details
            </a>
            <a href="{{ route('api-receivers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-history me-2"></i>Receive Logs
            </h6>
        </div>
        <div class="card-body">
            @if($logs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Status</th>
                                <th>Received At</th>
                                <th>IP Address</th>
                                <th>Data Size</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($logs as $log)
                                <tr>
                                    <td>
                                        <span class="badge bg-{{ $log->status_code >= 200 && $log->status_code < 300 ? 'success' : 'danger' }}">
                                            {{ $log->status_code >= 200 && $log->status_code < 300 ? 'Success' : 'Error' }}
                                        </span>
                                    </td>
                                    <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                                    <td>{{ $log->ip_address }}</td>
                                    <td>{{ $log->body ? strlen($log->body) . ' bytes' : 'N/A' }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" onclick="showLogDetails({{ $log->id }})">
                                            <i class="fas fa-eye"></i> View
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                {{ $logs->links() }}
            @else
                <div class="text-center text-gray-500">
                    <i class="fas fa-inbox fa-3x mb-3"></i>
                    <div class="h5">No logs found</div>
                    <div>Logs will appear here when data is received</div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection 