<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>API Receiver Documentation - {{ $apiReceiver->name }}</title>
    <style>
        body { 
            font-family: DejaVu Sans, Arial, sans-serif; 
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 20px;
        }
        .header { 
            font-size: 24px; 
            font-weight: bold; 
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .section { 
            margin-bottom: 20px; 
            page-break-inside: avoid;
        }
        .section-title {
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0 10px 0;
            color: #34495e;
            border-left: 3px solid #3498db;
            padding-left: 10px;
        }
        .info-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .info-row {
            display: table-row;
        }
        .info-label { 
            font-weight: bold; 
            color: #2c3e50;
            width: 150px;
            padding: 6px;
            background-color: #ecf0f1;
            border: 1px solid #bdc3c7;
        }
        .info-value { 
            padding: 6px;
            border: 1px solid #bdc3c7;
            word-break: break-word;
        }
        .code-block { 
            background: #f8f9fa; 
            padding: 12px; 
            border: 1px solid #e9ecef;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            font-size: 10px;
            overflow-x: auto;
            margin: 8px 0;
        }
        .status-active {
            color: #27ae60;
            font-weight: bold;
        }
        .status-inactive {
            color: #e74c3c;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">API Receiver Documentation</div>
    
    <!-- Basic Information -->
    <div class="section-title">Basic Information</div>
    <div class="section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Name</div>
                <div class="info-value">{{ $apiReceiver->name }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Endpoint</div>
                <div class="info-value">/api/in/{{ $apiReceiver->endpoint }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Method</div>
                <div class="info-value">{{ $apiReceiver->allowed_methods }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Target Table</div>
                <div class="info-value">{{ $apiReceiver->target_table ?? 'Not specified' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <span class="{{ $apiReceiver->status === 'active' ? 'status-active' : 'status-inactive' }}">
                        {{ $apiReceiver->status === 'active' ? 'Active' : 'Inactive' }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Authentication -->
    <div class="section-title">Authentication</div>
    <div class="section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Type</div>
                <div class="info-value">{{ ucfirst(str_replace('_', ' ', $apiReceiver->auth_type ?? 'none')) }}</div>
            </div>
            @if($apiReceiver->auth_type === 'basic_auth')
            <div class="info-row">
                <div class="info-label">Username</div>
                <div class="info-value">{{ $apiReceiver->auth_username }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Password</div>
                <div class="info-value">{{ $apiReceiver->auth_password }}</div>
            </div>
            @elseif($apiReceiver->auth_type === 'api_key')
            <div class="info-row">
                <div class="info-label">API Key</div>
                <div class="info-value">{{ $apiReceiver->auth_token }}</div>
            </div>
            @elseif($apiReceiver->auth_type === 'bearer_token')
            <div class="info-row">
                <div class="info-label">Bearer Token</div>
                <div class="info-value">{{ $apiReceiver->auth_token }}</div>
            </div>
            @endif
        </div>
    </div>

    <!-- Request Example -->
    <div class="section-title">Request Body Example (Based on {{ $apiReceiver->target_table }} table)</div>
    <div class="section">
        @if($sampleData && count($sampleData) > 0)
            <div class="code-block">
{{ json_encode($sampleData, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) }}
            </div>
        @else
            <div class="code-block">
{
    "name": "John Doe",
    "email": "john.doe@example.com",
    "phone": "+62812345678",
    "created_at": "{{ now()->toISOString() }}"
}
            </div>
        @endif
    </div>

    <!-- Response Example -->
    <div class="section-title">Response Example</div>
    <div class="section">
        <div class="code-block">
{
    "success": true,
    "message": "Data received successfully",
    "data": {
        "received_at": "{{ now()->toISOString() }}",
        "endpoint": "{{ $apiReceiver->endpoint }}",
        "records_processed": 1
    }
}
        </div>
    </div>
</body>
</html> 