@extends('layouts.app')

@section('title', 'Edit API Source')

@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.index') }}">API Sources</a>
    </li>
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.show', $apiSource) }}">{{ $apiSource->name }}</a>
    </li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Alert Messages -->
    <div id="alert-container">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        @if(session('csrf_fixed'))
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-shield-alt me-2"></i>
                <strong>CSRF Token Fixed!</strong> Form is now ready to submit.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0 mt-2">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        <!-- CSRF Error Quick Fix -->
        <div id="csrf-error-alert" class="alert alert-warning alert-dismissible fade" style="display: none;" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <strong>CSRF Token Error Detected!</strong> 
            <p class="mb-2">If you're getting cookie/CSRF errors, click the button below to fix:</p>
            <a href="/fix-csrf" class="btn btn-sm btn-warning me-2">
                <i class="fas fa-wrench me-1"></i>Auto-Fix CSRF
            </a>
            <a href="/csrf-fix.html" class="btn btn-sm btn-info">
                <i class="fas fa-tools me-1"></i>Manual Fix
            </a>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-edit me-2"></i>Edit API Source
                </h1>
                <div class="btn-group">
                    <a href="{{ route('api-sources.show', $apiSource) }}" class="btn btn-info">
                        <i class="fas fa-eye me-2"></i>View Details
                    </a>
                    <a href="{{ route('api-sources.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-database me-2"></i>Edit API Source Information
                    </h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('api-sources.update', $apiSource) }}" method="POST" id="editForm" novalidate>
                        @csrf
                        @method('PUT')
                        
                        <!-- Basic Information -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $apiSource->name) }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                        <option value="">Select Status</option>
                                        <option value="active" {{ old('status', $apiSource->status) == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ old('status', $apiSource->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="3" 
                                      placeholder="Brief description of this API source">{{ old('description', $apiSource->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- API Configuration -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-cog me-2"></i>API Configuration
                        </h5>

                        <div class="form-group mb-3">
                            <label for="url" class="form-label">API URL <span class="text-danger">*</span></label>
                            <input type="url" class="form-control @error('url') is-invalid @enderror" 
                                   id="url" name="url" value="{{ old('url', $apiSource->url) }}" 
                                   placeholder="https://api.example.com/data" required>
                            @error('url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="method" class="form-label">HTTP Method <span class="text-danger">*</span></label>
                                    <select class="form-control @error('method') is-invalid @enderror" id="method" name="method" required>
                                        <option value="">Select Method</option>
                                        <option value="GET" {{ old('method', $apiSource->method) == 'GET' ? 'selected' : '' }}>GET</option>
                                        <option value="POST" {{ old('method', $apiSource->method) == 'POST' ? 'selected' : '' }}>POST</option>
                                        <option value="PUT" {{ old('method', $apiSource->method) == 'PUT' ? 'selected' : '' }}>PUT</option>
                                        <option value="DELETE" {{ old('method', $apiSource->method) == 'DELETE' ? 'selected' : '' }}>DELETE</option>
                                    </select>
                                    @error('method')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="table_name" class="form-label">Table Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('table_name') is-invalid @enderror" 
                                           id="table_name" name="table_name" value="{{ old('table_name', $apiSource->table_name) }}" 
                                           placeholder="destination_table" required>
                                    @error('table_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Authentication -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-shield-alt me-2"></i>Authentication
                        </h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="auth_type" class="form-label">Authentication Type <span class="text-danger">*</span></label>
                                    <select class="form-control @error('auth_type') is-invalid @enderror" 
                                            id="auth_type" name="auth_type" required onchange="toggleAuthToken()">
                                        <option value="">Select Auth Type</option>
                                        <option value="none" {{ old('auth_type', $apiSource->auth_type) == 'none' ? 'selected' : '' }}>None</option>
                                        <option value="api_key" {{ old('auth_type', $apiSource->auth_type) == 'api_key' ? 'selected' : '' }}>API Key</option>
                                        <option value="bearer_token" {{ old('auth_type', $apiSource->auth_type) == 'bearer_token' ? 'selected' : '' }}>Bearer Token</option>
                                        <option value="basic_auth" {{ old('auth_type', $apiSource->auth_type) == 'basic_auth' ? 'selected' : '' }}>Basic Auth</option>
                                    </select>
                                    @error('auth_type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3" id="auth_token_group" style="display: none;">
                                    <label for="auth_token" class="form-label">Authentication Token</label>
                                    <input type="text" class="form-control @error('auth_token') is-invalid @enderror" 
                                           id="auth_token" name="auth_token" value="{{ old('auth_token', $apiSource->auth_token) }}" 
                                           placeholder="Enter your API key or token">
                                    @error('auth_token')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    @if($apiSource->auth_token)
                                        <small class="form-text text-muted">Leave empty to keep current token</small>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3" id="auth_basic_group" style="display: none;">
                                    <label for="auth_username" class="form-label">Basic Auth Username</label>
                                    <input type="text" class="form-control @error('auth_username') is-invalid @enderror" id="auth_username" name="auth_username" value="{{ old('auth_username', $apiSource->auth_username) }}" placeholder="Enter username">
                                    @error('auth_username')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <label for="auth_password" class="form-label mt-2">Basic Auth Password</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control @error('auth_password') is-invalid @enderror" id="auth_password" name="auth_password" value="{{ old('auth_password', $apiSource->auth_password) }}" placeholder="Enter password">
                                        <button class="btn btn-outline-secondary" type="button" id="togglePassword"><i class="fas fa-eye"></i></button>
                                    </div>
                                    @error('auth_password')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Scheduling -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-clock me-2"></i>Scheduling
                        </h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="schedule_type" class="form-label">Schedule Type <span class="text-danger">*</span></label>
                                    <select class="form-control @error('schedule_type') is-invalid @enderror" 
                                            id="schedule_type" name="schedule_type" required onchange="toggleScheduleFrequency()">
                                        <option value="">Select Schedule</option>
                                        <option value="manual" {{ old('schedule_type', $apiSource->schedule_type) == 'manual' ? 'selected' : '' }}>Manual</option>
                                        <option value="hourly" {{ old('schedule_type', $apiSource->schedule_type) == 'hourly' ? 'selected' : '' }}>Hourly</option>
                                        <option value="daily" {{ old('schedule_type', $apiSource->schedule_type) == 'daily' ? 'selected' : '' }}>Daily</option>
                                        <option value="weekly" {{ old('schedule_type', $apiSource->schedule_type) == 'weekly' ? 'selected' : '' }}>Weekly</option>
                                        <option value="monthly" {{ old('schedule_type', $apiSource->schedule_type) == 'monthly' ? 'selected' : '' }}>Monthly</option>
                                    </select>
                                    @error('schedule_type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3" id="schedule_frequency_group" style="display: none;">
                                    <label for="schedule_frequency" class="form-label">Schedule Frequency</label>
                                    <input type="number" class="form-control @error('schedule_frequency') is-invalid @enderror" 
                                           id="schedule_frequency" name="schedule_frequency" 
                                           value="{{ old('schedule_frequency', $apiSource->schedule_frequency) }}" 
                                           min="1" placeholder="e.g., 1">
                                    @error('schedule_frequency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Number of intervals (e.g., every 2 hours, every 3 days)</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3" id="schedule_time_group" style="display: none;">
                                    <label for="schedule_time" class="form-label">Schedule Time</label>
                                    <input type="time" class="form-control @error('schedule_time') is-invalid @enderror" 
                                           id="schedule_time" name="schedule_time" 
                                           value="{{ old('schedule_time', $apiSource->schedule_time) }}">
                                    @error('schedule_time')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Time of day to run (for daily/weekly/monthly schedules)</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3" id="schedule_day_group" style="display: none;">
                                    <label for="schedule_day" class="form-label">Schedule Day</label>
                                    <select class="form-control @error('schedule_day') is-invalid @enderror" id="schedule_day" name="schedule_day">
                                        <option value="">Select Day</option>
                                        <option value="monday" {{ old('schedule_day', $apiSource->schedule_day) == 'monday' ? 'selected' : '' }}>Monday</option>
                                        <option value="tuesday" {{ old('schedule_day', $apiSource->schedule_day) == 'tuesday' ? 'selected' : '' }}>Tuesday</option>
                                        <option value="wednesday" {{ old('schedule_day', $apiSource->schedule_day) == 'wednesday' ? 'selected' : '' }}>Wednesday</option>
                                        <option value="thursday" {{ old('schedule_day', $apiSource->schedule_day) == 'thursday' ? 'selected' : '' }}>Thursday</option>
                                        <option value="friday" {{ old('schedule_day', $apiSource->schedule_day) == 'friday' ? 'selected' : '' }}>Friday</option>
                                        <option value="saturday" {{ old('schedule_day', $apiSource->schedule_day) == 'saturday' ? 'selected' : '' }}>Saturday</option>
                                        <option value="sunday" {{ old('schedule_day', $apiSource->schedule_day) == 'sunday' ? 'selected' : '' }}>Sunday</option>
                                    </select>
                                    @error('schedule_day')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Day of week (for weekly schedules)</small>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Settings -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-cogs me-2"></i>Advanced Settings
                        </h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="timeout" class="form-label">Request Timeout (seconds)</label>
                                    <input type="number" class="form-control @error('timeout') is-invalid @enderror" 
                                           id="timeout" name="timeout" value="{{ old('timeout', $apiSource->timeout ?? 30) }}" 
                                           min="1" max="300" placeholder="30">
                                    @error('timeout')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Maximum time to wait for API response</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="retry_attempts" class="form-label">Retry Attempts</label>
                                    <input type="number" class="form-control @error('retry_attempts') is-invalid @enderror" 
                                           id="retry_attempts" name="retry_attempts" value="{{ old('retry_attempts', $apiSource->retry_attempts ?? 3) }}" 
                                           min="0" max="10" placeholder="3">
                                    @error('retry_attempts')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Number of retry attempts on failure</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="headers" class="form-label">Custom Headers (JSON)</label>
                            <textarea class="form-control @error('headers') is-invalid @enderror" 
                                      id="headers" name="headers" rows="3" 
                                      placeholder='{"Content-Type": "application/json", "Accept": "application/json"}'>{{ old('headers', $apiSource->headers) }}</textarea>
                            @error('headers')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">Additional HTTP headers in JSON format</small>
                        </div>

                        <div class="form-group mb-3">
                            <label for="parameters" class="form-label">Query Parameters (JSON)</label>
                            <textarea class="form-control @error('parameters') is-invalid @enderror" 
                                      id="parameters" name="parameters" rows="3" 
                                      placeholder='{"limit": 100, "format": "json"}'>{{ old('parameters', $apiSource->parameters) }}</textarea>
                            @error('parameters')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">Query parameters to append to URL</small>
                        </div>

                        <!-- Form Actions -->
                        <hr class="my-4">
                        <div class="form-group mt-4">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                                    </button>
                                </div>
                                <div class="col-12 mb-3">
                                    <button type="button" class="btn btn-info me-2" id="simpleSubmitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>SIMPLE SUBMIT
                                    </button>
                                    <button type="button" class="btn btn-info me-2" onclick="testConnection()">
                                        <i class="fas fa-plug me-2"></i>Test Connection
                                    </button>
                                    <a href="{{ route('api-sources.index') }}" class="btn btn-secondary me-2">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                    <a href="/debug/test-edit" class="btn btn-warning me-2" target="_blank">
                                        <i class="fas fa-bug me-2"></i>Debug Test
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>Quick Info
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Current Status:</strong>
                        <span class="badge bg-{{ $apiSource->status == 'active' ? 'success' : 'danger' }}">
                            {{ ucfirst($apiSource->status) }}
                        </span>
                    </div>
                    <div class="mb-3">
                        <strong>Last Sync:</strong>
                        <br>{{ $apiSource->last_sync_at ? $apiSource->last_sync_at->format('M d, Y H:i:s') : 'Never' }}
                    </div>
                    <div class="mb-3">
                        <strong>Total Records:</strong>
                        <br>{{ number_format($apiSource->total_records ?? 0) }}
                    </div>
                    <div class="mb-3">
                        <strong>Created:</strong>
                        <br>{{ $apiSource->created_at->format('M d, Y H:i:s') }}
                    </div>
                    <div class="mb-3">
                        <strong>Updated:</strong>
                        <br>{{ $apiSource->updated_at->format('M d, Y H:i:s') }}
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-lightbulb me-2"></i>Tips
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Test your connection before saving
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Use HTTPS URLs for security
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Set appropriate timeouts
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            Configure retry attempts for reliability
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
// Toggle authentication fields based on auth type
function toggleAuthToken() {
    const authType = document.getElementById('auth_type').value;
    const authTokenGroup = document.getElementById('auth_token_group');
    const authBasicGroup = document.getElementById('auth_basic_group');
    
    // Hide all auth fields first
    authTokenGroup.style.display = 'none';
    authBasicGroup.style.display = 'none';
    
    // Show relevant fields based on auth type
    if (authType === 'api_key' || authType === 'bearer_token') {
        authTokenGroup.style.display = 'block';
    } else if (authType === 'basic_auth') {
        authBasicGroup.style.display = 'block';
    }
}

// Toggle schedule fields based on schedule type
function toggleScheduleFrequency() {
    const scheduleType = document.getElementById('schedule_type').value;
    const frequencyGroup = document.getElementById('schedule_frequency_group');
    const timeGroup = document.getElementById('schedule_time_group');
    const dayGroup = document.getElementById('schedule_day_group');
    
    // Hide all schedule fields first
    frequencyGroup.style.display = 'none';
    timeGroup.style.display = 'none';
    dayGroup.style.display = 'none';
    
    // Show relevant fields based on schedule type
    if (scheduleType === 'hourly') {
        frequencyGroup.style.display = 'block';
    } else if (scheduleType === 'daily') {
        frequencyGroup.style.display = 'block';
        timeGroup.style.display = 'block';
    } else if (scheduleType === 'weekly') {
        frequencyGroup.style.display = 'block';
        timeGroup.style.display = 'block';
        dayGroup.style.display = 'block';
    } else if (scheduleType === 'monthly') {
        frequencyGroup.style.display = 'block';
        timeGroup.style.display = 'block';
    }
}

// Toggle password visibility
document.addEventListener('DOMContentLoaded', function() {
    const togglePassword = document.getElementById('togglePassword');
    const passwordField = document.getElementById('auth_password');
    
    if (togglePassword && passwordField) {
        togglePassword.addEventListener('click', function() {
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            this.innerHTML = type === 'password' ? '<i class="fas fa-eye"></i>' : '<i class="fas fa-eye-slash"></i>';
        });
    }
    
    // Initialize auth and schedule toggles
    toggleAuthToken();
    toggleScheduleFrequency();
    
    // Alternative submit button
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    if (altSubmitBtn) {
        altSubmitBtn.addEventListener('click', submitFormDirectly);
    }
    
    // Simple submit button
    const simpleSubmitBtn = document.getElementById('simpleSubmitBtn');
    if (simpleSubmitBtn) {
        simpleSubmitBtn.addEventListener('click', submitSimple);
    }
    
    // Form validation
    const form = document.getElementById('editForm');
    const saveBtn = document.getElementById('saveBtn');
    
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('Form submitted via primary button');
            
            // Disable buttons during submission
            if (saveBtn) {
                saveBtn.disabled = true;
                saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>UPDATING...';
            }
            
            // Re-enable buttons after delay if submission fails
            setTimeout(() => {
                if (saveBtn && saveBtn.disabled) {
                    saveBtn.disabled = false;
                    saveBtn.innerHTML = '<i class="fas fa-save me-2"></i>UPDATE API SOURCE';
                }
            }, 15000);
        });
    }
    
    // CSRF error detection
    window.addEventListener('error', function(e) {
        if (e.message && e.message.includes('CSRF')) {
            const csrfAlert = document.getElementById('csrf-error-alert');
            if (csrfAlert) {
                csrfAlert.style.display = 'block';
            }
        }
    });
    
    console.log('All event listeners set up successfully!');
});

// Test connection function
function testConnection() {
    const form = document.getElementById('editForm');
    const formData = new FormData(form);
    
    // Show loading state
    const testBtn = event.target;
    const originalText = testBtn.innerHTML;
    testBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Testing...';
    testBtn.disabled = true;
    
    fetch('/api-sources/test-connection', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Connection successful! ' + data.message);
        } else {
            alert('Connection failed: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error testing connection: ' + error.message);
    })
    .finally(() => {
        testBtn.innerHTML = originalText;
        testBtn.disabled = false;
    });
}

// Alternative submit function
function submitFormDirectly() {
    console.log('Alternative submit triggered');
    
    const form = document.getElementById('editForm');
    const saveBtn = document.getElementById('saveBtn');
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    
    if (!form) return;
    
    // Validate required fields manually
    const requiredFields = form.querySelectorAll('[required]');
    let isValid = true;
    let firstInvalidField = null;
    
    requiredFields.forEach(field => {
        if (!field.value.trim()) {
            isValid = false;
            field.classList.add('is-invalid');
            if (!firstInvalidField) {
                firstInvalidField = field;
            }
        } else {
            field.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        alert('Please fill in all required fields!');
        if (firstInvalidField) {
            firstInvalidField.focus();
        }
        return;
    }
    
    // Show loading state
    if (altSubmitBtn) {
        altSubmitBtn.disabled = true;
        altSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
    }
    if (saveBtn) {
        saveBtn.disabled = true;
    }
    
    alert('Submitting form data...');
    
    // Submit using fetch API with direct POST
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json, text/html',
        }
    })
    .then(response => {
        console.log('Response received:', response.status);
        
        if (response.ok) {
            alert('Form submitted successfully! Redirecting...');
            setTimeout(() => {
                window.location.href = '/api-sources';
            }, 1500);
        } else {
            return response.text().then(text => {
                alert('Submission failed: ' + response.statusText);
                console.error('Error response:', text);
            });
        }
    })
    .catch(error => {
        console.error('Submit error:', error);
        alert('Network error: ' + error.message);
    })
    .finally(() => {
        // Re-enable buttons
        if (altSubmitBtn) {
            altSubmitBtn.disabled = false;
            altSubmitBtn.innerHTML = '<i class="fas fa-rocket me-2"></i>SUBMIT NOW';
        }
        if (saveBtn) {
            saveBtn.disabled = false;
        }
    });
}

// Simple submit function
function submitSimple() {
    console.log('Simple submit triggered');
    
    const form = document.getElementById('editForm');
    if (!form) return;
    
    // Simple validation check
    const name = document.getElementById('name')?.value;
    const url = document.getElementById('url')?.value;
    const method = document.getElementById('method')?.value;
    const tableName = document.getElementById('table_name')?.value;
    const authType = document.getElementById('auth_type')?.value;
    const scheduleType = document.getElementById('schedule_type')?.value;
    const status = document.getElementById('status')?.value;
    
    if (!name || !url || !method || !tableName || !authType || !scheduleType || !status) {
        alert('Please fill in all required fields!');
        return;
    }
    
    // Show confirmation
    const confirmed = confirm(`Ready to update this API Source?\n\nName: ${name}\nURL: ${url}\nMethod: ${method}\nTable: ${tableName}\n\nClick OK to proceed.`);
    
    if (confirmed) {
        // Create a simple loading message
        const simpleBtn = document.getElementById('simpleSubmitBtn');
        if (simpleBtn) {
            simpleBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
            simpleBtn.disabled = true;
        }
        
        // Add a hidden field to identify this submission method
        const hiddenField = document.createElement('input');
        hiddenField.type = 'hidden';
        hiddenField.name = 'submit_method';
        hiddenField.value = 'simple';
        form.appendChild(hiddenField);
        
        // Submit the form normally
        form.submit();
    }
}
</script>
@endsection 