@extends('layouts.app')

@section('title', 'API Source Logs')

@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.index') }}">API Sources</a>
    </li>
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.show', $apiSource) }}">{{ $apiSource->name }}</a>
    </li>
    <li class="breadcrumb-item active">Logs</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-list me-2"></i>{{ $apiSource->name }} - Activity Logs
                </h1>
                <div class="btn-group">
                    <button type="button" class="btn btn-success" onclick="importData({{ $apiSource->id }}, '{{ $apiSource->name }}')">
                        <i class="fas fa-download me-2"></i>Import Data
                    </button>
                    <a href="{{ route('api-sources.show', $apiSource) }}" class="btn btn-info">
                        <i class="fas fa-eye me-2"></i>View Details
                    </a>
                    <a href="{{ route('api-sources.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        @php
            $totalLogs = $logs->total();
            $successLogs = $apiSource->apiLogs()->where('status_code', '>=', 200)->where('status_code', '<', 300)->count();
            $errorLogs = $apiSource->apiLogs()->where('status_code', '>=', 400)->count();
            $totalRecords = $apiSource->apiLogs()->where('status_code', '>=', 200)->where('status_code', '<', 300)->get()->sum(function($log) {
                return count(json_decode($log->response_data, true) ?? []);
            });
        @endphp
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Logs</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalLogs }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Successful</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $successLogs }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Failed</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $errorLogs }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Records Imported</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalRecords) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-download fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Activity Logs</h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Actions:</div>
                            <a class="dropdown-item" href="#" onclick="refreshPage()">
                                <i class="fas fa-sync fa-sm fa-fw mr-2 text-gray-400"></i>
                                Refresh
                            </a>
                            <a class="dropdown-item" href="#" onclick="clearLogs()">
                                <i class="fas fa-trash fa-sm fa-fw mr-2 text-gray-400"></i>
                                Clear All Logs
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if($logs->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Date & Time</th>
                                        <th>Response</th>
                                        <th>Records</th>
                                        <th>Response Time</th>
                                        <th>Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($logs as $log)
                                        <tr>
                                            <td>
                                                <span class="badge bg-{{ $log->status_code >= 200 && $log->status_code < 300 ? 'success' : 'danger' }}">
                                                    <i class="fas fa-{{ $log->status_code >= 200 && $log->status_code < 300 ? 'check' : 'times' }} me-1"></i>
                                                    {{ $log->status_code >= 200 && $log->status_code < 300 ? 'Success' : 'Failed' }}
                                                </span>
                                            </td>
                                            <td>
                                                <div class="font-weight-bold">{{ $log->created_at->format('d M Y') }}</div>
                                                <div class="small text-gray-500">{{ $log->created_at->format('H:i:s') }}</div>
                                                <div class="small text-muted">{{ $log->created_at->diffForHumans() }}</div>
                                            </td>
                                            <td>
                                                @if($log->status_code)
                                                    <span class="badge bg-{{ $log->status_code < 300 ? 'success' : ($log->status_code < 400 ? 'warning' : 'danger') }}">
                                                        {{ $log->status_code }}
                                                    </span>
                                                    <div class="small text-muted">
                                                        {{ $log->status_code < 300 ? 'Success' : ($log->status_code < 400 ? 'Redirect' : 'Error') }}
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->status_code >= 200 && $log->status_code < 300 && $log->response_data)
                                                    <div class="font-weight-bold text-success">{{ number_format(count(json_decode($log->response_data, true) ?? [])) }}</div>
                                                    <div class="small text-muted">records</div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->response_time)
                                                    <div class="font-weight-bold">{{ number_format($log->response_time, 2) }}s</div>
                                                    <div class="small text-muted">
                                                        @if($log->response_time < 1)
                                                            <span class="text-success">Fast</span>
                                                        @elseif($log->response_time < 5)
                                                            <span class="text-warning">Normal</span>
                                                        @else
                                                            <span class="text-danger">Slow</span>
                                                        @endif
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->status_code >= 400 && $log->error_message)
                                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                                            onclick="showErrorDetails('{{ addslashes($log->error_message) }}', '{{ $log->created_at->format('d M Y, H:i:s') }}')">
                                                        <i class="fas fa-exclamation-triangle me-1"></i>View Error
                                                    </button>
                                                @elseif($log->status_code >= 200 && $log->status_code < 300)
                                                    <button type="button" class="btn btn-sm btn-outline-success" 
                                                            onclick="showSuccessDetails({{ count(json_decode($log->response_data, true) ?? []) }}, '{{ $log->created_at->format('d M Y, H:i:s') }}', {{ $log->response_time }}, {{ $log->status_code }})">
                                                        <i class="fas fa-info-circle me-1"></i>View Details
                                                    </button>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="small text-muted">
                                Showing {{ $logs->firstItem() }} to {{ $logs->lastItem() }} of {{ $logs->total() }} results
                            </div>
                            {{ $logs->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="mb-3">
                                <i class="fas fa-history fa-3x text-gray-300"></i>
                            </div>
                            <h5 class="text-gray-500">No Activity Logs Found</h5>
                            <p class="text-gray-400">Import data to see activity logs here.</p>
                            <button type="button" class="btn btn-primary" onclick="importData({{ $apiSource->id }}, '{{ $apiSource->name }}')">
                                <i class="fas fa-download me-2"></i>Import Data Now
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Error Details Modal -->
<div class="modal fade" id="errorModal" tabindex="-1" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="errorModalLabel">
                    <i class="fas fa-exclamation-triangle me-2"></i>Error Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <strong>Timestamp:</strong> <span id="errorTimestamp"></span>
                </div>
                <div class="mb-3">
                    <strong>Error Message:</strong>
                    <div class="bg-light p-3 rounded mt-2">
                        <code id="errorMessage"></code>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Success Details Modal -->
<div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-labelledby="successModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="successModalLabel">
                    <i class="fas fa-check-circle me-2"></i>Success Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-6">
                        <div class="text-center">
                            <div class="h4 text-success mb-0" id="successRecords">-</div>
                            <small class="text-muted">Records Imported</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-center">
                            <div class="h4 text-info mb-0" id="successTime">-</div>
                            <small class="text-muted">Response Time</small>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="mb-3">
                    <strong>Timestamp:</strong> <span id="successTimestamp"></span>
                </div>
                <div class="mb-3">
                    <strong>HTTP Status:</strong> <span id="successStatus"></span>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function showErrorDetails(message, timestamp) {
    document.getElementById('errorMessage').textContent = message;
    document.getElementById('errorTimestamp').textContent = timestamp;
    
    const modal = new bootstrap.Modal(document.getElementById('errorModal'));
    modal.show();
}

function showSuccessDetails(records, timestamp, responseTime, statusCode) {
    document.getElementById('successRecords').textContent = records ? records.toLocaleString() : '-';
    document.getElementById('successTime').textContent = responseTime ? responseTime + 's' : '-';
    document.getElementById('successTimestamp').textContent = timestamp;
    document.getElementById('successStatus').textContent = statusCode ? statusCode : '-';
    
    const modal = new bootstrap.Modal(document.getElementById('successModal'));
    modal.show();
}

function importData(id, name) {
    if (confirm(`Import data from "${name}"?`)) {
        window.LoadingOverlay.show('Importing data...');
        
        fetch(`/api-sources/${id}/import`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            window.LoadingOverlay.hide();
            if (data.success) {
                window.Toast.success(data.message || 'Data imported successfully');
                setTimeout(() => location.reload(), 2000);
            } else {
                window.Toast.error(data.message || 'Import failed');
            }
        })
        .catch(error => {
            window.LoadingOverlay.hide();
            window.Toast.error('Import failed: ' + error.message);
        });
    }
}

function clearLogs() {
    if (confirm('Are you sure you want to clear all logs? This action cannot be undone.')) {
        window.LoadingOverlay.show('Clearing logs...');
        
        fetch(`/api-sources/{{ $apiSource->id }}/clear-logs`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            window.LoadingOverlay.hide();
            if (data.success) {
                window.Toast.success('Logs cleared successfully');
                setTimeout(() => location.reload(), 1500);
            } else {
                window.Toast.error('Failed to clear logs');
            }
        })
        .catch(error => {
            window.LoadingOverlay.hide();
            window.Toast.error('Failed to clear logs: ' + error.message);
        });
    }
}

function refreshPage() {
    location.reload();
}
</script>
@endpush
@endsection 