@extends('layouts.app')

@section('title', 'PDF Preview - ' . $apiSource->name)

@section('content')
<div class="container-fluid px-4">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-eye me-2"></i>PDF Preview - {{ $apiSource->name }}
        </h1>
        <div>
            <a href="{{ route('api-sources.export-pdf', $apiSource) }}" class="btn btn-success">
                <i class="fas fa-download me-2"></i>Download PDF
            </a>
            <a href="{{ route('api-sources.index') }}" class="btn btn-secondary ms-2">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    <!-- PDF Preview Container -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-file-pdf me-2"></i>Documentation Preview
            </h6>
        </div>
        <div class="card-body">
            <!-- Basic Information -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-info-circle me-2"></i>Basic Information
                    </h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th width="200" class="bg-light">Name</th>
                                <td>{{ $apiSource->name }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Description</th>
                                <td>{{ $apiSource->description ?? 'No description provided' }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">API URL</th>
                                <td><code>{{ $apiSource->url }}</code></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Method</th>
                                <td><span class="badge bg-primary">{{ $apiSource->method }}</span></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Target Table</th>
                                <td><code>{{ $apiSource->table_name }}</code></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Status</th>
                                <td>
                                    @if($apiSource->status === 'active')
                                        <span class="badge bg-success">🟢 Active</span>
                                    @else
                                        <span class="badge bg-danger">🔴 Inactive</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th class="bg-light">Schedule Type</th>
                                <td>{{ ucfirst($apiSource->schedule_type ?? 'Manual') }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Created</th>
                                <td>{{ $apiSource->created_at->format('d M Y, H:i:s') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Authentication -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-lock me-2"></i>Authentication
                    </h4>
                    <div class="alert alert-info">
                        @if($apiSource->auth_type === 'basic_auth')
                            <strong>Authentication Type:</strong> Basic Auth
                            <br><strong>Username:</strong> {{ $apiSource->auth_username }}
                            <br><strong>Password:</strong> {{ $apiSource->auth_password }}
                            <br><strong>Encoded:</strong> <code>{{ base64_encode($apiSource->auth_username . ':' . $apiSource->auth_password) }}</code>
                        @elseif($apiSource->auth_type === 'api_key')
                            <strong>Authentication Type:</strong> API Key
                            <br><strong>API Key:</strong> <code>{{ $apiSource->auth_token ?? 'Not configured' }}</code>
                        @elseif($apiSource->auth_type === 'bearer_token')
                            <strong>Authentication Type:</strong> Bearer Token
                            <br><strong>Bearer Token:</strong> <code>{{ $apiSource->auth_token ?? 'Not configured' }}</code>
                        @else
                            <strong>Authentication Type:</strong> No Authentication Required
                        @endif
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-chart-bar me-2"></i>Import Statistics
                    </h4>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body text-center">
                                    <h3>{{ $stats['total_imports'] ?? 0 }}</h3>
                                    <p class="mb-0">Total Imports</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-success text-white">
                                <div class="card-body text-center">
                                    <h3>{{ $stats['successful_imports'] ?? 0 }}</h3>
                                    <p class="mb-0">Successful</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body text-center">
                                    <h3>{{ $stats['failed_imports'] ?? 0 }}</h3>
                                    <p class="mb-0">Failed</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-info text-white">
                                <div class="card-body text-center">
                                    <h3>{{ $stats['next_import'] ? $stats['next_import']->format('H:i') : 'N/A' }}</h3>
                                    <p class="mb-0">Next Import</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Request Examples -->
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-paper-plane me-2"></i>Request Examples</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>🌐 Base URL:</strong> {{ $apiSource->url }}<br>
                        <strong>📡 Method:</strong> {{ $apiSource->method }}
                    </div>

                    <div class="mb-3">
                        <strong>📋 Request Headers:</strong>
                        <pre><code>Accept: application/json
Content-Type: application/json
@if($apiSource->auth_type === 'basic_auth')
Authorization: Basic {{ base64_encode($apiSource->auth_username . ':' . $apiSource->auth_password) }}
@elseif($apiSource->auth_type === 'bearer_token')
Authorization: Bearer {{ $apiSource->auth_token }}
@elseif($apiSource->auth_type === 'api_key')
X-API-Key: {{ $apiSource->auth_token }}
@endif</code></pre>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="fas fa-database me-2"></i>Expected Response Format</h6>
                        </div>
                        <div class="card-body">
                            @if(strtoupper($apiSource->method) === 'POST')
                                <div class="mb-4">
                                    <h6 class="text-success"><i class="fas fa-check-circle me-2"></i>Success Response (200)</h6>
                                    <pre><code>{
    "success": true,
    "message": "Data received successfully",
    "data": {
        "received_at": "{{ now()->toISOString() }}",
        "endpoint": "{{ $apiSource->name }}",
        "records_processed": 1,
        "target_table": "{{ $apiSource->table_name }}"
    },
    "meta": {
        "receiver_id": 1,
        "timestamp": "{{ now()->toISOString() }}"
    }
}</code></pre>
                                </div>
                                <div class="mb-3">
                                    <h6 class="text-danger"><i class="fas fa-exclamation-triangle me-2"></i>Error Response (400/500)</h6>
                                    <pre><code>{
    "success": false,
    "message": "Validation failed",
    "errors": {
        "field_name": ["The field is required"],
        "email": ["The email field must be a valid email address"]
    },
    "meta": {
        "receiver_id": 1,
        "timestamp": "{{ now()->toISOString() }}"
    }
}</code></pre>
                                </div>
                            @else
                                <pre><code>{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Sample Data 1",
            "email": "sample1@example.com",
            "created_at": "{{ now()->toISOString() }}"
        },
        {
            "id": 2,
            "name": "Sample Data 2",
            "email": "sample2@example.com",
            "created_at": "{{ now()->toISOString() }}"
        }
    ],
    "meta": {
        "total_records": 2,
        "timestamp": "{{ now()->toISOString() }}"
    }
}</code></pre>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configuration -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-cog me-2"></i>Configuration
                    </h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th width="200" class="bg-light">Schedule Type</th>
                                <td>{{ ucfirst($apiSource->schedule_type ?? 'Manual') }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Schedule Frequency</th>
                                <td>{{ $apiSource->schedule_frequency ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Last Fetched</th>
                                <td>{{ $apiSource->last_fetched_at ? $apiSource->last_fetched_at->format('d M Y, H:i:s') : 'Never' }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Next Fetch</th>
                                <td>{{ $apiSource->next_fetch_at ? $apiSource->next_fetch_at->format('d M Y, H:i:s') : 'Not scheduled' }}</td>
                            </tr>
                            <tr>
                                <th class="bg-light">Timeout</th>
                                <td>{{ $apiSource->timeout ?? 30 }} seconds</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 