<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>API Source Documentation - {{ $apiSource->name }}</title>
    <style>
        body { 
            font-family: DejaVu Sans, Arial, sans-serif; 
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 20px;
        }
        .header { 
            font-size: 24px; 
            font-weight: bold; 
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .section { 
            margin-bottom: 20px; 
            page-break-inside: avoid;
        }
        .section-title {
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0 10px 0;
            color: #34495e;
            border-left: 3px solid #3498db;
            padding-left: 10px;
        }
        .info-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .info-row {
            display: table-row;
        }
        .info-label { 
            font-weight: bold; 
            color: #2c3e50;
            width: 150px;
            padding: 6px;
            background-color: #ecf0f1;
            border: 1px solid #bdc3c7;
        }
        .info-value { 
            padding: 6px;
            border: 1px solid #bdc3c7;
            word-break: break-word;
        }
        .code-block { 
            background: #f8f9fa; 
            padding: 12px; 
            border: 1px solid #e9ecef;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            font-size: 10px;
            overflow-x: auto;
            margin: 8px 0;
        }
        .status-active {
            color: #27ae60;
            font-weight: bold;
        }
        .status-inactive {
            color: #e74c3c;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">API Source Documentation</div>
    
    <!-- Basic Information -->
    <div class="section-title">Basic Information</div>
    <div class="section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Name</div>
                <div class="info-value">{{ $apiSource->name }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">URL</div>
                <div class="info-value">{{ $apiSource->url }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Method</div>
                <div class="info-value">{{ $apiSource->method }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Target Table</div>
                <div class="info-value">{{ $apiSource->table_name }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <span class="{{ $apiSource->status === 'active' ? 'status-active' : 'status-inactive' }}">
                        {{ $apiSource->status === 'active' ? 'Active' : 'Inactive' }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Authentication -->
    <div class="section-title">Authentication</div>
    <div class="section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Type</div>
                <div class="info-value">{{ ucfirst(str_replace('_', ' ', $apiSource->auth_type ?? 'none')) }}</div>
            </div>
            @if($apiSource->auth_type === 'basic_auth')
            <div class="info-row">
                <div class="info-label">Username</div>
                <div class="info-value">{{ $apiSource->auth_username }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Password</div>
                <div class="info-value">{{ $apiSource->auth_password }}</div>
            </div>
            @elseif($apiSource->auth_type === 'api_key')
            <div class="info-row">
                <div class="info-label">API Key</div>
                <div class="info-value">{{ $apiSource->auth_token }}</div>
            </div>
            @elseif($apiSource->auth_type === 'bearer_token')
            <div class="info-row">
                <div class="info-label">Bearer Token</div>
                <div class="info-value">{{ $apiSource->auth_token }}</div>
            </div>
            @endif
        </div>
    </div>

    <!-- Expected Response Format -->
    <div class="section-title">Expected Response Format</div>
    <div class="section">
        <div class="code-block">
{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Sample Data 1",
            "email": "sample1@example.com",
            "created_at": "{{ now()->toISOString() }}"
        },
        {
            "id": 2,
            "name": "Sample Data 2",
            "email": "sample2@example.com",
            "created_at": "{{ now()->toISOString() }}"
        }
    ],
    "meta": {
        "total_records": 2,
        "timestamp": "{{ now()->toISOString() }}"
    }
}
        </div>
    </div>
</body>
</html> 