@extends('layouts.app')

@section('title', 'Import Statistics - ' . $apiSource->name)

@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.index') }}">API Sources</a>
    </li>
    <li class="breadcrumb-item">
        <a href="{{ route('api-sources.show', $apiSource) }}">{{ $apiSource->name }}</a>
    </li>
    <li class="breadcrumb-item active">Import Statistics</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-chart-bar me-2"></i>Import Statistics - {{ $apiSource->name }}
                </h1>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary" onclick="refreshStats()">
                        <i class="fas fa-sync me-2"></i>Refresh Stats
                    </button>
                    <a href="{{ route('api-sources.data', $apiSource) }}" class="btn btn-info">
                        <i class="fas fa-table me-2"></i>View Data
                    </a>
                    <a href="{{ route('api-sources.show', $apiSource) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Details
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- API Source Info -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>API Source Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Name:</strong></td>
                                    <td>{{ $apiSource->name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>URL:</strong></td>
                                    <td>
                                        <a href="{{ $apiSource->url }}" target="_blank">
                                            {{ Str::limit($apiSource->url, 50) }}
                                            <i class="fas fa-external-link-alt ms-1"></i>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Method:</strong></td>
                                    <td><span class="badge bg-primary">{{ $apiSource->method }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Table:</strong></td>
                                    <td><code>{{ $apiSource->table_name }}</code></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $apiSource->status == 'active' ? 'success' : 'secondary' }}">
                                            {{ ucfirst($apiSource->status) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Schedule:</strong></td>
                                    <td>
                                        <span class="badge bg-info">{{ ucfirst($apiSource->schedule_type) }}</span>
                                        @if($apiSource->schedule_frequency)
                                            <small class="text-muted ms-1">Every {{ $apiSource->schedule_frequency }}{{ $apiSource->schedule_type == 'hourly' ? 'h' : 'd' }}</small>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Auth Type:</strong></td>
                                    <td><span class="badge bg-warning">{{ ucfirst($apiSource->auth_type) }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Last Fetched:</strong></td>
                                    <td>
                                        @if($apiSource->last_fetched_at)
                                            {{ $apiSource->last_fetched_at->format('Y-m-d H:i:s') }}
                                            <small class="text-muted">({{ $apiSource->last_fetched_at->diffForHumans() }})</small>
                                        @else
                                            <span class="text-muted">Never</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Records</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($stats['total_records']) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-database fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Today's Records</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($stats['today_records']) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Schedule Type</div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                {{ ucfirst($stats['schedule_type'] ?? 'Manual') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Table Status</div>
                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                @if($stats['table_exists'])
                                    <span class="text-success">✓ Exists</span>
                                @else
                                    <span class="text-danger">✗ Missing</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-table fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Statistics -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-line me-2"></i>Detailed Import Statistics
                    </h6>
                </div>
                <div class="card-body">
                    @if(!$stats['table_exists'])
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Table Not Found:</strong> {{ $stats['message'] }}
                            <br><br>
                            <button type="button" class="btn btn-primary btn-sm" onclick="autoImportData({{ $apiSource->id }}, '{{ $apiSource->name }}')">
                                <i class="fas fa-robot me-1"></i>Auto Import to Create Table
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <td><strong>Total Records:</strong></td>
                                    <td>{{ number_format($stats['total_records']) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Today's Records:</strong></td>
                                    <td>{{ number_format($stats['today_records']) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Schedule Type:</strong></td>
                                    <td>{{ ucfirst($stats['schedule_type'] ?? 'Manual') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Schedule Frequency:</strong></td>
                                    <td>{{ $stats['schedule_frequency'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Last Import:</strong></td>
                                    <td>
                                        @if($stats['last_import'])
                                            {{ \Carbon\Carbon::parse($stats['last_import'])->format('Y-m-d H:i:s') }}
                                            <small class="text-muted">({{ \Carbon\Carbon::parse($stats['last_import'])->diffForHumans() }})</small>
                                        @else
                                            <span class="text-muted">Never</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Next Import:</strong></td>
                                    <td>
                                        @if($stats['next_import'])
                                            {{ \Carbon\Carbon::parse($stats['next_import'])->format('Y-m-d H:i:s') }}
                                            <small class="text-muted">({{ \Carbon\Carbon::parse($stats['next_import'])->diffForHumans() }})</small>
                                        @else
                                            <span class="text-muted">Not scheduled</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Table Status:</strong></td>
                                    <td>
                                        @if($stats['table_exists'])
                                            <span class="badge bg-success">✓ Table exists and accessible</span>
                                        @else
                                            <span class="badge bg-danger">✗ Table does not exist</span>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    @if($stats['message'])
                        <div class="mt-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                {{ $stats['message'] }}
                            </small>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function refreshStats() {
    if (window.LoadingOverlay) {
        window.LoadingOverlay.show('Refreshing statistics...');
    }
    
    setTimeout(() => {
        location.reload();
    }, 1000);
}

function autoImportData(id, name) {
    if (confirm(`Auto import data from "${name}" with intelligent column mapping?`)) {
        if (window.LoadingOverlay) {
            window.LoadingOverlay.show('Auto importing data with column mapping...');
        }
        
        fetch(`/api-sources/${id}/auto-import`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (window.LoadingOverlay) {
                window.LoadingOverlay.hide();
            }
            if (data.success) {
                let message = data.message;
                if (data.mapped_fields && data.mapped_fields.length > 0) {
                    message += `\nMapped fields: ${data.mapped_fields.join(', ')}`;
                }
                
                if (window.Toast) {
                    window.Toast.success(message);
                } else {
                    alert(message);
                }
                setTimeout(() => location.reload(), 2000);
            } else {
                if (window.Toast) {
                    window.Toast.error(data.message || 'Auto import failed');
                } else {
                    alert(data.message || 'Auto import failed');
                }
            }
        })
        .catch(error => {
            if (window.LoadingOverlay) {
                window.LoadingOverlay.hide();
            }
            if (window.Toast) {
                window.Toast.error('Auto import failed: ' + error.message);
            } else {
                alert('Auto import failed: ' + error.message);
            }
        });
    }
}
</script>
@endpush
@endsection 