@extends('layouts.app')

@section('title', 'API Target Documentation - ' . $apiTarget->name)

@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('api-targets.index') }}">API Targets</a>
    </li>
    <li class="breadcrumb-item active">Documentation</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-book me-2"></i>API Target Documentation
                </h1>
                <div class="btn-group">
                    <a href="{{ route('api-targets.show', $apiTarget) }}" class="btn btn-primary">
                        <i class="fas fa-eye me-2"></i>View Details
                    </a>
                    <a href="{{ route('api-targets.edit', $apiTarget) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <a href="{{ route('api-targets.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Basic Information -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>Basic Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Name:</strong></td>
                                    <td>{{ $documentation['basic_info']['name'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Description:</strong></td>
                                    <td>{{ $documentation['basic_info']['description'] ?: 'No description' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Base URL:</strong></td>
                                    <td><code>{{ $documentation['basic_info']['base_url'] }}</code></td>
                                </tr>
                                <tr>
                                    <td><strong>Endpoint:</strong></td>
                                    <td><code>{{ $documentation['basic_info']['endpoint'] }}</code></td>
                                </tr>
                                <tr>
                                    <td><strong>Full URL:</strong></td>
                                    <td><code>{{ $documentation['basic_info']['full_url'] }}</code></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Method:</strong></td>
                                    <td><span class="badge bg-primary">{{ $documentation['basic_info']['method'] }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Source Table:</strong></td>
                                    <td><code>{{ $documentation['basic_info']['source_table'] }}</code></td>
                                </tr>
                                <tr>
                                    <td><strong>Auth Type:</strong></td>
                                    <td><span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $documentation['basic_info']['auth_type'])) }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Schedule:</strong></td>
                                    <td><span class="badge bg-secondary">{{ ucfirst($documentation['basic_info']['schedule_type']) }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span class="badge {{ $documentation['basic_info']['is_active'] ? 'bg-success' : 'bg-danger' }}">
                                            {{ $documentation['basic_info']['is_active'] ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Authentication -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-shield-alt me-2"></i>Authentication
                    </h6>
                </div>
                <div class="card-body">
                    <p><strong>Type:</strong> {{ $documentation['authentication']['description'] }}</p>
                    
                    @if(!empty($documentation['authentication']['headers']))
                        <p><strong>Headers:</strong></p>
                        <div class="bg-light p-3 rounded">
                            @foreach($documentation['authentication']['headers'] as $key => $value)
                                <div><code>{{ $key }}: {{ $value }}</code></div>
                            @endforeach
                        </div>
                    @endif

                    @if($documentation['authentication']['example'])
                        <p><strong>Example:</strong></p>
                        <pre class="bg-dark text-light p-3 rounded"><code>{{ $documentation['authentication']['example'] }}</code></pre>
                    @endif
                </div>
            </div>
        </div>

        <!-- Data Format -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-database me-2"></i>Data Format
                    </h6>
                </div>
                <div class="card-body">
                    <p><strong>Content-Type:</strong> {{ $documentation['data_format']['content_type'] }}</p>
                    <p><strong>Source Table:</strong> <code>{{ $documentation['data_format']['source_table'] }}</code></p>
                    
                    @if(!empty($documentation['data_format']['sample_data']))
                        <p><strong>Sample Data:</strong></p>
                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($documentation['data_format']['sample_data'], JSON_PRETTY_PRINT) }}</code></pre>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Usage Examples -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-code me-2"></i>Usage Examples
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="exampleTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="curl-tab" data-bs-toggle="tab" data-bs-target="#curl" type="button" role="tab">cURL</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="php-tab" data-bs-toggle="tab" data-bs-target="#php" type="button" role="tab">PHP</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="javascript-tab" data-bs-toggle="tab" data-bs-target="#javascript" type="button" role="tab">JavaScript</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="python-tab" data-bs-toggle="tab" data-bs-target="#python" type="button" role="tab">Python</button>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-3" id="exampleTabsContent">
                        <div class="tab-pane fade show active" id="curl" role="tabpanel">
                            <pre class="bg-dark text-light p-3 rounded"><code>{{ $documentation['usage_examples']['curl'] }}</code></pre>
                        </div>
                        <div class="tab-pane fade" id="php" role="tabpanel">
                            <pre class="bg-dark text-light p-3 rounded"><code>{{ $documentation['usage_examples']['php'] }}</code></pre>
                        </div>
                        <div class="tab-pane fade" id="javascript" role="tabpanel">
                            <pre class="bg-dark text-light p-3 rounded"><code>{{ $documentation['usage_examples']['javascript'] }}</code></pre>
                        </div>
                        <div class="tab-pane fade" id="python" role="tabpanel">
                            <pre class="bg-dark text-light p-3 rounded"><code>{{ $documentation['usage_examples']['python'] }}</code></pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Troubleshooting -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-tools me-2"></i>Troubleshooting
                    </h6>
                </div>
                <div class="card-body">
                    <h6>Common Issues:</h6>
                    @foreach($documentation['troubleshooting']['common_issues'] as $issue)
                        <div class="mb-3">
                            <strong>{{ $issue['issue'] }}</strong>
                            <p class="mb-1"><small><strong>Cause:</strong> {{ $issue['cause'] }}</small></p>
                            <p class="mb-0"><small><strong>Solution:</strong> {{ $issue['solution'] }}</small></p>
                        </div>
                    @endforeach

                    <h6 class="mt-4">Checklist:</h6>
                    <ul class="list-unstyled">
                        @foreach($documentation['troubleshooting']['checklist'] as $item)
                            <li><i class="fas fa-check text-success me-2"></i>{{ $item }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <!-- Recent Logs -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-history me-2"></i>Recent Logs
                    </h6>
                </div>
                <div class="card-body">
                    @if($documentation['logs']->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Time</th>
                                        <th>Status</th>
                                        <th>Response</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($documentation['logs'] as $log)
                                        <tr>
                                            <td>{{ $log->created_at->format('d/m/Y H:i') }}</td>
                                            <td>
                                                <span class="badge {{ $log->success ? 'bg-success' : 'bg-danger' }}">
                                                    {{ $log->success ? 'Success' : 'Failed' }}
                                                </span>
                                            </td>
                                            <td>{{ $log->status_code ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <a href="{{ route('api-targets.logs', $apiTarget) }}" class="btn btn-sm btn-outline-info">
                            View All Logs
                        </a>
                    @else
                        <p class="text-muted">No logs found.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy code functionality
    const codeBlocks = document.querySelectorAll('pre code');
    codeBlocks.forEach(block => {
        block.addEventListener('click', function() {
            navigator.clipboard.writeText(this.textContent).then(() => {
                // Show success message
                const originalText = this.textContent;
                this.textContent = 'Copied!';
                setTimeout(() => {
                    this.textContent = originalText;
                }, 1000);
            });
        });
        
        // Add copy indicator
        block.style.cursor = 'pointer';
        block.title = 'Click to copy';
    });
});
</script>
@endpush
@endsection 