@extends('layouts.app')

@section('title', 'API Target Logs')

@section('styles')
<style>
/* Badge Colors */
.badge.bg-success {
    color: #2b4a34 !important;
    background-color: #9de3bf !important;
}

.badge.bg-primary {
    color: #1a365d !important;
    background-color: #9ec5fe !important;
}

.badge.bg-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7 !important;
}

.badge.bg-warning {
    color: #603b00 !important;
    background-color: #ffd699 !important;
}

.badge.bg-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea !important;
}

.badge.bg-danger {
    color: #fff !important;
    background-color: #dc3545 !important;
}

/* Log details modal */
.log-details {
    max-height: 400px;
    overflow-y: auto;
}

.json-viewer {
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    padding: 1rem;
    font-family: 'Courier New', monospace;
    font-size: 0.875rem;
    white-space: pre-wrap;
    word-break: break-all;
}
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-list me-2"></i>Send Logs for {{ $apiTarget->name }}
        </h1>
        <div class="btn-group">
            <a href="{{ route('api-targets.show', $apiTarget) }}" class="btn btn-primary">
                <i class="fas fa-eye me-2"></i>View Details
            </a>
            <a href="{{ route('api-targets.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Logs
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $apiTarget->sendLogs()->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Successful
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $apiTarget->sendLogs()->where('success', true)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Failed
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $apiTarget->sendLogs()->where('success', false)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Retries
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $apiTarget->sendLogs()->where('retry_count', '>', 0)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-redo fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-history me-2"></i>Send Logs
            </h6>
        </div>
        <div class="card-body">
            @if($logs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Status</th>
                                <th>Sent At</th>
                                <th>Response Time</th>
                                <th>Status Code</th>
                                <th>Records Sent</th>
                                <th>Retry Count</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($logs as $log)
                                <tr>
                                    <td>
                                        <span class="badge bg-{{ $log->success ? 'success' : 'danger' }}">
                                            {{ $log->success ? 'Success' : 'Failed' }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ $log->sent_at ? $log->sent_at->format('Y-m-d H:i:s') : 'N/A' }}
                                        @if($log->sent_at)
                                            <br><small class="text-muted">{{ $log->sent_at->diffForHumans() }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->response_time)
                                            {{ number_format($log->response_time, 2) }}s
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->status_code)
                                            <span class="badge bg-{{ $log->status_code >= 200 && $log->status_code < 300 ? 'success' : ($log->status_code >= 400 && $log->status_code < 500 ? 'warning' : 'danger') }}">
                                                {{ $log->status_code }}
                                            </span>
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->records_sent)
                                            {{ number_format($log->records_sent) }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->retry_count > 0)
                                            <span class="badge bg-warning">{{ $log->retry_count }}</span>
                                        @else
                                            <span class="badge bg-secondary">0</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-info" onclick="showLogDetails({{ $log->id }})">
                                            <i class="fas fa-eye"></i> View
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                {{ $logs->links() }}
            @else
                <div class="text-center text-gray-500">
                    <i class="fas fa-inbox fa-3x mb-3"></i>
                    <div class="h5">No logs found</div>
                    <div>Logs will appear here when data is sent to this target</div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Log Details Modal -->
<div class="modal fade" id="logDetailsModal" tabindex="-1" aria-labelledby="logDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="logDetailsModalLabel">Log Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="logDetailsContent">
                    <!-- Content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function showLogDetails(logId) {
    // Show loading state
    document.getElementById('logDetailsContent').innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin fa-2x"></i><p>Loading...</p></div>';
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('logDetailsModal'));
    modal.show();
    
    // Fetch log details
    fetch(`/api-targets/logs/${logId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const log = data.log;
                let content = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Basic Information</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Status:</strong></td><td><span class="badge bg-${log.success ? 'success' : 'danger'}">${log.success ? 'Success' : 'Failed'}</span></td></tr>
                                <tr><td><strong>Sent At:</strong></td><td>${log.sent_at || 'N/A'}</td></tr>
                                <tr><td><strong>Completed At:</strong></td><td>${log.completed_at || 'N/A'}</td></tr>
                                <tr><td><strong>Response Time:</strong></td><td>${log.response_time ? log.response_time + 's' : 'N/A'}</td></tr>
                                <tr><td><strong>Status Code:</strong></td><td>${log.status_code || 'N/A'}</td></tr>
                                <tr><td><strong>Records Sent:</strong></td><td>${log.records_sent || 'N/A'}</td></tr>
                                <tr><td><strong>Retry Count:</strong></td><td>${log.retry_count || 0}</td></tr>
                                <tr><td><strong>Batch ID:</strong></td><td>${log.batch_id || 'N/A'}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Error Information</h6>
                            ${log.error_message ? `<div class="alert alert-danger">${log.error_message}</div>` : '<p class="text-muted">No errors</p>'}
                        </div>
                    </div>
                `;
                
                if (log.payload) {
                    content += `
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6>Payload Sent</h6>
                                <div class="json-viewer">${JSON.stringify(log.payload, null, 2)}</div>
                            </div>
                        </div>
                    `;
                }
                
                if (log.response_body) {
                    content += `
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6>Response Body</h6>
                                <div class="json-viewer">${JSON.stringify(log.response_body, null, 2)}</div>
                            </div>
                        </div>
                    `;
                }
                
                document.getElementById('logDetailsContent').innerHTML = content;
            } else {
                document.getElementById('logDetailsContent').innerHTML = '<div class="alert alert-danger">Failed to load log details</div>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            document.getElementById('logDetailsContent').innerHTML = '<div class="alert alert-danger">Error loading log details</div>';
        });
}
</script>
@endsection 