@extends('layouts.app')

@section('title', 'Create API Token')

@section('content')
<div class="container-fluid px-4">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-key me-2"></i>Create API Token
        </h1>
        <a href="{{ route('api-tokens.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to List
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Generate New Token</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('api-tokens.store') }}" method="POST" id="createTokenForm">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Token Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="api_client_id">API Client <span class="text-danger">*</span></label>
                            <select class="form-control @error('api_client_id') is-invalid @enderror" 
                                    id="api_client_id" name="api_client_id" required>
                                <option value="">Select Client</option>
                                @foreach($clients as $client)
                                    <option value="{{ $client->id }}" {{ old('api_client_id') == $client->id ? 'selected' : '' }}>
                                        {{ $client->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('api_client_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="expires_at">Expiration Date (Optional)</label>
                            <input type="date" class="form-control @error('expires_at') is-invalid @enderror" 
                                   id="expires_at" name="expires_at" value="{{ old('expires_at') }}">
                            @error('expires_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label>Token Permissions</label>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="ability_all" name="abilities[]" 
                               value="*" checked>
                        <label class="form-check-label" for="ability_all">Full Access</label>
                    </div>
                </div>

                <button type="button" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                    <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                </button>
                <a href="{{ route('api-tokens.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection 

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('createTokenForm');
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    const nameInput = document.getElementById('name');
    const clientSelect = document.getElementById('api_client_id');

    if (altSubmitBtn) {
        altSubmitBtn.addEventListener('click', function() {
            const name = (nameInput?.value || '').trim();
            const clientId = (clientSelect?.value || '').trim();

            if (!name) {
                alert('Please enter a token name.');
                nameInput?.focus();
                return;
            }
            if (!clientId) {
                alert('Please select an API client.');
                clientSelect?.focus();
                return;
            }

            altSubmitBtn.disabled = true;
            altSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
            form.submit();
        });
    }
});
</script>
@endpush