@extends('layouts.app')

@section('title', 'API Tokens')

@section('breadcrumb')
    <li class="breadcrumb-item active">API Tokens</li>
@endsection

@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">API Tokens</h1>
        <a href="{{ route('api-tokens.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Create New Token
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('new_token'))
        <div class="alert alert-info alert-dismissible fade show" role="alert">
            <h5 class="alert-heading"><i class="fas fa-info-circle"></i> New Token Created</h5>
            <p class="mb-2">Please copy your new token now. You won't be able to see it again!</p>
            <div class="input-group">
                <input type="text" class="form-control" value="{{ session('new_token') }}" readonly>
                <button class="btn btn-outline-secondary copy-btn" type="button" data-copy="{{ session('new_token') }}" data-bs-toggle="tooltip" title="Copy to clipboard">
                    <i class="fas fa-copy"></i>
                </button>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Client</th>
                            <th>Status</th>
                            <th>Last Used</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tokens as $token)
                            <tr>
                                <td>
                                    <a href="{{ route('api-tokens.show', $token) }}" class="text-decoration-none">
                                        {{ $token->name ?: 'Token '.$token->id }}
                                    </a>
                                </td>
                                <td>{{ $token->client->name }}</td>
                                <td>
                                    @if($token->is_revoked)
                                        <span class="badge bg-danger">Revoked</span>
                                    @else
                                        <span class="badge bg-success">Active</span>
                                    @endif
                                </td>
                                <td>{{ $token->last_used_at ? $token->last_used_at->diffForHumans() : 'Never' }}</td>
                                <td>{{ $token->created_at->format('Y-m-d H:i') }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('api-tokens.show', $token) }}" class="btn btn-sm btn-info" data-bs-toggle="tooltip" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('api-tokens.edit', $token) }}" class="btn btn-sm btn-warning" data-bs-toggle="tooltip" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if(!$token->is_revoked)
                                            <a href="{{ route('api-tokens.revoke.get', $token) }}"
                                               class="btn btn-sm btn-outline-danger"
                                               onclick="return confirm('Are you sure you want to revoke this token?')"
                                               data-bs-toggle="tooltip" title="Revoke">
                                                <i class="fas fa-ban"></i>
                                            </a>
                                        @endif
                                        <a href="{{ route('api-tokens.delete', $token->id) }}"
                                           class="btn btn-sm btn-danger"
                                           onclick="return confirm('Are you sure you want to delete {{ $token->name ?: 'this token' }}? This action cannot be undone.')"
                                           data-bs-toggle="tooltip" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-info-circle mb-2"></i>
                                        <p class="mb-0">No API tokens found</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center mt-4">
                {{ $tokens->links() }}
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();

    // Handle copy button clicks
    $('.copy-btn').click(function() {
        var text = $(this).data('copy');
        var btn = $(this);
        
        navigator.clipboard.writeText(text).then(function() {
            var tooltip = bootstrap.Tooltip.getInstance(btn[0]);
            tooltip.hide();
            
            btn.attr('data-bs-original-title', 'Copied!');
            tooltip.show();
            
            setTimeout(function() {
                btn.attr('data-bs-original-title', 'Copy to clipboard');
            }, 1000);
        }).catch(function(err) {
            console.error('Failed to copy text: ', err);
            alert('Failed to copy text. Please try again.');
        });
    });

    // Auto-hide alerts after 5 seconds
    $('.alert').not('.alert-info').delay(5000).fadeOut(500);
});
</script>
@endpush
@endsection 