@extends('layouts.app')

@section('title', 'API Token Details')

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">API Token Details</h5>
        </div>
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6">
                    <h6 class="text-muted">Token Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4">Name</dt>
                        <dd class="col-sm-8">{{ $apiToken->name ?: 'Token '.$apiToken->id }}</dd>
                        
                        <dt class="col-sm-4">Client</dt>
                        <dd class="col-sm-8">{{ $apiToken->client->name }}</dd>
                        
                        <dt class="col-sm-4">Status</dt>
                        <dd class="col-sm-8">
                            @if($apiToken->is_revoked)
                                <span class="badge bg-danger">Revoked</span>
                            @else
                                <span class="badge bg-success">Active</span>
                            @endif
                        </dd>
                        
                        <dt class="col-sm-4">Created</dt>
                        <dd class="col-sm-8">{{ $apiToken->created_at->format('Y-m-d H:i:s') }}</dd>
                        
                        <dt class="col-sm-4">Last Used</dt>
                        <dd class="col-sm-8">
                            {{ $apiToken->last_used_at ? $apiToken->last_used_at->format('Y-m-d H:i:s') : 'Never' }}
                        </dd>
                    </dl>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted">Token Value</h6>
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" value="{{ $apiToken->token }}" id="tokenValue" readonly>
                        <button class="btn btn-outline-secondary copy-btn" type="button" data-copy="{{ $apiToken->token }}" data-bs-toggle="tooltip" title="Copy to clipboard">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> Keep this token secure. It will not be shown again.
                    </div>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-12">
                    <h6 class="text-muted">Usage Examples</h6>
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6>cURL</h6>
                            <pre class="mb-3"><code>curl -X GET "{{ url('/api/test') }}" \
    -H "Authorization: Bearer {{ $apiToken->token }}" \
    -H "Accept: application/json"</code></pre>
                            
                            <h6>JavaScript</h6>
                            <pre><code>fetch('{{ url('/api/test') }}', {
    headers: {
        'Authorization': 'Bearer {{ $apiToken->token }}',
        'Accept': 'application/json'
    }
})
.then(response => response.json())
.then(data => console.log(data));</code></pre>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <h6 class="text-muted">Actions</h6>
                    <div class="btn-group">
                        @if(!$apiToken->is_revoked)
                            <form action="{{ route('api-tokens.revoke', $apiToken) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-warning me-2" onclick="return confirm('Are you sure you want to revoke this token?')">
                                    <i class="fas fa-ban"></i> Revoke Token
                                </button>
                            </form>
                        @endif
                        
                        <a href="{{ route('api-tokens.regenerate.get', $apiToken) }}"
                           class="btn btn-info me-2"
                           onclick="return confirm('Are you sure you want to regenerate this token?')">
                            <i class="fas fa-sync"></i> Regenerate Token
                        </a>
                        
                        <a href="{{ route('api-tokens.edit', $apiToken) }}" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        
                        <form action="{{ route('api-tokens.destroy', $apiToken) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this token?')">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize copy buttons
    $('.copy-btn').each(function() {
        new bootstrap.Tooltip(this);
    });

    // Handle copy button clicks
    $('.copy-btn').click(function() {
        var text = $(this).data('copy');
        var btn = $(this);
        
        navigator.clipboard.writeText(text).then(function() {
            var tooltip = bootstrap.Tooltip.getInstance(btn[0]);
            tooltip.hide();
            
            btn.attr('data-bs-original-title', 'Copied!');
            tooltip.show();
            
            setTimeout(function() {
                btn.attr('data-bs-original-title', 'Copy to clipboard');
            }, 1000);
        }).catch(function(err) {
            console.error('Failed to copy text: ', err);
            alert('Failed to copy text. Please try again.');
        });
    });
});
</script>
@endpush
@endsection 