@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Tambah Transceiver</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('transceivers.store') }}" method="POST" id="transceiver-form">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Nama</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Endpoint</label>
                            <div class="input-group">
                                <input type="url" name="endpoint" id="endpoint-input" class="form-control" required placeholder="https://api.partner.com/endpoint" pattern="https?://.+">
                                <button class="btn btn-outline-secondary" type="button" id="generate-endpoint-btn"><i class="fas fa-magic"></i> Generate Dummy Endpoint</button>
                            </div>
                            <small class="form-text text-muted">Masukkan URL lengkap tujuan API eksternal, contoh: https://api.partner.com/endpoint</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Method</label>
                            <select name="method" class="form-select" required>
                                <option value="POST">POST</option>
                                <option value="PUT">PUT</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Table Sumber</label>
                            <select name="source_table" class="form-select" required>
                                @foreach($tables as $table)
                                    <option value="{{ $table }}">{{ $table }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Auth Type</label>
                            <select name="auth_type" id="auth_type" class="form-select" required>
                                <option value="none">None</option>
                                <option value="api_key">API Key</option>
                                <option value="bearer_token">Bearer Token</option>
                                <option value="basic_auth">Basic Auth</option>
                            </select>
                        </div>
                        <div id="auth_fields" style="display:none;">
                            <div class="mb-3" id="auth_token_group" style="display:none;">
                                <label class="form-label">Auth Token</label>
                                <input type="text" name="auth_token" class="form-control">
                            </div>
                            <div class="mb-3" id="auth_username_group" style="display:none;">
                                <label class="form-label">Auth Username</label>
                                <input type="text" name="auth_username" class="form-control">
                            </div>
                            <div class="mb-3" id="auth_password_group" style="display:none;">
                                <label class="form-label">Auth Password</label>
                                <input type="password" name="auth_password" class="form-control">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea name="description" class="form-control"></textarea>
                        </div>
                        <div class="form-check mb-3">
                            <input type="checkbox" name="is_active" value="1" class="form-check-input" id="is_active" checked>
                            <label class="form-check-label" for="is_active">Aktif</label>
                        </div>
                        <div class="form-group mt-4">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>
                                        <span class="spinner-border spinner-border-sm me-2 d-none" id="btn-spinner" role="status" aria-hidden="true"></span>
                                        SUBMIT NOW
                                    </button>
                                </div>
                                <div class="col-12 mb-3">
                                    <button type="button" class="btn btn-info me-2" id="simpleSubmitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>SIMPLE SUBMIT
                                    </button>
                                    <a href="{{ route('transceivers.index') }}" class="btn btn-secondary me-2 btn-lg">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                    <button type="button" class="btn btn-warning me-2" id="testConnectionBtn">
                                        <i class="fas fa-plug me-2"></i>Test Connection
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function toggleAuthFields() {
        var authType = $('#auth_type').val();
        if(authType === 'none') {
            $('#auth_fields').hide();
        } else {
            $('#auth_fields').show();
            if(authType === 'basic_auth') {
                $('#auth_token_group').hide();
                $('#auth_username_group').show();
                $('#auth_password_group').show();
            } else if(authType === 'api_key' || authType === 'bearer_token') {
                $('#auth_token_group').show();
                $('#auth_username_group').hide();
                $('#auth_password_group').hide();
            } else {
                $('#auth_token_group').hide();
                $('#auth_username_group').hide();
                $('#auth_password_group').hide();
            }
        }
    }
    $(document).ready(function() {
        $('#auth_type').on('change', toggleAuthFields);
        toggleAuthFields(); // initial

        // Tombol loading hanya saat submit
        $('#transceiver-form').on('submit', function() {
            $('#altSubmitBtn').prop('disabled', true);
            $('#btn-spinner').removeClass('d-none');
            $('#altSubmitBtn i').removeClass('fa-rocket').addClass('fa-spinner fa-spin');
        });

        // Jika ada error validasi dari Laravel, enable lagi tombol
        @if ($errors->any())
            $('#altSubmitBtn').prop('disabled', false);
            $('#btn-spinner').addClass('d-none');
            $('#altSubmitBtn i').removeClass('fa-spinner fa-spin').addClass('fa-rocket');
        @endif

        // Simple Submit handler
        $('#simpleSubmitBtn').on('click', function() {
            // Validasi sederhana
            var name = $('input[name="name"]').val();
            var endpoint = $('input[name="endpoint"]').val();
            var method = $('select[name="method"]').val();
            var sourceTable = $('select[name="source_table"]').val();
            var authType = $('#auth_type').val();
            if (!name || !endpoint || !method || !sourceTable || !authType) {
                alert('Please fill in all required fields!');
                return;
            }
            if (!confirm('Ready to save this Transceiver?')) return;
            // Tambahkan hidden field untuk identifikasi
            if ($('#transceiver-form input[name="submit_method"]').length === 0) {
                $('#transceiver-form').append('<input type="hidden" name="submit_method" value="simple">');
            }
            $('#transceiver-form')[0].submit();
        });

        // Test Connection handler (dummy, bisa diisi sesuai kebutuhan)
        $('#testConnectionBtn').on('click', function() {
            alert('Test Connection feature is not implemented yet.');
        });

        $('#generate-endpoint-btn').on('click', function() {
            // Bisa diganti dengan endpoint dummy lain jika perlu
            var dummy = 'https://webhook.site/' + Math.random().toString(36).substring(2, 10);
            $('#endpoint-input').val(dummy);
        });
    });
</script>
@endpush
@endsection 