@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Edit Transceiver</h1>
    <form action="{{ route('transceivers.update', $transceiver) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label>Nama</label>
            <input type="text" name="name" class="form-control" value="{{ $transceiver->name }}" required>
        </div>
        <div class="mb-3">
            <label>Endpoint</label>
            <input type="text" name="endpoint" class="form-control" value="{{ $transceiver->endpoint }}" required>
        </div>
        <div class="mb-3">
            <label>Method</label>
            <select name="method" class="form-control" required>
                <option value="POST" @if($transceiver->method=='POST') selected @endif>POST</option>
                <option value="PUT" @if($transceiver->method=='PUT') selected @endif>PUT</option>
            </select>
        </div>
        <div class="mb-3">
            <label>Table Sumber</label>
            <select name="source_table" class="form-control" required>
                @foreach($tables as $table)
                    <option value="{{ $table }}" @if($transceiver->source_table==$table) selected @endif>{{ $table }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Auth Type</label>
            <select name="auth_type" class="form-control" required>
                <option value="none" @if($transceiver->auth_type=='none') selected @endif>None</option>
                <option value="api_key" @if($transceiver->auth_type=='api_key') selected @endif>API Key</option>
                <option value="bearer_token" @if($transceiver->auth_type=='bearer_token') selected @endif>Bearer Token</option>
                <option value="basic_auth" @if($transceiver->auth_type=='basic_auth') selected @endif>Basic Auth</option>
            </select>
        </div>
        <div class="mb-3">
            <label>Auth Token</label>
            <input type="text" name="auth_token" class="form-control" value="{{ $transceiver->auth_token }}">
        </div>
        <div class="mb-3">
            <label>Auth Username</label>
            <input type="text" name="auth_username" class="form-control" value="{{ $transceiver->auth_username }}">
        </div>
        <div class="mb-3">
            <label>Auth Password</label>
            <input type="password" name="auth_password" class="form-control" value="{{ $transceiver->auth_password }}">
        </div>
        <div class="mb-3">
            <label>Deskripsi</label>
            <textarea name="description" class="form-control">{{ $transceiver->description }}</textarea>
        </div>
        <div class="mb-3">
            <label>Aktif</label>
            <input type="checkbox" name="is_active" value="1" @if($transceiver->is_active) checked @endif>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('transceivers.index') }}" class="btn btn-secondary">Batal</a>
    </form>
</div>
@endsection 