@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Transceivers</h1>
    <a href="{{ route('transceivers.create') }}" class="btn btn-primary mb-3">Tambah Transceiver</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Nama</th>
                <th>Endpoint</th>
                <th>Method</th>
                <th>Aktif</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            @foreach($transceivers as $transceiver)
            <tr>
                <td>{{ $transceiver->name }}</td>
                <td>{{ $transceiver->endpoint }}</td>
                <td>{{ $transceiver->method }}</td>
                <td>{{ $transceiver->is_active ? 'Ya' : 'Tidak' }}</td>
                <td>
                    <a href="{{ route('transceivers.show', $transceiver) }}" class="btn btn-info btn-sm">Lihat</a>
                    <a href="{{ route('transceivers.edit', $transceiver) }}" class="btn btn-warning btn-sm">Edit</a>
                    <form action="{{ route('transceivers.destroy', $transceiver) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus?')">Hapus</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $transceivers->links() }}
</div>
@endsection 