@extends('layouts.app')

@section('title', 'API Transceiver Logs')

@section('styles')
<style>
/* Badge Colors */
.badge.bg-success {
    color: #2b4a34 !important;
    background-color: #9de3bf !important;
}

.badge.bg-primary {
    color: #1a365d !important;
    background-color: #9ec5fe !important;
}

.badge.bg-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7 !important;
}

.badge.bg-warning {
    color: #603b00 !important;
    background-color: #ffd699 !important;
}

.badge.bg-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea !important;
}

.badge.bg-danger {
    color: #fff !important;
    background-color: #dc3545 !important;
}

/* Table Styles */
.table td {
    background-color: #f8f9fc;
    border-radius: 0.25rem;
    padding: 0.75rem !important;
}
</style>
@endsection

@section('content')
<div class="container-fluid px-4">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-list me-2"></i>{{ $apiTransceiver->name }} - Logs
        </h1>
        <div>
            <a href="{{ route('api-transceivers.show', $apiTransceiver) }}" class="btn btn-info">
                <i class="fas fa-eye me-2"></i>View Details
            </a>
            <a href="{{ route('api-transceivers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Logs
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $logs->total() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Successful
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $apiTransceiver->logs->where('status', 'success')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Errors
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $apiTransceiver->logs->where('status', 'error')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Forwarded
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($apiTransceiver->total_forwarded) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exchange-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-history me-2"></i>Activity Logs
            </h6>
        </div>
        <div class="card-body">
            @if($logs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Status</th>
                                <th>Message</th>
                                <th>Records Processed</th>
                                <th>Execution Time</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($logs as $log)
                                <tr>
                                    <td>
                                        @if($log->status === 'success')
                                            <span class="badge bg-success">Success</span>
                                        @elseif($log->status === 'error')
                                            <span class="badge bg-danger">Error</span>
                                        @else
                                            <span class="badge bg-warning">{{ ucfirst($log->status) }}</span>
                                        @endif
                                    </td>
                                    <td class="bg-light">{{ $log->message }}</td>
                                    <td class="bg-light">{{ $log->records_processed ?? 0 }}</td>
                                    <td class="bg-light">{{ $log->execution_time ?? 0 }}s</td>
                                    <td class="bg-light">{{ $log->created_at->format('M d, Y H:i:s') }}</td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" onclick="viewLogDetails({{ $log->id }})" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing {{ $logs->firstItem() }} to {{ $logs->lastItem() }} of {{ $logs->total() }} results
                    </div>
                    {{ $logs->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-inbox text-muted" style="font-size: 3rem;"></i>
                    <h4 class="text-muted mt-3">No logs found</h4>
                    <p class="text-muted">No activity has been logged for this transceiver yet.</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Log Details Modal -->
<div class="modal fade" id="logDetailsModal" tabindex="-1" aria-labelledby="logDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="logDetailsModalLabel">Log Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="logDetailsContent">
                Loading...
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
function viewLogDetails(logId) {
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('logDetailsModal'));
    modal.show();
    
    // Load log details (you can implement an AJAX call here if needed)
    document.getElementById('logDetailsContent').innerHTML = `
        <p>Log ID: ${logId}</p>
        <p>Detailed information would be loaded here via AJAX.</p>
    `;
}
</script>
@endsection 