@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Detail Transceiver</h1>
    <a href="{{ route('transceivers.edit', $transceiver) }}" class="btn btn-warning mb-3">Edit</a>
    <a href="{{ route('transceivers.index') }}" class="btn btn-secondary mb-3">Kembali</a>
    @php
        $baseUrl = url('/');
        $endpointUrl = $baseUrl . '/api/transceivers/' . $transceiver->id . '/send';
    @endphp
    <div class="mb-3">
        <label class="form-label fw-bold">Endpoint URL untuk POST/PUT (uji di Postman):</label>
        <div class="input-group mb-2">
            <input type="text" class="form-control" id="endpoint-url" value="{{ $endpointUrl }}" readonly>
            <button class="btn btn-outline-secondary" type="button" onclick="navigator.clipboard.writeText(document.getElementById('endpoint-url').value)"><i class="fas fa-copy"></i> Copy</button>
        </div>
        <small class="text-muted">Gunakan URL ini untuk mengirim data ke Transceiver via POST/PUT dari Postman atau aplikasi lain.</small>
    </div>
    <table class="table table-bordered">
        <tr><th>Nama</th><td>{{ $transceiver->name }}</td></tr>
        <tr><th>Endpoint</th><td>{{ $transceiver->endpoint }}</td></tr>
        <tr><th>Method</th><td>{{ $transceiver->method }}</td></tr>
        <tr><th>Table Sumber</th><td>{{ $transceiver->source_table }}</td></tr>
        <tr><th>Auth Type</th><td>{{ $transceiver->auth_type }}</td></tr>
        <tr><th>Auth Token</th><td>{{ $transceiver->auth_token }}</td></tr>
        <tr><th>Auth Username</th><td>{{ $transceiver->auth_username }}</td></tr>
        <tr><th>Auth Password</th><td>{{ $transceiver->auth_password }}</td></tr>
        <tr><th>Deskripsi</th><td>{{ $transceiver->description }}</td></tr>
        <tr><th>Aktif</th><td>{{ $transceiver->is_active ? 'Ya' : 'Tidak' }}</td></tr>
        <tr><th>Dibuat Oleh</th><td>{{ $transceiver->created_by }}</td></tr>
        <tr><th>Dibuat Pada</th><td>{{ $transceiver->created_at }}</td></tr>
        <tr><th>Diupdate Pada</th><td>{{ $transceiver->updated_at }}</td></tr>
    </table>
    <div class="card mt-4">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="fas fa-book me-2"></i>Dokumentasi API Transceiver</h5>
        </div>
        <div class="card-body">
            <h6 class="fw-bold">Endpoint</h6>
            <div class="input-group mb-2">
                <input type="text" class="form-control" id="endpoint-url-doc" value="{{ $endpointUrl }}" readonly>
                <button class="btn btn-outline-secondary" type="button" onclick="navigator.clipboard.writeText(document.getElementById('endpoint-url-doc').value)"><i class="fas fa-copy"></i> Copy</button>
            </div>
            <ul>
                <li><code>POST {{ $endpointUrl }}</code></li>
                <li><code>PUT {{ $endpointUrl }}</code></li>
            </ul>
            <h6 class="fw-bold mt-3">Headers</h6>
            <ul>
                <li><code>Content-Type: application/json</code></li>
                <li><code>Authorization</code> (jika diperlukan, sesuai pengaturan Auth Type)</li>
            </ul>
            <h6 class="fw-bold mt-3">Contoh Request Body</h6>
            <pre class="bg-light p-2 rounded"><code>{
  "field1": "value1",
  "field2": "value2"
}</code></pre>
            <h6 class="fw-bold mt-3">Contoh cURL</h6>
            <pre class="bg-light p-2 rounded"><code>curl -X POST "{{ $endpointUrl }}" \
  -H "Content-Type: application/json" \
  -d '{"field1":"value1","field2":"value2"}'
</code></pre>
            <h6 class="fw-bold mt-3">Response Sukses</h6>
            <pre class="bg-light p-2 rounded"><code>{
  "success": true,
  "message": "Data sent successfully",
  "external_response": {
    // response dari API eksternal
  }
}</code></pre>
            <h6 class="fw-bold mt-3">Catatan</h6>
            <ul>
                <li>Endpoint ini akan meneruskan data ke API eksternal sesuai pengaturan Transceiver.</li>
                <li>Gunakan metode <b>POST</b> atau <b>PUT</b> sesuai kebutuhan.</li>
                <li>Auth ke eksternal akan otomatis diterapkan sesuai pengaturan Transceiver.</li>
                <li>Jika ada error validasi atau error dari API eksternal, response error akan diteruskan.</li>
            </ul>
        </div>
    </div>
</div>
@endsection 