@extends('layouts.auth')

@section('title', 'Login')

@section('content')
<form method="POST" action="{{ route('login') }}" novalidate>
    @csrf

    <div class="form-group">
        <label for="email" class="form-label">{{ __('Email Address') }}</label>
        <div class="input-group">
            <i class="fas fa-envelope input-icon"></i>
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="Masukkan email Anda">
        </div>
        @error('email')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="form-group">
        <label for="password" class="form-label">{{ __('Password') }}</label>
        <div class="input-group">
            <i class="fas fa-lock input-icon"></i>
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Masukkan password Anda">
            <button type="button" class="password-toggle" aria-label="Toggle password" onclick="togglePassword(this)">
                <i class="fas fa-eye"></i>
            </button>
        </div>
        @error('password')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="d-flex align-items-center justify-content-between mb-4">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
            <label class="form-check-label" for="remember">{{ __('Ingat Saya') }}</label>
        </div>
        @if (Route::has('password.request'))
            <a class="forgot-link" href="{{ route('password.request') }}">{{ __('Lupa Password?') }}</a>
        @endif
    </div>

    <button type="submit" class="btn btn-login">
        <i class="fas fa-sign-in-alt me-2"></i> {{ __('Masuk') }}
    </button>
</form>

<script>
function togglePassword(button) {
    const input = button.previousElementSibling;
    const icon = button.querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
@endsection 