@extends('layouts.app')

@section('title', 'Dashboard')

@php
// Ensure $stats array exists and has all required keys
$stats = $stats ?? [];
$defaultStats = [
    'total_apis' => 0,
    'total_requests' => 0,
    'system_status' => 'Unknown',
    'api_sources' => 0,
    'active_sources' => 0,
    'api_targets' => 0,
    'active_targets' => 0,
    'api_receivers' => 0,
    'active_receivers' => 0,
    'total_transceivers' => 0,
    'active_transceivers' => 0,
    'success_rate' => 0,
    'error_rate' => 0,
    'today_requests' => 0,
    'total_clients' => 0,
];
$stats = array_merge($defaultStats, $stats);
@endphp

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
            <p class="mb-0 text-gray-600">Welcome to API Management System</p>
            <p class="mb-0 text-gray-500" style="font-size: 0.95em;">
                <i class="fas fa-clock me-1"></i>
                Waktu Server: {{ \Carbon\Carbon::now('Asia/Jakarta')->translatedFormat('d F Y, H:i') }} WIB
            </p>
        </div>
        <div>
                                <a href="{{ asset('docs/CLIENT_API_GUIDE.md') }}" class="btn btn-outline-primary btn-sm me-2" target="_blank">
                <i class="fas fa-book me-1"></i>Client Guide
            </a>
                                <a href="{{ asset('docs/API_TRANSCEIVER_DOCUMENTATION.md') }}" class="btn btn-outline-info btn-sm" target="_blank">
                <i class="fas fa-file-code me-1"></i>API Documentation
            </a>
        </div>
    </div>

    <!-- System Status -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-white shadow-sm">
                <div class="card-body py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-center px-4">
                            <h4 class="mb-1 text-dark">API Management</h4>
                            <p class="mb-0 text-muted">Public Access Mode</p>
                        </div>
                        <div class="text-center px-4 border-start">
                            <h4 class="mb-1 text-dark">{{ $stats['total_apis'] }}</h4>
                            <p class="mb-0 text-muted">APIs</p>
                        </div>
                        <div class="text-center px-4 border-start">
                            <h4 class="mb-1 text-dark">{{ $stats['total_requests'] }}</h4>
                            <p class="mb-0 text-muted">Requests</p>
                        </div>
                        <div class="text-center px-4 border-start">
                            <h4 class="mb-1 text-dark">{{ $stats['system_status'] }}</h4>
                            <p class="mb-0 text-muted">Status</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <!-- API Sources Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-primary border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">API Sources</div>
                            <div class="h3 mb-0 font-weight-bold text-gray-800">{{ $stats['api_sources'] }}</div>
                            <div class="text-sm text-success mt-2">
                                <i class="fas fa-check-circle me-1"></i>{{ $stats['active_sources'] }} Active
                            </div>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class="fas fa-database fa-2x text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- API Targets Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-success border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">API Targets</div>
                            <div class="h3 mb-0 font-weight-bold text-gray-800">{{ $stats['api_targets'] }}</div>
                            <div class="text-sm text-success mt-2">
                                <i class="fas fa-check-circle me-1"></i>{{ $stats['active_targets'] }} Active
                            </div>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="fas fa-bullseye fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- API Receivers Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-info border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">API Receivers</div>
                            <div class="h3 mb-0 font-weight-bold text-gray-800">{{ $stats['api_receivers'] }}</div>
                            <div class="text-sm text-success mt-2">
                                <i class="fas fa-check-circle me-1"></i>{{ $stats['active_receivers'] }} Active
                            </div>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="fas fa-inbox fa-2x text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- API Transceivers Card hidden per request --}}
        {{--
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-start border-warning border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">API Transceivers</div>
                            <div class="h3 mb-0 font-weight-bold text-gray-800">{{ $stats['total_transceivers'] }}</div>
                            <div class="text-sm text-success mt-2">
                                <i class="fas fa-check-circle me-1"></i>{{ $stats['active_transceivers'] }} Active
                            </div>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="fas fa-exchange-alt fa-2x text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        --}}
    </div>

    <!-- Performance Metrics -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs text-uppercase mb-1 text-success">Success Rate</div>
                            <div class="h2 mb-0 font-weight-bold">{{ $stats['success_rate'] }}%</div>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="fas fa-check-circle fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs text-uppercase mb-1 text-danger">Error Rate</div>
                            <div class="h2 mb-0 font-weight-bold">{{ $stats['error_rate'] }}%</div>
                        </div>
                        <div class="bg-danger bg-opacity-10 p-3 rounded">
                            <i class="fas fa-exclamation-circle fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs text-uppercase mb-1 text-info">Today's Requests</div>
                            <div class="h2 mb-0 font-weight-bold">{{ $stats['today_requests'] }}</div>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="fas fa-clock fa-2x text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-xs text-uppercase mb-1 text-warning">API Clients</div>
                            <div class="h2 mb-0 font-weight-bold">{{ $stats['total_clients'] }}</div>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="fas fa-users fa-2x text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Items -->
    <div class="row">
        <!-- Recent API Sources -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Recent API Sources</h6>
                    <a href="{{ route('api-sources.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body p-0">
                    @if($api_sources->count() > 0)
                        <div class="list-group list-group-flush">
                        @foreach($api_sources as $source)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">{{ $source->name }}</h6>
                                        <small class="text-muted">
                                            {{ $source->created_at->timezone('Asia/Jakarta')->translatedFormat('d F Y, H:i') }} WIB
                                        </small>
                                    </div>
                                    <span class="badge bg-{{ $source->status == 'active' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($source->status) }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <p class="text-muted mb-0">No API sources found.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent API Targets -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-success">Recent API Targets</h6>
                    <a href="{{ route('api-targets.index') }}" class="btn btn-sm btn-outline-success">View All</a>
                </div>
                <div class="card-body p-0">
                    @if($api_targets->count() > 0)
                        <div class="list-group list-group-flush">
                        @foreach($api_targets as $target)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">{{ $target->name }}</h6>
                                        <small class="text-muted">
                                            {{ $target->created_at->timezone('Asia/Jakarta')->translatedFormat('d F Y, H:i') }} WIB
                                        </small>
                                    </div>
                                    <span class="badge bg-{{ $target->is_active ? 'success' : 'secondary' }}">
                                        {{ $target->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <p class="text-muted mb-0">No API targets found.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent API Receivers -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-info">Recent API Receivers</h6>
                    <a href="{{ route('api-receivers.index') }}" class="btn btn-sm btn-outline-info">View All</a>
                </div>
                <div class="card-body p-0">
                    @if($api_receivers->count() > 0)
                        <div class="list-group list-group-flush">
                        @foreach($api_receivers as $receiver)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">{{ $receiver->name }}</h6>
                                        <small class="text-muted">
                                            {{ $receiver->created_at->timezone('Asia/Jakarta')->translatedFormat('d F Y, H:i') }} WIB
                                        </small>
                                    </div>
                                    <span class="badge bg-{{ $receiver->is_active ? 'success' : 'secondary' }}">
                                        {{ $receiver->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <p class="text-muted mb-0">No API receivers found.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 