<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Debug API Tokens</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: #1a202c; color: #68d391; font-family: 'Consolas', 'Monaco', monospace; }
        .card { background: #2d3748; border: 1px solid #4a5568; }
        .card-header { background: #4a5568; }
        .btn-primary { background: #3182ce; border-color: #3182ce; }
        .btn-success { background: #38a169; border-color: #38a169; }
        .btn-warning { background: #d69e2e; border-color: #d69e2e; color: #000; }
        .btn-danger { background: #e53e3e; border-color: #e53e3e; }
        .alert-success { background: #22543d; border-color: #38a169; color: #68d391; }
        .alert-warning { background: #744210; border-color: #d69e2e; color: #faf089; }
        .alert-danger { background: #742a2a; border-color: #e53e3e; color: #feb2b2; }
        .form-control { background: #2d3748; border-color: #4a5568; color: #e2e8f0; }
        .form-control:focus { background: #2d3748; border-color: #3182ce; color: #e2e8f0; box-shadow: 0 0 0 0.2rem rgba(49, 130, 206, 0.25); }
        .form-select { background: #2d3748; border-color: #4a5568; color: #e2e8f0; }
        .output { background: #1a202c; border: 1px solid #4a5568; padding: 20px; border-radius: 8px; white-space: pre-wrap; font-family: monospace; }
    </style>
</head>
<body>
    <div class="container-fluid py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1><i class="fas fa-key me-3"></i>API Tokens Debug Center</h1>
                    <p class="lead">Troubleshoot API token creation and submission issues</p>
                </div>

                <!-- Method Test -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-network-wired me-2"></i>1. HTTP Method Test</h5>
                    </div>
                    <div class="card-body">
                        <p>Test which HTTP methods work for token routes:</p>
                        <div class="row g-2">
                            <div class="col-md-3">
                                <a href="{{ route('api-tokens.index') }}" class="btn btn-info w-100">
                                    <i class="fas fa-list"></i> GET Index
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="{{ route('api-tokens.create') }}" class="btn btn-primary w-100">
                                    <i class="fas fa-plus"></i> GET Create
                                </a>
                            </div>
                            <div class="col-md-3">
                                <form action="{{ route('test.form.data') }}" method="POST" class="d-inline w-100">
                                    @csrf
                                    <input type="hidden" name="test_route" value="api-tokens.store">
                                    <button type="submit" class="btn btn-warning w-100">
                                        <i class="fas fa-paper-plane"></i> POST Test
                                    </button>
                                </form>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-success w-100" onclick="checkRoutes()">
                                    <i class="fas fa-route"></i> Check Routes
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Test Token Creation Form -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-flask me-2"></i>2. Test Token Creation (Bypass CSRF)</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('test.api.token.store') }}" method="POST" id="testTokenForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="test_name" class="form-label">Token Name</label>
                                        <input type="text" class="form-control" id="test_name" name="name" value="Test Token {{ now()->format('H:i:s') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="test_client_id" class="form-label">API Client</label>
                                        <select class="form-select" id="test_client_id" name="api_client_id" required>
                                            <option value="">Select Client</option>
                                            @foreach(\App\Models\ApiClient::all() as $client)
                                                <option value="{{ $client->id }}">{{ $client->name }} ({{ $client->client_id }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Abilities</label>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="read" id="test_read" checked>
                                            <label class="form-check-label" for="test_read">Read</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="write" id="test_write">
                                            <label class="form-check-label" for="test_write">Write</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="*" id="test_all">
                                            <label class="form-check-label" for="test_all">All Permissions</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-rocket me-2"></i>Create Test Token (No CSRF)
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Real Form Test -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-shield-alt me-2"></i>3. Real Form Test (With CSRF)</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('api-tokens.store') }}" method="POST" id="realTokenForm">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="real_name" class="form-label">Token Name</label>
                                        <input type="text" class="form-control" id="real_name" name="name" value="Real Token {{ now()->format('H:i:s') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="real_client_id" class="form-label">API Client</label>
                                        <select class="form-select" id="real_client_id" name="api_client_id" required>
                                            <option value="">Select Client</option>
                                            @foreach(\App\Models\ApiClient::all() as $client)
                                                <option value="{{ $client->id }}">{{ $client->name }} ({{ $client->client_id }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Abilities</label>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="read" id="real_read" checked>
                                            <label class="form-check-label" for="real_read">Read</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="write" id="real_write">
                                            <label class="form-check-label" for="real_write">Write</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="abilities[]" value="*" id="real_all">
                                            <label class="form-check-label" for="real_all">All Permissions</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-key me-2"></i>Create Real Token (With CSRF)
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Debug Information -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-info-circle me-2"></i>4. Debug Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="output" id="debugOutput">
=== ROUTE INFORMATION ===
Current URL: {{ url()->current() }}
Base URL: {{ config('app.url') }}
CSRF Token: {{ csrf_token() }}
Session ID: {{ session()->getId() }}

=== API CLIENTS ===
Total Clients: {{ \App\Models\ApiClient::count() }}
@foreach(\App\Models\ApiClient::all() as $client)
- ID: {{ $client->id }}, Name: {{ $client->name }}, Client ID: {{ $client->client_id }}
@endforeach

=== API TOKENS ===
Total Tokens: {{ \App\Models\ApiToken::count() }}
@foreach(\App\Models\ApiToken::latest()->take(3)->get() as $token)
- ID: {{ $token->id }}, Name: {{ $token->name }}, Status: {{ $token->is_revoked ? 'Revoked' : 'Active' }}
@endforeach

=== ENVIRONMENT ===
Laravel Version: {{ app()->version() }}
PHP Version: {{ phpversion() }}
Environment: {{ config('app.env') }}
Debug Mode: {{ config('app.debug') ? 'ON' : 'OFF' }}
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-tools me-2"></i>5. Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-3">
                                <a href="{{ route('api-tokens.index') }}" class="btn btn-info w-100">
                                    <i class="fas fa-list"></i> View Tokens
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="{{ route('api-clients.index') }}" class="btn btn-warning w-100">
                                    <i class="fas fa-users"></i> View Clients
                                </a>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-danger w-100" onclick="clearSession()">
                                    <i class="fas fa-trash"></i> Clear Session
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-success w-100" onclick="refreshPage()">
                                    <i class="fas fa-sync"></i> Refresh Page
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function checkRoutes() {
            fetch('/debug/routes', {
                method: 'GET',
                headers: {
                    'Accept': 'application/json'
                }
            })
            .then(response => response.text())
            .then(data => {
                document.getElementById('debugOutput').innerHTML = data;
            })
            .catch(error => {
                document.getElementById('debugOutput').innerHTML = 'Error checking routes: ' + error;
            });
        }

        function clearSession() {
            if (confirm('Clear session and cookies?')) {
                window.location.href = '/fix-api-clients-csrf';
            }
        }

        function refreshPage() {
            window.location.reload();
        }

        // Form submission logging
        document.getElementById('testTokenForm').addEventListener('submit', function(e) {
            console.log('Test form submitting...', this.action);
        });

        document.getElementById('realTokenForm').addEventListener('submit', function(e) {
            console.log('Real form submitting...', this.action);
        });
    </script>
</body>
</html> 