@extends('layouts.app')

@section('title', 'Debug Form Submission')

@section('content')
<div class="container-fluid px-4">
    <h1 class="h3 mb-4">Debug Form Submission</h1>

    <!-- Test Form 1: Direct POST to test route -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Test 1: Direct POST to Test Route (No CSRF)</h5>
        </div>
        <div class="card-body">
            <form action="/test-form-data" method="POST">
                <input type="text" name="test_data" value="Hello World" class="form-control mb-2">
                <button type="submit" class="btn btn-primary">Submit Without CSRF</button>
            </form>
        </div>
    </div>

    <!-- Test Form 2: POST with CSRF -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Test 2: POST with CSRF Token</h5>
        </div>
        <div class="card-body">
            <form action="/test-form-data" method="POST">
                @csrf
                <input type="text" name="test_data" value="Hello World with CSRF" class="form-control mb-2">
                <button type="submit" class="btn btn-success">Submit With CSRF</button>
            </form>
            <div class="mt-2">
                <small>Current CSRF Token: <code>{{ substr(csrf_token(), 0, 20) }}...</code></small>
            </div>
        </div>
    </div>

    <!-- Test Form 3: API Token Store -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Test 3: API Token Store Route</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('api-tokens.store') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label>Token Name</label>
                    <input type="text" name="name" value="Test Token" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label>API Client ID</label>
                    <input type="number" name="api_client_id" value="1" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label>Abilities</label>
                    <input type="checkbox" name="abilities[]" value="read" checked> Read
                    <input type="checkbox" name="abilities[]" value="write"> Write
                </div>
                <button type="submit" class="btn btn-primary">Create API Token</button>
            </form>
        </div>
    </div>

    <!-- Session & Cookie Info -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Debug Information</h5>
        </div>
        <div class="card-body">
            <h6>Session Information:</h6>
            <ul>
                <li>Session ID: <code>{{ session()->getId() }}</code></li>
                <li>Session Token: <code>{{ substr(session()->token(), 0, 20) }}...</code></li>
                <li>Session Driver: <code>{{ config('session.driver') }}</code></li>
            </ul>

            <h6>Cookie Information:</h6>
            <ul>
                @foreach($_COOKIE as $name => $value)
                    <li>{{ $name }}: <code>{{ substr($value, 0, 20) }}...</code></li>
                @endforeach
            </ul>

            <h6>Routes:</h6>
            <ul>
                <li>api-tokens.store: <code>{{ route('api-tokens.store') }}</code></li>
                <li>test.form.data: <code>{{ route('test.form.data') }}</code></li>
            </ul>
        </div>
    </div>

    <!-- Clear Session -->
    <div class="card">
        <div class="card-header">
            <h5>Actions</h5>
        </div>
        <div class="card-body">
            <a href="/fix-api-clients-csrf" class="btn btn-warning">Clear Session & Cookies</a>
            <a href="{{ route('api-tokens.create') }}" class="btn btn-info">Go to API Tokens Create</a>
            
            <form action="{{ route('api-tokens.store') }}" method="GET" class="d-inline">
                <button type="submit" class="btn btn-danger">Test GET to Store Route (Should Fail)</button>
            </form>
        </div>
    </div>
</div>

<script>
// Log form submission attempts
document.querySelectorAll('form').forEach(form => {
    form.addEventListener('submit', function(e) {
        console.log('Form submission:', {
            action: this.action,
            method: this.method,
            csrf: this.querySelector('input[name="_token"]')?.value
        });
    });
});
</script>
@endsection 