@extends('layouts.app')

@section('title', 'Edit GET-Only Receiver: ' . $getOnlyReceiver->name)

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-edit me-2"></i>Edit GET-Only Receiver
        </h1>
        <div class="btn-group">
            <a href="{{ route('get-only-receivers.show', $getOnlyReceiver) }}" class="btn btn-info">
                <i class="fas fa-eye me-2"></i>View Details
            </a>
            <a href="{{ route('get-only-receivers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form action="{{ route('get-only-receivers.update', $getOnlyReceiver) }}" method="POST" id="editForm">
        @csrf
        @method('PUT')
        
        <div class="row">
            <!-- Basic Information -->
            <div class="col-lg-8">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Basic Information</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           value="{{ old('name', $getOnlyReceiver->name) }}" required>
                                    <div class="form-text">Descriptive name for this receiver</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="endpoint" class="form-label">Endpoint <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">/api/get/</span>
                                        <input type="text" class="form-control" id="endpoint" name="endpoint" 
                                               value="{{ old('endpoint', $getOnlyReceiver->endpoint) }}" required pattern="[a-zA-Z0-9\-_]+">
                                    </div>
                                    <div class="form-text">URL endpoint (alphanumeric, dash, underscore only)</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $getOnlyReceiver->description) }}</textarea>
                            <div class="form-text">Optional description of what this receiver provides</div>
                        </div>
                    </div>
                </div>

                <!-- Data Source Configuration -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Data Source Configuration</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <label for="data_source" class="form-label">Data Source <span class="text-danger">*</span></label>
                            <select class="form-control" id="data_source" name="data_source" required>
                                <option value="">Select Data Source</option>
                                <option value="table" {{ old('data_source', $getOnlyReceiver->data_source) === 'table' ? 'selected' : '' }}>Database Table</option>
                                <option value="api" {{ old('data_source', $getOnlyReceiver->data_source) === 'api' ? 'selected' : '' }}>External API</option>
                                <option value="custom" {{ old('data_source', $getOnlyReceiver->data_source) === 'custom' ? 'selected' : '' }}>Custom Query</option>
                            </select>
                        </div>

                        <!-- Table Source -->
                        <div id="table_source" class="data-source-config" style="display: none;">
                            <div class="form-group mb-3">
                                <label for="source_table" class="form-label">Source Table <span class="text-danger">*</span></label>
                                <select class="form-control" id="source_table" name="source_table">
                                    <option value="">Select Table</option>
                                    @foreach($tables as $table)
                                        <option value="{{ $table }}" {{ old('source_table', $getOnlyReceiver->source_table) === $table ? 'selected' : '' }}>
                                            {{ $table }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- API Source -->
                        <div id="api_source" class="data-source-config" style="display: none;">
                            <div class="form-group mb-3">
                                <label for="source_api_url" class="form-label">API URL <span class="text-danger">*</span></label>
                                <input type="url" class="form-control" id="source_api_url" name="source_api_url" 
                                       value="{{ old('source_api_url', $getOnlyReceiver->source_api_url) }}" placeholder="https://api.example.com/data">
                            </div>
                            <div class="form-group mb-3">
                                <label for="source_api_headers" class="form-label">API Headers (JSON)</label>
                                <textarea class="form-control" id="source_api_headers" name="source_api_headers" rows="3" 
                                          placeholder='{"Authorization": "Bearer token", "Content-Type": "application/json"}'>{{ old('source_api_headers', $getOnlyReceiver->source_api_headers ? json_encode($getOnlyReceiver->source_api_headers) : '') }}</textarea>
                            </div>
                        </div>

                        <!-- Custom Query -->
                        <div id="custom_source" class="data-source-config" style="display: none;">
                            <div class="form-group mb-3">
                                <label for="custom_query" class="form-label">Custom SQL Query <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="custom_query" name="custom_query" rows="5" 
                                          placeholder="SELECT * FROM users WHERE status = 'active'">{{ old('custom_query', $getOnlyReceiver->custom_query) }}</textarea>
                                <div class="form-text">Use :parameter_name for dynamic parameters</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Response Configuration -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Response Configuration</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="response_format" class="form-label">Response Format <span class="text-danger">*</span></label>
                                    <select class="form-control" id="response_format" name="response_format" required>
                                        <option value="json" {{ old('response_format', $getOnlyReceiver->response_format) === 'json' ? 'selected' : '' }}>JSON</option>
                                        <option value="xml" {{ old('response_format', $getOnlyReceiver->response_format) === 'xml' ? 'selected' : '' }}>XML</option>
                                        <option value="csv" {{ old('response_format', $getOnlyReceiver->response_format) === 'csv' ? 'selected' : '' }}>CSV</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label class="form-label">Enable Pagination</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="enable_pagination" 
                                               name="enable_pagination" value="1" {{ old('enable_pagination', $getOnlyReceiver->enable_pagination) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="enable_pagination">
                                            Enable pagination support
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="default_limit" class="form-label">Default Limit <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="default_limit" name="default_limit" 
                                           value="{{ old('default_limit', $getOnlyReceiver->default_limit) }}" min="1" max="1000" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="max_limit" class="form-label">Maximum Limit <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="max_limit" name="max_limit" 
                                           value="{{ old('max_limit', $getOnlyReceiver->max_limit) }}" min="1" max="10000" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="response_fields" class="form-label">Response Fields (Optional)</label>
                            <input type="text" class="form-control" id="response_fields" name="response_fields" 
                                   value="{{ old('response_fields', $getOnlyReceiver->response_fields ? implode(',', $getOnlyReceiver->response_fields) : '') }}" placeholder="field1,field2,field3">
                            <div class="form-text">Comma-separated list of fields to include in response (leave empty for all)</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security & Settings -->
            <div class="col-lg-4">
                <!-- Token Management -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Token Management</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="require_token" 
                                       name="require_token" value="1" {{ old('require_token', $getOnlyReceiver->require_token) ? 'checked' : '' }}>
                                <label class="form-check-label" for="require_token">
                                    Require API Token
                                </label>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="api_token_id" class="form-label">Primary Token</label>
                            <select class="form-control" id="api_token_id" name="api_token_id">
                                <option value="">Select Token</option>
                                @foreach($apiTokens as $token)
                                    <option value="{{ $token->id }}" {{ old('api_token_id', $getOnlyReceiver->api_token_id) == $token->id ? 'selected' : '' }}>
                                        {{ $token->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group mb-3">
                            <label for="allowed_tokens" class="form-label">Additional Allowed Tokens</label>
                            <select class="form-control" id="allowed_tokens" name="allowed_tokens[]" multiple>
                                @foreach($apiTokens as $token)
                                    <option value="{{ $token->id }}" {{ in_array($token->id, old('allowed_tokens', $getOnlyReceiver->allowed_tokens ?: [])) ? 'selected' : '' }}>
                                        {{ $token->name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="form-text">Hold Ctrl/Cmd to select multiple</div>
                        </div>
                    </div>
                </div>

                <!-- Rate Limiting -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Rate Limiting</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <label for="rate_limit_per_minute" class="form-label">Per Minute <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="rate_limit_per_minute" name="rate_limit_per_minute" 
                                   value="{{ old('rate_limit_per_minute', $getOnlyReceiver->rate_limit_per_minute) }}" min="1" max="1000" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="rate_limit_per_hour" class="form-label">Per Hour <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="rate_limit_per_hour" name="rate_limit_per_hour" 
                                   value="{{ old('rate_limit_per_hour', $getOnlyReceiver->rate_limit_per_hour) }}" min="1" max="10000" required>
                        </div>
                    </div>
                </div>

                <!-- Caching -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Caching</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="enable_cache" 
                                       name="enable_cache" value="1" {{ old('enable_cache', $getOnlyReceiver->enable_cache) ? 'checked' : '' }}>
                                <label class="form-check-label" for="enable_cache">
                                    Enable Response Caching
                                </label>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label for="cache_duration" class="form-label">Cache Duration (seconds) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="cache_duration" name="cache_duration" 
                                   value="{{ old('cache_duration', $getOnlyReceiver->cache_duration) }}" min="60" max="86400" required>
                        </div>
                    </div>
                </div>

                <!-- CORS -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">CORS Settings</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="enable_cors" 
                                       name="enable_cors" value="1" {{ old('enable_cors', $getOnlyReceiver->enable_cors) ? 'checked' : '' }}>
                                <label class="form-check-label" for="enable_cors">
                                    Enable CORS
                                </label>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label for="cors_origins" class="form-label">Allowed Origins</label>
                            <input type="text" class="form-control" id="cors_origins" name="cors_origins" 
                                   value="{{ old('cors_origins', $getOnlyReceiver->cors_origins ? implode(',', $getOnlyReceiver->cors_origins) : '') }}" placeholder="https://example.com,https://app.example.com">
                            <div class="form-text">Comma-separated list (leave empty for all origins)</div>
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" 
                                       name="is_active" value="1" {{ old('is_active', $getOnlyReceiver->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="form-group mt-4">
            <div class="row">
                <div class="col-12 mb-3">
                    <button type="submit" class="btn btn-success me-2" id="saveBtn">
                        <i class="fas fa-save me-2"></i>UPDATE GET-ONLY RECEIVER
                    </button>
                    <button type="button" class="btn btn-primary me-2" id="altSubmitBtn">
                        <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                    </button>
                </div>
                <div class="col-12 mb-3">
                    <button type="button" class="btn btn-info me-2" id="simpleSubmitBtn">
                        <i class="fas fa-paper-plane me-2"></i>SIMPLE SUBMIT
                    </button>
                    <button type="button" class="btn btn-secondary me-2" onclick="window.location.href='{{ route('get-only-receivers.index') }}'">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                    <button type="button" class="btn btn-warning me-2" id="testEndpointBtn">
                        <i class="fas fa-vial me-2"></i>Test Endpoint
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Handle data source change
    $('#data_source').change(function() {
        $('.data-source-config').hide();
        const selected = $(this).val();
        if (selected) {
            $(`#${selected}_source`).show();
        }
    });

    // Trigger change on page load
    $('#data_source').trigger('change');

    // Convert response fields to array
    $('#response_fields').on('blur', function() {
        const value = $(this).val();
        if (value) {
            const fields = value.split(',').map(f => f.trim()).filter(f => f);
            $(this).val(fields.join(','));
        }
    });

    // Convert CORS origins to array
    $('#cors_origins').on('blur', function() {
        const value = $(this).val();
        if (value) {
            const origins = value.split(',').map(o => o.trim()).filter(o => o);
            $(this).val(origins.join(','));
        }
    });

    // Form validation
    $('#editForm').on('submit', function(e) {
        const dataSource = $('#data_source').val();
        
        if (dataSource === 'table' && !$('#source_table').val()) {
            e.preventDefault();
            alert('Please select a source table.');
            return false;
        }
        
        if (dataSource === 'api' && !$('#source_api_url').val()) {
            e.preventDefault();
            alert('Please enter API URL.');
            return false;
        }
        
        if (dataSource === 'custom' && !$('#custom_query').val()) {
            e.preventDefault();
            alert('Please enter custom query.');
            return false;
        }
        
        return true;
    });

    // Handle button clicks
    $('#altSubmitBtn').on('click', function() {
        // Same as submit but with different styling
        $('#editForm').submit();
    });

    $('#simpleSubmitBtn').on('click', function() {
        // Simple submit - could be used for quick save without validation
        $('#editForm').submit();
    });

    $('#testEndpointBtn').on('click', function() {
        // Test endpoint functionality
        const endpoint = $('#endpoint').val();
        if (endpoint) {
            // Open test window or modal
            window.open('/api/get/' + endpoint + '?test=1', '_blank');
        } else {
            alert('Please enter an endpoint first.');
        }
    });
});
</script>
@endsection 