@extends('layouts.app')

@section('title', 'GET-Only Receivers')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-download me-2"></i>GET-Only Receivers
        </h1>
        <a href="{{ route('get-only-receivers.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-2"></i>Buat Receiver Baru
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(isset($error))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ $error }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(isset($message))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <i class="fas fa-info-circle me-2"></i>{{ $message }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Receivers
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total_receivers'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-download fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Receivers
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['active_receivers'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Requests
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_requests']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Success Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_requests'] > 0 ? round(($stats['total_success'] / $stats['total_requests']) * 100, 1) : 0 }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-percentage fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Receivers Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>Daftar GET-Only Receivers
            </h6>
        </div>
        <div class="card-body">
            @if($receivers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Endpoint</th>
                                <th>Data Source</th>
                                <th>Token</th>
                                <th>Status</th>
                                <th>Requests</th>
                                <th>Success Rate</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($receivers as $receiver)
                                <tr>
                                    <td>
                                        <strong>{{ $receiver->name }}</strong>
                                        @if($receiver->description)
                                            <br><small class="text-muted">{{ Str::limit($receiver->description, 50) }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <code>/api/get/{{ $receiver->endpoint }}</code>
                                        <br><small class="text-muted">{{ $receiver->response_format }}</small>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $receiver->data_source === 'table' ? 'info' : ($receiver->data_source === 'api' ? 'warning' : 'secondary') }}">
                                            {{ ucfirst($receiver->data_source) }}
                                        </span>
                                        @if($receiver->data_source === 'table' && $receiver->source_table)
                                            <br><small class="text-muted">{{ $receiver->source_table }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($receiver->require_token)
                                            <span class="badge badge-success">Required</span>
                                            @if($receiver->apiToken)
                                                <br><small class="text-muted">{{ $receiver->apiToken->name }}</small>
                                            @endif
                                        @else
                                            <span class="badge badge-secondary">Optional</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($receiver->is_active)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>{{ number_format($receiver->total_requests) }}</strong>
                                        @if($receiver->last_accessed_at)
                                            <br><small class="text-muted">{{ $receiver->last_accessed_at->diffForHumans() }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($receiver->total_requests > 0)
                                            @php
                                                $successRate = round(($receiver->total_success / $receiver->total_requests) * 100, 1);
                                            @endphp
                                            <span class="badge badge-{{ $successRate >= 95 ? 'success' : ($successRate >= 80 ? 'warning' : 'danger') }}">
                                                {{ $successRate }}%
                                            </span>
                                            <br><small class="text-muted">{{ number_format($receiver->total_success) }}/{{ number_format($receiver->total_requests) }}</small>
                                        @else
                                            <span class="badge badge-secondary">No Data</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('get-only-receivers.show', $receiver) }}" 
                                               class="btn btn-info btn-sm" title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('get-only-receivers.edit', $receiver) }}" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-success btn-sm" 
                                                    onclick="testReceiver({{ $receiver->id }})" title="Test Endpoint">
                                                <i class="fas fa-play"></i>
                                            </button>
                                            <button type="button" class="btn btn-danger btn-sm" 
                                                    onclick="deleteReceiver({{ $receiver->id }}, '{{ $receiver->name }}')" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $receivers->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-download fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada GET-Only Receiver</h5>
                    <p class="text-muted">Klik tombol "Buat Receiver Baru" untuk membuat receiver pertama Anda.</p>
                    <a href="{{ route('get-only-receivers.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Buat Receiver Baru
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Info Card -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-info-circle me-2"></i>Tentang GET-Only Receivers
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6><i class="fas fa-check-circle text-success me-2"></i>Fitur Utama:</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Hanya menerima metode GET</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Multiple data sources (Table, API, Custom Query)</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Response format (JSON, XML, CSV)</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Built-in pagination dan filtering</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Caching dan rate limiting</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6><i class="fas fa-cog text-info me-2"></i>Cara Menggunakan:</h6>
                            <ol class="list-unstyled">
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Buat GET-Only Receiver dengan data source</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Konfigurasi response format dan fields</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Set up authentication jika diperlukan</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Akses endpoint dengan GET request</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Apakah Anda yakin ingin menghapus receiver "<span id="receiverName"></span>"?
                <br><br>
                <strong>Tindakan ini tidak dapat dibatalkan.</strong>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Test Modal -->
<div class="modal fade" id="testModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Test GET-Only Receiver</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="testResult"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
function deleteReceiver(id, name) {
    document.getElementById('receiverName').textContent = name;
    document.getElementById('deleteForm').action = `/get-only-receivers/${id}`;
    
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}

function testReceiver(id) {
    const modal = new bootstrap.Modal(document.getElementById('testModal'));
    const resultDiv = document.getElementById('testResult');
    
    resultDiv.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Testing...</div>';
    modal.show();
    
    fetch(`/get-only-receivers/${id}/test`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            parameters: {},
            limit: 5
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            resultDiv.innerHTML = `
                <div class="alert alert-success">
                    <h6><i class="fas fa-check-circle"></i> Test Successful!</h6>
                    <p><strong>Endpoint URL:</strong> <code>${data.endpoint_url}</code></p>
                    <p><strong>Records Found:</strong> ${data.data.total}</p>
                    <p><strong>Response Time:</strong> ${data.data.meta ? data.data.meta.response_time : 'N/A'}</p>
                </div>
                <div class="mt-3">
                    <h6>Sample Data:</h6>
                    <pre class="bg-light p-3 rounded"><code>${JSON.stringify(data.data.data, null, 2)}</code></pre>
                </div>
            `;
        } else {
            resultDiv.innerHTML = `
                <div class="alert alert-danger">
                    <h6><i class="fas fa-exclamation-circle"></i> Test Failed!</h6>
                    <p>${data.message}</p>
                </div>
            `;
        }
    })
    .catch(error => {
        resultDiv.innerHTML = `
            <div class="alert alert-danger">
                <h6><i class="fas fa-exclamation-circle"></i> Error!</h6>
                <p>Failed to test receiver: ${error.message}</p>
            </div>
        `;
    });
}

// Initialize DataTable if available
$(document).ready(function() {
    if (typeof $('#dataTable').DataTable === 'function') {
        $('#dataTable').DataTable({
            "pageLength": 10,
            "order": [[ 0, "asc" ]],
            "columnDefs": [
                { "orderable": false, "targets": -1 }
            ]
        });
    }
});
</script>
@endsection 