@extends('layouts.app')

@section('title', 'GET-Only Receiver: ' . $getOnlyReceiver->name)

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-download me-2"></i>{{ $getOnlyReceiver->name }}
        </h1>
        <div class="btn-group">
            <a href="{{ route('get-only-receivers.edit', $getOnlyReceiver) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a href="{{ route('get-only-receivers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Basic Information -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Basic Information</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-primary">Name</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-primary">Endpoint</h6>
                            <p class="mb-3">
                                <code>/api/get/{{ $getOnlyReceiver->endpoint }}</code>
                                <button class="btn btn-sm btn-outline-primary ms-2" onclick="copyToClipboard('{{ url('/api/get/' . $getOnlyReceiver->endpoint) }}')">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </p>
                        </div>
                    </div>
                    
                    @if($getOnlyReceiver->description)
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Description</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->description }}</p>
                        </div>
                    </div>
                    @endif

                    <div class="row">
                        <div class="col-md-4">
                            <h6 class="text-primary">Data Source</h6>
                            <p class="mb-3">
                                <span class="badge badge-{{ $getOnlyReceiver->data_source === 'table' ? 'info' : ($getOnlyReceiver->data_source === 'api' ? 'warning' : 'secondary') }}">
                                    {{ ucfirst($getOnlyReceiver->data_source) }}
                                </span>
                            </p>
                        </div>
                        <div class="col-md-4">
                            <h6 class="text-primary">Response Format</h6>
                            <p class="mb-3">
                                <span class="badge badge-info">{{ strtoupper($getOnlyReceiver->response_format) }}</span>
                            </p>
                        </div>
                        <div class="col-md-4">
                            <h6 class="text-primary">Status</h6>
                            <p class="mb-3">
                                <span class="badge badge-{{ $getOnlyReceiver->is_active ? 'success' : 'secondary' }}">
                                    {{ $getOnlyReceiver->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Data Source Details -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Data Source Configuration</h6>
                </div>
                <div class="card-body">
                    @if($getOnlyReceiver->data_source === 'table')
                        <h6 class="text-primary">Source Table</h6>
                        <p class="mb-3"><code>{{ $getOnlyReceiver->source_table }}</code></p>
                    @elseif($getOnlyReceiver->data_source === 'api')
                        <h6 class="text-primary">API URL</h6>
                        <p class="mb-3"><code>{{ $getOnlyReceiver->source_api_url }}</code></p>
                        @if($getOnlyReceiver->source_api_headers)
                            <h6 class="text-primary">API Headers</h6>
                            <pre class="bg-light p-3 rounded"><code>{{ json_encode($getOnlyReceiver->source_api_headers, JSON_PRETTY_PRINT) }}</code></pre>
                        @endif
                    @elseif($getOnlyReceiver->data_source === 'custom')
                        <h6 class="text-primary">Custom Query</h6>
                        <pre class="bg-light p-3 rounded"><code>{{ $getOnlyReceiver->custom_query }}</code></pre>
                    @endif

                    @if($getOnlyReceiver->response_fields)
                        <h6 class="text-primary">Response Fields</h6>
                        <p class="mb-3">
                            @foreach($getOnlyReceiver->response_fields as $field)
                                <span class="badge badge-light me-1">{{ $field }}</span>
                            @endforeach
                        </p>
                    @endif

                    @if($getOnlyReceiver->default_filters)
                        <h6 class="text-primary">Default Filters</h6>
                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($getOnlyReceiver->default_filters, JSON_PRETTY_PRINT) }}</code></pre>
                    @endif

                    @if($getOnlyReceiver->allowed_filters)
                        <h6 class="text-primary">Allowed Filters</h6>
                        <p class="mb-3">
                            @foreach($getOnlyReceiver->allowed_filters as $filter)
                                <span class="badge badge-light me-1">{{ $filter }}</span>
                            @endforeach
                        </p>
                    @endif
                </div>
            </div>

            <!-- Test Section -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Test Endpoint</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group mb-3">
                                <label for="test_parameters" class="form-label">Test Parameters (JSON)</label>
                                <textarea class="form-control" id="test_parameters" rows="3" placeholder='{"param1": "value1", "param2": "value2"}'></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-3">
                                <label for="test_limit" class="form-label">Limit</label>
                                <input type="number" class="form-control" id="test_limit" value="5" min="1" max="10">
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-primary" onclick="testEndpoint()">
                        <i class="fas fa-play me-2"></i>Test Endpoint
                    </button>
                    <div id="test_result" class="mt-3"></div>
                </div>
            </div>
        </div>

        <!-- Statistics & Settings -->
        <div class="col-lg-4">
            <!-- Statistics -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistics</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Total Requests</h6>
                            <p class="mb-3 h4">{{ number_format($getOnlyReceiver->total_requests) }}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <h6 class="text-success">Success</h6>
                            <p class="mb-3">{{ number_format($getOnlyReceiver->total_success) }}</p>
                        </div>
                        <div class="col-6">
                            <h6 class="text-danger">Errors</h6>
                            <p class="mb-3">{{ number_format($getOnlyReceiver->total_errors) }}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <h6 class="text-primary">Success Rate</h6>
                            <p class="mb-3">{{ $recentStats['success_rate'] }}%</p>
                        </div>
                        <div class="col-6">
                            <h6 class="text-primary">Avg Response</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->avg_response_time }}ms</p>
                        </div>
                    </div>
                    @if($getOnlyReceiver->last_accessed_at)
                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-primary">Last Accessed</h6>
                                <p class="mb-3">{{ $getOnlyReceiver->last_accessed_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Token Management -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Token Management</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Token Required</h6>
                            <p class="mb-3">
                                <span class="badge badge-{{ $getOnlyReceiver->require_token ? 'success' : 'secondary' }}">
                                    {{ $getOnlyReceiver->require_token ? 'Yes' : 'No' }}
                                </span>
                            </p>
                        </div>
                    </div>
                    
                    @if($getOnlyReceiver->apiToken)
                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-primary">Primary Token</h6>
                                <p class="mb-3">{{ $getOnlyReceiver->apiToken->name }}</p>
                            </div>
                        </div>
                    @endif

                    @if($getOnlyReceiver->allowed_tokens && count($getOnlyReceiver->allowed_tokens) > 0)
                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-primary">Allowed Tokens</h6>
                                <div class="mb-3">
                                    @foreach($getOnlyReceiver->getAllowedApiTokens() as $token)
                                        <span class="badge badge-light me-1">{{ $token->name }}</span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Rate Limiting -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Rate Limiting</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <h6 class="text-primary">Per Minute</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->rate_limit_per_minute }}</p>
                        </div>
                        <div class="col-6">
                            <h6 class="text-primary">Per Hour</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->rate_limit_per_hour }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Caching -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Caching</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Cache Enabled</h6>
                            <p class="mb-3">
                                <span class="badge badge-{{ $getOnlyReceiver->enable_cache ? 'success' : 'secondary' }}">
                                    {{ $getOnlyReceiver->enable_cache ? 'Yes' : 'No' }}
                                </span>
                            </p>
                        </div>
                    </div>
                    @if($getOnlyReceiver->enable_cache)
                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-primary">Cache Duration</h6>
                                <p class="mb-3">{{ $getOnlyReceiver->cache_duration }} seconds</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Pagination -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Pagination</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Pagination Enabled</h6>
                            <p class="mb-3">
                                <span class="badge badge-{{ $getOnlyReceiver->enable_pagination ? 'success' : 'secondary' }}">
                                    {{ $getOnlyReceiver->enable_pagination ? 'Yes' : 'No' }}
                                </span>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <h6 class="text-primary">Default Limit</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->default_limit }}</p>
                        </div>
                        <div class="col-6">
                            <h6 class="text-primary">Max Limit</h6>
                            <p class="mb-3">{{ $getOnlyReceiver->max_limit }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const toast = document.createElement('div');
        toast.className = 'toast align-items-center text-white bg-success border-0';
        toast.setAttribute('role', 'alert');
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    URL copied to clipboard!
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        document.body.appendChild(toast);
        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();
        
        setTimeout(() => {
            document.body.removeChild(toast);
        }, 5000);
    }).catch(function(err) {
        console.error('Could not copy text: ', err);
    });
}

function testEndpoint() {
    const resultDiv = document.getElementById('test_result');
    const parametersText = document.getElementById('test_parameters').value;
    const limit = document.getElementById('test_limit').value;
    
    let parameters = {};
    if (parametersText.trim()) {
        try {
            parameters = JSON.parse(parametersText);
        } catch (e) {
            resultDiv.innerHTML = `
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i> Invalid JSON in parameters: ${e.message}
                </div>
            `;
            return;
        }
    }
    
    resultDiv.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Testing...</div>';
    
    fetch(`{{ route('get-only-receivers.test', $getOnlyReceiver) }}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            parameters: parameters,
            limit: parseInt(limit)
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            resultDiv.innerHTML = `
                <div class="alert alert-success">
                    <h6><i class="fas fa-check-circle"></i> Test Successful!</h6>
                    <p><strong>Records Found:</strong> ${data.data.total}</p>
                    <p><strong>Response Time:</strong> ${data.data.meta ? data.data.meta.response_time : 'N/A'}</p>
                </div>
                <div class="mt-3">
                    <h6>Sample Data:</h6>
                    <pre class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto;"><code>${JSON.stringify(data.data.data, null, 2)}</code></pre>
                </div>
                <div class="mt-3">
                    <h6>Full Endpoint URL:</h6>
                    <div class="input-group">
                        <input type="text" class="form-control" value="${data.endpoint_url}" readonly>
                        <button class="btn btn-outline-primary" onclick="copyToClipboard('${data.endpoint_url}')">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>
            `;
        } else {
            resultDiv.innerHTML = `
                <div class="alert alert-danger">
                    <h6><i class="fas fa-exclamation-circle"></i> Test Failed!</h6>
                    <p>${data.message}</p>
                </div>
            `;
        }
    })
    .catch(error => {
        resultDiv.innerHTML = `
            <div class="alert alert-danger">
                <h6><i class="fas fa-exclamation-circle"></i> Error!</h6>
                <p>Failed to test endpoint: ${error.message}</p>
            </div>
        `;
    });
}
</script>
@endsection 