<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Management System</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .hero-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .hero-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 3rem;
            text-align: center;
            max-width: 600px;
        }
        
        .logo-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 2rem;
            color: white;
            font-size: 2rem;
        }

        .logo-icon img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 20px;
            display: block;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 12px 30px;
            border-radius: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .btn-outline-custom {
            border: 2px solid #667eea;
            color: #667eea;
            padding: 12px 30px;
            border-radius: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-outline-custom:hover {
            background: #667eea;
            color: white;
            transform: translateY(-2px);
        }
        
        .feature-list {
            text-align: left;
            margin: 2rem 0;
        }
        
        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
            color: #6c757d;
        }
        
        .feature-item i {
            color: #667eea;
            margin-right: 1rem;
            width: 20px;
        }
        
        .auth-links {
            position: absolute;
            top: 2rem;
            right: 2rem;
        }
        
        .auth-links a {
            color: white;
            text-decoration: none;
            margin-left: 1rem;
            padding: 8px 20px;
            border-radius: 25px;
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }
        
        .auth-links a:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: translateY(-1px);
        }
    </style>
</head>
<body>
    <!-- Auth Links -->
    <div class="auth-links">
        <a href="{{ route('dashboard.index') }}">
            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
        </a>
        <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
            <i class="fas fa-sign-out-alt me-2"></i>Logout
        </a>
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    </div>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="hero-card">
                        <div class="logo-icon">
                            <img src="{{ asset('logo1.png') }}" alt="Logo">
                        </div>
                        
                        <h1 class="display-4 fw-bold text-dark mb-3">
                            API Management System
                        </h1>
                        
                        <p class="lead text-muted mb-4">
                            Sistem manajemen API yang powerful untuk mengelola sumber data, target pengiriman, dan penerimaan data API dengan mudah dan efisien.
                        </p>
                        
                        <div class="feature-list">
                            <div class="feature-item">
                                <i class="fas fa-database"></i>
                                <span>Kelola sumber data API dari berbagai endpoint</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-bullseye"></i>
                                <span>Kirim data ke target API dengan penjadwalan otomatis</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-inbox"></i>
                                <span>Terima data dari sistem eksternal dengan aman</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-chart-line"></i>
                                <span>Monitor dan analisis aktivitas API real-time</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-shield-alt"></i>
                                <span>Keamanan tingkat enterprise dengan autentikasi</span>
                            </div>
                        </div>
                        
                        <div class="d-flex gap-3 justify-content-center flex-wrap">
                            <a href="{{ route('dashboard.index') }}" class="btn btn-primary-custom">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                Ke Dashboard
                            </a>
                            <a href="{{ route('api-sources.index') }}" class="btn btn-outline-custom">
                                <i class="fas fa-database me-2"></i>
                                API Sources
                            </a>
                        </div>
                        
                        <div class="mt-4">
                            <small class="text-muted">
                                <i class="fas fa-code me-2"></i>
                                Built with Laravel {{ Illuminate\Foundation\Application::VERSION }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 