@extends('layouts.app')

@section('title', 'Monitoring')

@section('breadcrumb')
    <li class="breadcrumb-item active">Monitoring</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-chart-line me-2"></i>System Monitoring
        </h1>
        <button type="button" class="btn btn-primary" onclick="refreshPage()">
            <i class="fas fa-sync me-2"></i>Refresh
        </button>
    </div>

    <!-- System Status Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                System Status
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <span class="badge badge-success">Online</span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-server fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active APIs
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\ApiSource::where('status', 'active')->count() + \App\Models\ApiTarget::where('is_active', true)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Today's Requests
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\ApiLog::whereDate('created_at', today())->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Error Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                @php
                                    $totalLogs = \App\Models\ApiLog::whereDate('created_at', today())->count();
                                    $errorLogs = \App\Models\ApiLog::whereDate('created_at', today())->where('status_code', '>=', 400)->count();
                                    $errorRate = $totalLogs > 0 ? round(($errorLogs / $totalLogs) * 100, 1) : 0;
                                @endphp
                                {{ $errorRate }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>Recent API Activity
            </h6>
        </div>
        <div class="card-body">
            @php
                $recentLogs = \App\Models\ApiLog::with('apiSource')->latest()->limit(10)->get();
            @endphp
            
            @if($recentLogs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Time</th>
                                <th>API Source</th>
                                <th>Status</th>
                                <th>Response Time</th>
                                <th>Details</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentLogs as $log)
                                <tr>
                                    <td>{{ $log->created_at->format('H:i:s') }}</td>
                                    <td>{{ $log->apiSource->name ?? 'Unknown' }}</td>
                                    <td>
                                        <span class="badge badge-{{ $log->status_code < 300 ? 'success' : ($log->status_code < 400 ? 'warning' : 'danger') }}">
                                            {{ $log->status_code }}
                                        </span>
                                    </td>
                                    <td>{{ number_format($log->response_time, 2) }}s</td>
                                    <td>
                                        @if($log->error_message)
                                            <span class="text-danger">{{ Str::limit($log->error_message, 50) }}</span>
                                        @else
                                            <span class="text-success">Success</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-chart-line fa-2x text-gray-300 mb-2"></i>
                    <p class="text-muted">No recent activity found</p>
                </div>
            @endif
        </div>
    </div>

    <!-- System Information -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>System Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <p><strong>PHP Version:</strong></p>
                            <p><strong>Laravel Version:</strong></p>
                            <p><strong>Database:</strong></p>
                            <p><strong>Server Time:</strong></p>
                        </div>
                        <div class="col-sm-6">
                            <p>{{ PHP_VERSION }}</p>
                            <p>{{ app()->version() }}</p>
                            <p>{{ config('database.default') }}</p>
                            <p>{{ now()->format('d M Y, H:i:s T') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-database me-2"></i>Database Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <p><strong>API Sources:</strong></p>
                            <p><strong>API Targets:</strong></p>
                            <p><strong>API Receivers:</strong></p>
                            <p><strong>Total Logs:</strong></p>
                        </div>
                        <div class="col-sm-6">
                            <p>{{ \App\Models\ApiSource::count() }}</p>
                            <p>{{ \App\Models\ApiTarget::count() }}</p>
                            <p>{{ \App\Models\ApiReceiver::count() }}</p>
                            <p>{{ \App\Models\ApiLog::count() }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function refreshPage() {
    location.reload();
}

// Auto-refresh every 30 seconds
setInterval(function() {
    location.reload();
}, 30000);
</script>
@endsection 