@extends('layouts.app')

@section('title', 'Buat POST-Only Receiver')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-plus me-2"></i>Buat POST-Only Receiver
        </h1>
        <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
    </div>

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Form -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-cog me-2"></i>Konfigurasi Receiver
                    </h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('post-only-receivers.store') }}" method="POST" id="createForm">
                        @csrf
                        
                        <!-- Basic Information -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name" class="form-label">Nama Receiver <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name') }}" required
                                           placeholder="Masukkan nama receiver">
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="endpoint" class="form-label">Endpoint <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('endpoint') is-invalid @enderror" 
                                           id="endpoint" name="endpoint" value="{{ old('endpoint') }}" required
                                           placeholder="contoh: webhook-data">
                                    <div class="form-text">URL: <code id="endpoint-url">{{ url('/api/post/') }}/[endpoint]</code></div>
                                    @error('endpoint')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description" class="form-label">Deskripsi</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" 
                                              id="description" name="description" rows="3" 
                                              placeholder="Deskripsi receiver (opsional)">{{ old('description') }}</textarea>
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- API Integration -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="api_client_id" class="form-label">API Client</label>
                                    <select class="form-control @error('api_client_id') is-invalid @enderror" 
                                            id="api_client_id" name="api_client_id" onchange="toggleTokenRequirement()">
                                        <option value="">Pilih API Client (Opsional)</option>
                                        @foreach($apiClients as $client)
                                            <option value="{{ $client->id }}" {{ old('api_client_id') == $client->id ? 'selected' : '' }}>
                                                {{ $client->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('api_client_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="target_table" class="form-label">
                                        Target Table <span class="text-danger">*</span>
                                        <small class="text-muted">({{ count($tables) }} tabel tersedia)</small>
                                    </label>
                                    <select class="form-control @error('target_table') is-invalid @enderror" 
                                            id="target_table" name="target_table" required>
                                        <option value="">Pilih Target Table</option>
                                        @foreach($tables as $table)
                                            <option value="{{ $table }}" {{ old('target_table') === $table ? 'selected' : '' }}>
                                                {{ $table }}
                                            </option>
                                        @endforeach
                                        <option value="__custom__">+ Buat Tabel Baru (Custom)</option>
                                    </select>
                                    <input type="text" class="form-control mt-2 @error('target_table') is-invalid @enderror" 
                                           id="custom_table_name" name="custom_table_name" style="display: none;"
                                           placeholder="Masukkan nama tabel baru (contoh: user_data, webhook_logs)">
                                    @error('target_table')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">
                                        Pilih tabel database untuk menyimpan data yang diterima
                                        <br><small class="text-success">
                                            <i class="fas fa-lightbulb"></i> 
                                            Tip: Gunakan "Auto Create Table" jika tabel belum ada
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Security Settings -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="require_token" 
                                               name="require_token" {{ old('require_token') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="require_token">
                                            Memerlukan Token API
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">Jika dicentang, request harus menyertakan Bearer Token</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="rate_limit" class="form-label">Rate Limit (per jam)</label>
                                    <input type="number" class="form-control @error('rate_limit') is-invalid @enderror" 
                                           id="rate_limit" name="rate_limit" value="{{ old('rate_limit', 1000) }}" 
                                           min="1" placeholder="1000">
                                    @error('rate_limit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Data Processing -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="auto_create_table" 
                                               name="auto_create_table" {{ old('auto_create_table') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="auto_create_table">
                                            Auto Create Table
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">Otomatis membuat tabel jika belum ada</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_active" 
                                               name="is_active" {{ old('is_active', true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Aktif
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">Receiver dapat menerima data</small>
                                </div>
                            </div>
                        </div>

                        <!-- Sample Data -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sample_data_input" class="form-label">Sample Data (JSON)</label>
                                    <textarea class="form-control @error('sample_data') is-invalid @enderror" 
                                              id="sample_data_input" name="sample_data_input" rows="5" 
                                              placeholder='{"field1": "value1", "field2": 123, "field3": true}'>{{ old('sample_data_input') }}</textarea>
                                    <small class="form-text text-muted">Contoh data untuk auto-create table dan dokumentasi</small>
                                    @error('sample_data')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="form-group mt-4">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-success btn-lg me-2" id="saveBtn">
                                        <i class="fas fa-save me-2"></i>SAVE POST-ONLY RECEIVER
                                    </button>
                                    <button type="button" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                                    </button>
                                </div>
                                <div class="col-12 mb-3">
                                    <button type="button" class="btn btn-info me-2" id="simpleSubmitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>SIMPLE SUBMIT
                                    </button>
                                    <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary me-2">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                    <button type="button" class="btn btn-warning me-2" onclick="testEndpoint()">
                                        <i class="fas fa-flask me-2"></i>Test Endpoint
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Help & Info -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-question-circle me-2"></i>Bantuan
                    </h6>
                </div>
                <div class="card-body">
                    <h6><i class="fas fa-info-circle text-primary me-2"></i>Cara Menggunakan:</h6>
                    <ol class="small">
                        <li>Pilih API Client yang sudah dibuat</li>
                        <li>Centang "Memerlukan Token API" jika ingin secure</li>
                        <li>Tentukan target table untuk menyimpan data</li>
                        <li>Isi sample data untuk auto-create table</li>
                        <li>Test endpoint sebelum menyimpan</li>
                    </ol>

                    <h6><i class="fas fa-code text-success me-2"></i>Contoh Request:</h6>
                    <pre class="bg-light p-2 rounded small"><code>curl -X POST {{ url('/api/post/') }}/[endpoint] \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"field1": "value1", "field2": 123}'</code></pre>

                    <h6><i class="fas fa-shield-alt text-warning me-2"></i>Keamanan:</h6>
                    <ul class="small">
                        <li>Token divalidasi dari API Token Management</li>
                        <li>Rate limiting per IP address</li>
                        <li>IP whitelist (opsional)</li>
                        <li>Validasi data otomatis</li>
                    </ul>
                </div>
            </div>

            @if($apiClients->count() == 0)
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>Perhatian
                        </h6>
                    </div>
                    <div class="card-body">
                        <p class="text-warning">Belum ada API Client yang tersedia.</p>
                        <a href="{{ route('api-clients.create') }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-plus me-2"></i>Buat API Client
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<script>
// Update endpoint URL preview
document.getElementById('endpoint').addEventListener('input', function() {
    const endpoint = this.value;
    const urlPreview = document.getElementById('endpoint-url');
    urlPreview.textContent = '{{ url("/api/post/") }}/' + (endpoint || '[endpoint]');
});

// Toggle token requirement based on API client selection
function toggleTokenRequirement() {
    const apiClientSelect = document.getElementById('api_client_id');
    const tokenCheckbox = document.getElementById('require_token');
    
    if (apiClientSelect.value) {
        tokenCheckbox.checked = true;
        tokenCheckbox.disabled = false;
    } else {
        tokenCheckbox.checked = false;
        tokenCheckbox.disabled = true;
    }
}

// Test endpoint functionality
function testEndpoint() {
    const endpoint = document.getElementById('endpoint').value;
    const requireToken = document.getElementById('require_token').checked;
    const apiClientId = document.getElementById('api_client_id').value;
    
    if (!endpoint) {
        alert('Harap isi endpoint terlebih dahulu!');
        return;
    }
    
    let testInfo = `Informasi Test Endpoint:\n\n`;
    testInfo += `URL: {{ url('/api/post/') }}/${endpoint}\n`;
    testInfo += `Method: POST\n`;
    testInfo += `Token Required: ${requireToken ? 'Ya' : 'Tidak'}\n`;
    
    if (requireToken && apiClientId) {
        testInfo += `API Client: Terpilih\n`;
        testInfo += `\nCatatan: Anda perlu Bearer Token yang valid untuk testing!`;
    }
    
    testInfo += `\n\nReceiver harus disimpan terlebih dahulu sebelum dapat menerima data.`;
    
    alert(testInfo);
}

// Convert sample data to JSON before submit
document.getElementById('createForm').addEventListener('submit', function(e) {
    const sampleDataInput = document.getElementById('sample_data_input').value;
    
    if (sampleDataInput.trim()) {
        try {
            const sampleData = JSON.parse(sampleDataInput);
            
            // Create hidden input for sample_data
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'sample_data';
            hiddenInput.value = JSON.stringify(sampleData);
            this.appendChild(hiddenInput);
        } catch (error) {
            e.preventDefault();
            alert('Sample data harus berupa JSON yang valid!');
            return false;
        }
    }
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleTokenRequirement();
});

// Handle button clicks
document.getElementById('altSubmitBtn').addEventListener('click', function() {
    // Same as submit but with different styling
    document.getElementById('createForm').submit();
});

document.getElementById('simpleSubmitBtn').addEventListener('click', function() {
    // Simple submit - could be used for quick save without validation
    document.getElementById('createForm').submit();
});

$('#debugTestBtn').on('click', function() {
    // Open debug window
    const endpoint = $('#endpoint').val();
    if (endpoint) {
        window.open('/debug/post-receiver-test?endpoint=' + endpoint, '_blank');
    } else {
        alert('Please enter an endpoint first.');
    }
});

// Handle target table selection
$('#target_table').on('change', function() {
    const selectedValue = $(this).val();
    const customInput = $('#custom_table_name');
    
    if (selectedValue === '__custom__') {
        customInput.show().attr('required', true);
        customInput.attr('name', 'target_table');
        $(this).attr('name', 'target_table_select');
        customInput.focus(); // Focus on the custom input
    } else {
        customInput.hide().attr('required', false);
        customInput.attr('name', 'custom_table_name');
        $(this).attr('name', 'target_table');
    }
});

// Validate custom table name format
$('#custom_table_name').on('input', function() {
    const value = $(this).val();
    const isValid = /^[a-zA-Z_][a-zA-Z0-9_]*$/.test(value);
    
    if (value && !isValid) {
        $(this).addClass('is-invalid');
        if (!$(this).siblings('.invalid-feedback').length) {
            $(this).after('<div class="invalid-feedback">Nama tabel hanya boleh menggunakan huruf, angka, dan underscore. Harus dimulai dengan huruf atau underscore.</div>');
        }
    } else {
        $(this).removeClass('is-invalid');
        $(this).siblings('.invalid-feedback').remove();
    }
});

// Initialize on page load
$(document).ready(function() {
    const selectedValue = $('#target_table').val();
    if (selectedValue === '__custom__') {
        $('#custom_table_name').show().attr('required', true);
        $('#custom_table_name').attr('name', 'target_table');
        $('#target_table').attr('name', 'target_table_select');
    }
});
</script>
@endsection 