@extends('layouts.app')

@section('title', 'Edit POST-Only Receiver')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-edit me-2"></i>Edit POST-Only Receiver
        </h1>
        <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-cog me-2"></i>Konfigurasi Receiver
                    </h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('post-only-receivers.update', $postOnlyReceiver) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Nama Receiver</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $postOnlyReceiver->name) }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="endpoint" class="form-label">Endpoint</label>
                                    <input type="text" class="form-control @error('endpoint') is-invalid @enderror" 
                                           id="endpoint" name="endpoint" value="{{ old('endpoint', $postOnlyReceiver->endpoint) }}" required>
                                    @error('endpoint')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">URL endpoint tanpa slash di awal. Contoh: my-endpoint</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="target_table" class="form-label">
                                        Target Table
                                        <small class="text-muted">({{ count($tables) }} tabel tersedia)</small>
                                    </label>
                                    <select class="form-control @error('target_table') is-invalid @enderror" 
                                            id="target_table" name="target_table" required>
                                        <option value="">Pilih Target Table</option>
                                        @foreach($tables as $table)
                                            <option value="{{ $table }}" {{ old('target_table', $postOnlyReceiver->target_table) === $table ? 'selected' : '' }}>
                                                {{ $table }}
                                            </option>
                                        @endforeach
                                        <option value="__custom__" {{ old('target_table', $postOnlyReceiver->target_table) && !in_array(old('target_table', $postOnlyReceiver->target_table), $tables) ? 'selected' : '' }}>+ Buat Tabel Baru (Custom)</option>
                                    </select>
                                    <input type="text" class="form-control mt-2 @error('target_table') is-invalid @enderror" 
                                           id="custom_table_name" name="custom_table_name" 
                                           style="display: {{ old('target_table', $postOnlyReceiver->target_table) && !in_array(old('target_table', $postOnlyReceiver->target_table), $tables) ? 'block' : 'none' }};"
                                           value="{{ old('target_table', $postOnlyReceiver->target_table) && !in_array(old('target_table', $postOnlyReceiver->target_table), $tables) ? old('target_table', $postOnlyReceiver->target_table) : '' }}"
                                           placeholder="Masukkan nama tabel baru (contoh: user_data, webhook_logs)">
                                    @error('target_table')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div class="form-text">
                                        Pilih tabel database untuk menyimpan data yang diterima
                                        <br><small class="text-success">
                                            <i class="fas fa-lightbulb"></i> 
                                            Tip: Gunakan "Auto Create Table" jika tabel belum ada
                                        </small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="api_client_id" class="form-label">API Client</label>
                                    <select class="form-select @error('api_client_id') is-invalid @enderror" 
                                            id="api_client_id" name="api_client_id">
                                        <option value="">Pilih API Client</option>
                                        @foreach($apiClients as $client)
                                            <option value="{{ $client->id }}" 
                                                    {{ old('api_client_id', $postOnlyReceiver->api_client_id) == $client->id ? 'selected' : '' }}>
                                                {{ $client->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('api_client_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Deskripsi</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="3">{{ old('description', $postOnlyReceiver->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="require_token" 
                                               name="require_token" value="1" 
                                               {{ old('require_token', $postOnlyReceiver->require_token) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="require_token">
                                            Memerlukan Token API
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_active" 
                                               name="is_active" value="1" 
                                               {{ old('is_active', $postOnlyReceiver->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Aktif
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="field_mapping" class="form-label">Field Mapping (JSON)</label>
                            <textarea class="form-control @error('field_mapping') is-invalid @enderror" 
                                      id="field_mapping" name="field_mapping" rows="5">{{ old('field_mapping', $postOnlyReceiver->field_mapping) }}</textarea>
                            @error('field_mapping')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">
                                Mapping field dari request ke database. Contoh: {"name": "nama", "email": "email"}
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="validation_rules" class="form-label">Validation Rules (JSON)</label>
                            <textarea class="form-control @error('validation_rules') is-invalid @enderror" 
                                      id="validation_rules" name="validation_rules" rows="5">{{ old('validation_rules', $postOnlyReceiver->validation_rules) }}</textarea>
                            @error('validation_rules')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">
                                Aturan validasi Laravel. Contoh: {"name": "required|string", "email": "required|email"}
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="form-group mt-4">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-success btn-lg me-2" id="saveBtn">
                                        <i class="fas fa-save me-2"></i>UPDATE POST-ONLY RECEIVER
                                    </button>
                                    <button type="button" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                                    </button>
                                </div>
                                <div class="col-12 mb-3">
                                    <button type="button" class="btn btn-info me-2" id="simpleSubmitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>SIMPLE SUBMIT
                                    </button>
                                    <a href="{{ route('post-only-receivers.show', $postOnlyReceiver) }}" class="btn btn-warning me-2">
                                        <i class="fas fa-eye me-2"></i>View Details
                                    </a>
                                    <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary me-2">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                    <button type="button" class="btn btn-outline-primary me-2" onclick="testEndpoint()">
                                        <i class="fas fa-flask me-2"></i>Test Endpoint
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-info-circle me-2"></i>Informasi
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Full URL:</strong><br>
                        <code>{{ url('/api/post/' . $postOnlyReceiver->endpoint) }}</code>
                    </div>
                    <div class="mb-3">
                        <strong>Metode:</strong><br>
                        <span class="badge bg-success">POST</span>
                    </div>
                    <div class="mb-3">
                        <strong>Dibuat:</strong><br>
                        {{ $postOnlyReceiver->created_at->format('d M Y H:i') }}
                    </div>
                    <div class="mb-3">
                        <strong>Diupdate:</strong><br>
                        {{ $postOnlyReceiver->updated_at->format('d M Y H:i') }}
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="fas fa-chart-line me-2"></i>Statistik
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="h4 mb-0 font-weight-bold text-primary">{{ number_format($postOnlyReceiver->total_received) }}</div>
                            <div class="text-xs font-weight-bold text-uppercase tracking-wide">Total</div>
                        </div>
                        <div class="col-6">
                            <div class="h4 mb-0 font-weight-bold text-success">{{ $postOnlyReceiver->success_rate }}%</div>
                            <div class="text-xs font-weight-bold text-uppercase tracking-wide">Success Rate</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Handle button clicks
document.getElementById('altSubmitBtn').addEventListener('click', function() {
    // Same as submit but with different styling
    document.querySelector('form').submit();
});

document.getElementById('simpleSubmitBtn').addEventListener('click', function() {
    // Simple submit - could be used for quick save without validation
    document.querySelector('form').submit();
});

// Test endpoint functionality
function testEndpoint() {
    const endpoint = '{{ $postOnlyReceiver->endpoint }}';
    const requireToken = {{ $postOnlyReceiver->require_token ? 'true' : 'false' }};
    const apiClientId = '{{ $postOnlyReceiver->api_client_id }}';
    
    let testInfo = `Informasi Test Endpoint:\n\n`;
    testInfo += `URL: {{ url('/api/post/' . $postOnlyReceiver->endpoint) }}\n`;
    testInfo += `Method: POST\n`;
    testInfo += `Token Required: ${requireToken ? 'Ya' : 'Tidak'}\n`;
    
    if (requireToken && apiClientId) {
        testInfo += `API Client: Terpilih\n`;
        testInfo += `\nCatatan: Anda perlu Bearer Token yang valid untuk testing!`;
    }
    
    testInfo += `\n\nEndpoint sudah aktif dan siap menerima data.`;
    
    alert(testInfo);
}

$('#debugTestBtn').on('click', function() {
    // Open debug window
    const endpoint = $('#endpoint').val();
    if (endpoint) {
        window.open('/debug/post-receiver-test?endpoint=' + endpoint, '_blank');
    } else {
        alert('Please enter an endpoint first.');
    }
});

// Handle target table selection
$('#target_table').on('change', function() {
    const selectedValue = $(this).val();
    const customInput = $('#custom_table_name');
    
    if (selectedValue === '__custom__') {
        customInput.show().attr('required', true);
        customInput.attr('name', 'target_table');
        $(this).attr('name', 'target_table_select');
        customInput.focus(); // Focus on the custom input
    } else {
        customInput.hide().attr('required', false);
        customInput.attr('name', 'custom_table_name');
        $(this).attr('name', 'target_table');
    }
});

// Validate custom table name format
$('#custom_table_name').on('input', function() {
    const value = $(this).val();
    const isValid = /^[a-zA-Z_][a-zA-Z0-9_]*$/.test(value);
    
    if (value && !isValid) {
        $(this).addClass('is-invalid');
        if (!$(this).siblings('.invalid-feedback').length) {
            $(this).after('<div class="invalid-feedback">Nama tabel hanya boleh menggunakan huruf, angka, dan underscore. Harus dimulai dengan huruf atau underscore.</div>');
        }
    } else {
        $(this).removeClass('is-invalid');
        $(this).siblings('.invalid-feedback').remove();
    }
});

// Initialize on page load
$(document).ready(function() {
    const selectedValue = $('#target_table').val();
    const customInput = $('#custom_table_name');
    
    if (selectedValue === '__custom__') {
        customInput.show().attr('required', true);
        customInput.attr('name', 'target_table');
        $('#target_table').attr('name', 'target_table_select');
    }
});
</script>
@endsection 