@extends('layouts.app')

@section('title', 'POST-Only Receivers')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-inbox me-2"></i>POST-Only Receivers
        </h1>
        <a href="{{ route('post-only-receivers.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-2"></i>Buat Receiver Baru
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Receivers Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>Daftar POST-Only Receivers
            </h6>
        </div>
        <div class="card-body">
            @if($receivers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Nama</th>
                                <th>Endpoint</th>
                                <th>Target Table</th>
                                <th>API Client</th>
                                <th>Token Required</th>
                                <th>Status</th>
                                <th>Statistics</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($receivers as $receiver)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $receiver->name }}</div>
                                        @if($receiver->description)
                                            <small class="text-muted">{{ Str::limit($receiver->description, 50) }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <code class="bg-light p-1 rounded">{{ $receiver->endpoint }}</code>
                                        <br>
                                        <small class="text-muted">
                                            <i class="fas fa-link me-1"></i>
                                            {{ url('/api/post/' . $receiver->endpoint) }}
                                        </small>
                                    </td>
                                    <td>
                                        <code class="bg-light p-1 rounded">{{ $receiver->target_table }}</code>
                                    </td>
                                    <td>
                                        @if($receiver->apiClient)
                                            <span class="badge bg-info">{{ $receiver->apiClient->name }}</span>
                                        @else
                                            <span class="badge bg-secondary">Tidak Ada</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($receiver->require_token)
                                            <span class="badge bg-warning">
                                                <i class="fas fa-lock me-1"></i>Ya
                                            </span>
                                        @else
                                            <span class="badge bg-success">
                                                <i class="fas fa-unlock me-1"></i>Tidak
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($receiver->is_active)
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i>Aktif
                                            </span>
                                        @else
                                            <span class="badge bg-danger">
                                                <i class="fas fa-times-circle me-1"></i>Nonaktif
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div><strong>Total:</strong> {{ number_format($receiver->total_received) }}</div>
                                            <div><strong>Sukses:</strong> {{ number_format($receiver->total_success) }}</div>
                                            <div><strong>Gagal:</strong> {{ number_format($receiver->total_failed) }}</div>
                                            <div><strong>Rate:</strong> {{ $receiver->success_rate }}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('post-only-receivers.show', $receiver) }}" 
                                               class="btn btn-info btn-sm" title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('post-only-receivers.edit', $receiver) }}" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="{{ route('post-only-receivers.logs', $receiver) }}" 
                                               class="btn btn-secondary btn-sm" title="Lihat Logs">
                                                <i class="fas fa-history"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm" 
                                                    onclick="deleteReceiver({{ $receiver->id }})" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $receivers->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada POST-Only Receiver</h5>
                    <p class="text-muted">Klik tombol "Buat Receiver Baru" untuk membuat receiver pertama Anda.</p>
                    <a href="{{ route('post-only-receivers.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Buat Receiver Baru
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Info Card -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-info-circle me-2"></i>Tentang POST-Only Receivers
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6><i class="fas fa-check-circle text-success me-2"></i>Fitur Utama:</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Hanya menerima metode POST</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Integrasi dengan API Token Management</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Validasi data otomatis</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Rate limiting per IP</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Auto-create target table</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6><i class="fas fa-cog text-info me-2"></i>Cara Menggunakan:</h6>
                            <ol class="list-unstyled">
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Buat API Client di menu API Management</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Generate API Token untuk client</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Buat POST-Only Receiver dengan client terkait</li>
                                <li><i class="fas fa-arrow-right text-primary me-2"></i>Kirim data POST dengan Bearer Token</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Apakah Anda yakin ingin menghapus receiver ini? Tindakan ini tidak dapat dibatalkan.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function deleteReceiver(id) {
    const form = document.getElementById('deleteForm');
    form.action = `/post-only-receivers/${id}`;
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}
</script>
@endsection 