@extends('layouts.app')

@section('title', 'POST-Only Receiver Logs')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-history me-2"></i>Logs: {{ $postOnlyReceiver->name }}
        </h1>
        <div>
            <a href="{{ route('post-only-receivers.show', $postOnlyReceiver) }}" class="btn btn-info btn-sm">
                <i class="fas fa-eye me-2"></i>Detail Receiver
            </a>
            <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <!-- Filter -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter me-2"></i>Filter Logs
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('post-only-receivers.logs', $postOnlyReceiver) }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="200" {{ request('status') == '200' ? 'selected' : '' }}>200 - Success</option>
                                <option value="400" {{ request('status') == '400' ? 'selected' : '' }}>400 - Bad Request</option>
                                <option value="401" {{ request('status') == '401' ? 'selected' : '' }}>401 - Unauthorized</option>
                                <option value="422" {{ request('status') == '422' ? 'selected' : '' }}>422 - Validation Error</option>
                                <option value="500" {{ request('status') == '500' ? 'selected' : '' }}>500 - Server Error</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="ip_address" class="form-label">IP Address</label>
                            <input type="text" class="form-control" id="ip_address" name="ip_address" 
                                   value="{{ request('ip_address') }}" placeholder="192.168.1.1">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="date_from" class="form-label">Dari Tanggal</label>
                            <input type="date" class="form-control" id="date_from" name="date_from" 
                                   value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="date_to" class="form-label">Sampai Tanggal</label>
                            <input type="date" class="form-control" id="date_to" name="date_to" 
                                   value="{{ request('date_to') }}">
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-2"></i>Filter
                    </button>
                    <a href="{{ route('post-only-receivers.logs', $postOnlyReceiver) }}" class="btn btn-secondary">
                        <i class="fas fa-refresh me-2"></i>Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>Request Logs ({{ $logs->total() }} total)
            </h6>
        </div>
        <div class="card-body">
            @if($logs->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Waktu</th>
                                <th>IP Address</th>
                                <th>Status</th>
                                <th>Token Valid</th>
                                <th>Data Size</th>
                                <th>Response Time</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($logs as $log)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $log->created_at->format('d M Y') }}</div>
                                        <small class="text-muted">{{ $log->created_at->format('H:i:s') }}</small>
                                    </td>
                                    <td>
                                        <code>{{ $log->ip_address }}</code>
                                    </td>
                                    <td>
                                        @if($log->status_code == 200)
                                            <span class="badge bg-success">{{ $log->status_code }} Success</span>
                                        @elseif($log->status_code == 400)
                                            <span class="badge bg-warning">{{ $log->status_code }} Bad Request</span>
                                        @elseif($log->status_code == 401)
                                            <span class="badge bg-danger">{{ $log->status_code }} Unauthorized</span>
                                        @elseif($log->status_code == 422)
                                            <span class="badge bg-info">{{ $log->status_code }} Validation Error</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $log->status_code }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->token_valid)
                                            <span class="badge bg-success">
                                                <i class="fas fa-check me-1"></i>Valid
                                            </span>
                                        @else
                                            <span class="badge bg-danger">
                                                <i class="fas fa-times me-1"></i>Invalid
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <small>{{ strlen($log->body) }} bytes</small>
                                    </td>
                                    <td>
                                        @if($log->response_time)
                                            <small>{{ number_format($log->response_time, 2) }}ms</small>
                                        @else
                                            <small class="text-muted">-</small>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-sm" 
                                                onclick="showLogDetails({{ $log->id }})" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $logs->withQueryString()->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-history fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada log request</h5>
                    <p class="text-muted">Log akan muncul setelah ada request ke endpoint ini.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Statistics -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Requests
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($postOnlyReceiver->total_received) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-download fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Success Requests
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($postOnlyReceiver->total_success) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Failed Requests
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($postOnlyReceiver->total_failed) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Success Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $postOnlyReceiver->success_rate }}%</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-percentage fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Log Details Modal -->
<div class="modal fade" id="logDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Log Request</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="logDetailsContent">
                    <div class="text-center">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function showLogDetails(logId) {
    $('#logDetailsModal').modal('show');
    
    fetch(`/api/post-only-receivers/logs/${logId}`)
        .then(response => response.json())
        .then(data => {
            let content = `
                <div class="row">
                    <div class="col-md-6">
                        <h6>Request Info</h6>
                        <table class="table table-sm">
                            <tr><td><strong>Waktu:</strong></td><td>${data.created_at}</td></tr>
                            <tr><td><strong>IP Address:</strong></td><td><code>${data.ip_address}</code></td></tr>
                            <tr><td><strong>Status Code:</strong></td><td><span class="badge bg-${data.status_code == 200 ? 'success' : 'danger'}">${data.status_code}</span></td></tr>
                            <tr><td><strong>Token Valid:</strong></td><td><span class="badge bg-${data.token_valid ? 'success' : 'danger'}">${data.token_valid ? 'Ya' : 'Tidak'}</span></td></tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6>Headers</h6>
                        <pre class="bg-light p-2 rounded"><code>${JSON.stringify(JSON.parse(data.headers), null, 2)}</code></pre>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <h6>Request Body</h6>
                        <pre class="bg-light p-2 rounded"><code>${JSON.stringify(JSON.parse(data.body), null, 2)}</code></pre>
                    </div>
                </div>
                ${data.response_body ? `
                <div class="row">
                    <div class="col-12">
                        <h6>Response Body</h6>
                        <pre class="bg-light p-2 rounded"><code>${JSON.stringify(JSON.parse(data.response_body), null, 2)}</code></pre>
                    </div>
                </div>
                ` : ''}
            `;
            
            document.getElementById('logDetailsContent').innerHTML = content;
        })
        .catch(error => {
            document.getElementById('logDetailsContent').innerHTML = 
                '<div class="alert alert-danger">Error loading log details</div>';
        });
}
</script>
@endsection 