@extends('layouts.app')

@section('title', 'Detail POST-Only Receiver')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-eye me-2"></i>Detail POST-Only Receiver
        </h1>
        <div>
            <a href="{{ route('post-only-receivers.edit', $postOnlyReceiver) }}" class="btn btn-warning btn-sm">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a href="{{ route('post-only-receivers.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Receiver Details -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>Informasi Receiver
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Nama:</label>
                                <div class="bg-light p-2 rounded">{{ $postOnlyReceiver->name }}</div>
                            </div>
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Endpoint URL:</label>
                                <div>
                                    <code class="bg-light p-2 rounded d-block">{{ url('/api/post/' . $postOnlyReceiver->endpoint) }}</code>
                                    <button class="btn btn-sm btn-outline-secondary mt-1" onclick="copyEndpointUrl()">
                                        <i class="fas fa-copy me-1"></i>Copy URL
                                    </button>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Target Table:</label>
                                <div><code class="bg-light p-2 rounded">{{ $postOnlyReceiver->target_table }}</code></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">API Client:</label>
                                <div>
                                    @if($postOnlyReceiver->apiClient)
                                        <span class="badge bg-info">{{ $postOnlyReceiver->apiClient->name }}</span>
                                    @else
                                        <span class="badge bg-secondary">Tidak Ada</span>
                                    @endif
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Token Required:</label>
                                <div>
                                    @if($postOnlyReceiver->require_token)
                                        <span class="badge bg-warning">
                                            <i class="fas fa-lock me-1"></i>Ya
                                        </span>
                                    @else
                                        <span class="badge bg-success">
                                            <i class="fas fa-unlock me-1"></i>Tidak
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Status:</label>
                                <div>
                                    @if($postOnlyReceiver->is_active)
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle me-1"></i>Aktif
                                        </span>
                                    @else
                                        <span class="badge bg-danger">
                                            <i class="fas fa-times-circle me-1"></i>Nonaktif
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($postOnlyReceiver->description)
                        <div class="mb-3">
                            <label class="font-weight-bold text-gray-700">Deskripsi:</label>
                            <div class="bg-light p-2 rounded">{{ $postOnlyReceiver->description }}</div>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Rate Limit:</label>
                                <div>{{ number_format($postOnlyReceiver->rate_limit) }} requests/jam</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Auto Create Table:</label>
                                <div>
                                    @if($postOnlyReceiver->auto_create_table)
                                        <span class="badge bg-success">Ya</span>
                                    @else
                                        <span class="badge bg-secondary">Tidak</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Dibuat:</label>
                                <div>{{ $postOnlyReceiver->created_at->format('d M Y H:i:s') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="font-weight-bold text-gray-700">Terakhir Diperbarui:</label>
                                <div>{{ $postOnlyReceiver->updated_at->format('d M Y H:i:s') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="fas fa-chart-bar me-2"></i>Statistik
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <h4 class="text-primary">{{ number_format($postOnlyReceiver->total_received) }}</h4>
                                <small class="text-muted">Total Diterima</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h4 class="text-success">{{ number_format($postOnlyReceiver->total_success) }}</h4>
                                <small class="text-muted">Berhasil</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h4 class="text-danger">{{ number_format($postOnlyReceiver->total_failed) }}</h4>
                                <small class="text-muted">Gagal</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h4 class="text-info">{{ $postOnlyReceiver->success_rate }}%</h4>
                                <small class="text-muted">Success Rate</small>
                            </div>
                        </div>
                    </div>
                    
                    @if($postOnlyReceiver->last_received_at)
                        <hr>
                        <div class="text-center">
                            <small class="text-muted">
                                Terakhir menerima data: {{ $postOnlyReceiver->last_received_at->format('d M Y H:i:s') }}
                                ({{ $postOnlyReceiver->last_received_at->diffForHumans() }})
                            </small>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recent Logs -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-history me-2"></i>Log Terbaru
                    </h6>
                    <a href="{{ route('post-only-receivers.logs', $postOnlyReceiver) }}" class="btn btn-sm btn-outline-info">
                        <i class="fas fa-list me-1"></i>Lihat Semua
                    </a>
                </div>
                <div class="card-body">
                    @if($recentLogs->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Waktu</th>
                                        <th>IP Address</th>
                                        <th>Status</th>
                                        <th>Token</th>
                                        <th>Validasi</th>
                                        <th>Tersimpan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentLogs as $log)
                                        <tr>
                                            <td>{{ $log->created_at->format('d/m H:i') }}</td>
                                            <td>{{ $log->ip_address }}</td>
                                            <td>
                                                @if($log->status_code == 200)
                                                    <span class="badge bg-success">{{ $log->status_code }}</span>
                                                @elseif($log->status_code >= 400)
                                                    <span class="badge bg-danger">{{ $log->status_code }}</span>
                                                @else
                                                    <span class="badge bg-warning">{{ $log->status_code }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->token_valid)
                                                    <i class="fas fa-check text-success"></i>
                                                @else
                                                    <i class="fas fa-times text-danger"></i>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->validation_success)
                                                    <i class="fas fa-check text-success"></i>
                                                @else
                                                    <i class="fas fa-times text-danger"></i>
                                                @endif
                                            </td>
                                            <td>
                                                @if($log->saved_to_table)
                                                    <i class="fas fa-check text-success"></i>
                                                @else
                                                    <i class="fas fa-times text-danger"></i>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="fas fa-history fa-2x text-muted mb-2"></i>
                            <p class="text-muted">Belum ada log aktivitas</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Test Endpoint -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-flask me-2"></i>Test Endpoint
                    </h6>
                </div>
                <div class="card-body">
                    <button class="btn btn-warning btn-block" onclick="testEndpoint()">
                        <i class="fas fa-play me-2"></i>Test POST Request
                    </button>
                    <small class="form-text text-muted mt-2">
                        Test endpoint dengan sample data
                    </small>
                </div>
            </div>

            <!-- API Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-code me-2"></i>API Information
                    </h6>
                </div>
                <div class="card-body">
                    <h6>Endpoint:</h6>
                    <pre class="bg-light p-2 rounded small">POST {{ url('/api/post/' . $postOnlyReceiver->endpoint) }}</pre>
                    
                    @if($postOnlyReceiver->require_token)
                        <h6>Headers:</h6>
                        <pre class="bg-light p-2 rounded small">Authorization: Bearer YOUR_TOKEN
Content-Type: application/json</pre>
                    @endif
                    
                    @if($postOnlyReceiver->sample_data)
                        <h6>Sample Data:</h6>
                        <pre class="bg-light p-2 rounded small">{{ json_encode($postOnlyReceiver->sample_data, JSON_PRETTY_PRINT) }}</pre>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-secondary">
                        <i class="fas fa-tools me-2"></i>Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('post-only-receivers.edit', $postOnlyReceiver) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit me-2"></i>Edit Receiver
                        </a>
                        <a href="{{ route('post-only-receivers.logs', $postOnlyReceiver) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-history me-2"></i>Lihat Logs
                        </a>
                        @if($postOnlyReceiver->apiClient)
                            <a href="{{ route('api-clients.show', $postOnlyReceiver->apiClient) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-user-cog me-2"></i>Lihat API Client
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyEndpointUrl() {
    const url = '{{ addslashes(url("/api/post/" . $postOnlyReceiver->endpoint)) }}';
    navigator.clipboard.writeText(url).then(function() {
        alert('URL endpoint berhasil disalin!');
    }).catch(function(error) {
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = url;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        alert('URL endpoint berhasil disalin!');
    });
}

function testEndpoint() {
    const endpointUrl = '{{ addslashes(url("/api/post/" . $postOnlyReceiver->endpoint)) }}';
    const requireToken = {{ $postOnlyReceiver->require_token ? 'true' : 'false' }};
    
    @if($postOnlyReceiver->sample_data)
        const testData = @json($postOnlyReceiver->sample_data);
    @else
        const testData = {
            "test": true,
            "message": "Test data from dashboard",
            "timestamp": new Date().toISOString()
        };
    @endif
    
    if (requireToken) {
        const token = prompt('Masukkan Bearer Token:');
        if (!token) {
            alert('Token diperlukan untuk testing!');
            return;
        }
        
        fetch(endpointUrl, {
            method: 'POST',
            headers: {
                'Authorization': 'Bearer ' + token,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(testData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Test berhasil! Data telah diterima.');
                location.reload();
            } else {
                alert('Test gagal: ' + (data.error || 'Unknown error'));
            }
        })
        .catch(error => {
            alert('Network error: ' + error.message);
        });
    } else {
        fetch(endpointUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(testData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Test berhasil! Data telah diterima.');
                location.reload();
            } else {
                alert('Test gagal: ' + (data.error || 'Unknown error'));
            }
        })
        .catch(error => {
            alert('Network error: ' + error.message);
        });
    }
}
</script>
@endsection 