@extends('layouts.app')

@section('title', 'Edit Profil')

@section('breadcrumb')
    <li class="breadcrumb-item active">Edit Profil</li>
@endsection

@section('content')
<div class="modern-card">
    <div class="modern-card-header">
        <h5 class="modern-card-title">Edit Profil Admin</h5>
        <p class="text-muted mb-0">Perbarui nama, email, dan password akun Anda.</p>
    </div>
    <div class="modern-card-body">
        <form method="POST" action="{{ route('profile.update') }}" id="profileEditForm" novalidate>
            @csrf
            @method('PUT')

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Nama</label>
                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $user->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $user->email) }}" required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Password Baru</label>
                    <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="Kosongkan jika tidak ingin mengubah">
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Konfirmasi Password</label>
                    <input type="password" name="password_confirmation" class="form-control" placeholder="Ulangi password baru">
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    <button type="submit" class="btn btn-primary me-2" name="action" value="save_now" data-no-loading data-no-ripple>
                        <i class="fas fa-save me-1"></i> SAVE NOW
                    </button>
                    <button type="submit" class="btn btn-info" name="action" value="save_and_back" data-no-loading data-no-ripple>
                        <i class="fas fa-check me-1"></i> SAVE & BACK
                    </button>
                </div>
                <a href="{{ route('dashboard.index') }}" class="btn btn-light">Cancel</a>
            </div>
        </form>
    </div>
    </div>
@endsection


