@extends('layouts.app')

@section('title', 'Create User')

@section('breadcrumb')
	<li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">Dashboard</a></li>
	<li class="breadcrumb-item active">Create User</li>
@endsection

@section('content')
<div class="modern-card">
	<div class="modern-card-header">
		<h5 class="modern-card-title">Buat User</h5>
		<p class="text-muted mb-0">Tambahkan pengguna admin baru ke sistem.</p>
	</div>
	<div class="modern-card-body">
		@if(session('success'))
			<div class="alert alert-success alert-dismissible fade show" role="alert">
				{{ session('success') }}
				<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>
		@endif
		@if(session('error'))
			<div class="alert alert-danger alert-dismissible fade show" role="alert">
				{{ session('error') }}
				<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>
		@endif
		@if($errors->any())
			<div class="alert alert-danger alert-dismissible fade show" role="alert">
				<strong>Periksa kembali isian berikut:</strong>
				<ul class="mb-0 mt-2">
					@foreach($errors->all() as $error)
						<li>{{ $error }}</li>
					@endforeach
				</ul>
				<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>
		@endif

		<form method="POST" action="{{ route('users.store') }}" id="userCreateForm" novalidate>
			@csrf

			<div class="row g-3">
				<div class="col-md-6">
					<label for="name" class="form-label">Nama</label>
					<input id="name" type="text" name="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" required autofocus>
					@error('name')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<div class="col-md-6">
					<label for="email" class="form-label">Email</label>
					<input id="email" type="email" name="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" required>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<div class="col-md-6">
					<label for="password" class="form-label">Password</label>
					<input id="password" type="password" name="password" class="form-control @error('password') is-invalid @enderror" required>
					@error('password')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<div class="col-md-6">
					<label for="password_confirmation" class="form-label">Konfirmasi Password</label>
					<input id="password_confirmation" type="password" name="password_confirmation" class="form-control" required>
				</div>
			</div>

			<div class="form-group mt-4">
				<div class="row">
					<div class="col-12 mb-3">
						<button type="submit" class="btn btn-primary btn-lg me-2" id="altSubmitBtn" data-loading-text="SUBMITTING...">
							<i class="fas fa-rocket me-2"></i>SUBMIT NOW
						</button>
					</div>
					<div class="col-12 mb-3">
						<a href="{{ route('dashboard.index') }}" class="btn btn-secondary me-2">
							<i class="fas fa-times me-2"></i>Cancel
						</a>
					</div>
				</div>
			</div>
		</form>

		<script>
		document.addEventListener('DOMContentLoaded', function() {
			const form = document.getElementById('userCreateForm');
			const altBtn = document.getElementById('altSubmitBtn');
			if (altBtn && form) {
				altBtn.addEventListener('click', function(e) {
					// Basic validation like API Clients page
					const name = document.getElementById('name');
					const email = document.getElementById('email');
					const password = document.getElementById('password');
					const confirm = document.getElementById('password_confirmation');

					if (!name.value.trim()) { name.focus(); return; }
					if (!email.value.trim()) { email.focus(); return; }
					if (!password.value) { password.focus(); return; }
					if (!confirm.value) { confirm.focus(); return; }
					if (password.value !== confirm.value) { alert('Konfirmasi password tidak sesuai.'); confirm.focus(); return; }

					// Show loading state
					if (typeof window.showButtonLoading === 'function') {
						window.showButtonLoading(altBtn);
					} else {
						altBtn.disabled = true;
						altBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>SUBMITTING...';
					}

					form.submit();
				});
			}

			// On regular form submit, ensure button shows loading
			form && form.addEventListener('submit', function(e){
				const submitter = e.submitter || altBtn;
				if (submitter && typeof window.showButtonLoading === 'function') {
					window.showButtonLoading(submitter);
				}
			});
		});
		</script>
	</div>
</div>
@endsection


