@extends('layouts.app')

@section('title', 'Welcome to API Management System')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <!-- Welcome Header -->
            <div class="card border-primary mb-4">
                <div class="card-header bg-primary text-white">
                    <h3 class="mb-0">
                        <i class="fas fa-rocket me-2"></i>
                        Welcome to API Management System
                    </h3>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>No Authentication Required!</strong> This application is designed for easy access. 
                        All features are available without login.
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <h5><i class="fas fa-cogs me-2"></i>Quick Start</h5>
                            <p>Get started with API management right away:</p>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i>Create API Receivers</li>
                                <li><i class="fas fa-check text-success me-2"></i>Manage API Sources</li>
                                <li><i class="fas fa-check text-success me-2"></i>Configure API Targets</li>
                                <li><i class="fas fa-check text-success me-2"></i>Monitor API Activity</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h5><i class="fas fa-star me-2"></i>New Features</h5>
                            <p>Latest enhancements:</p>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-new text-primary me-2"></i>GET-Only API Receivers</li>
                                <li><i class="fas fa-new text-primary me-2"></i>Client Token Synchronization</li>
                                <li><i class="fas fa-new text-primary me-2"></i>Enhanced Validation</li>
                                <li><i class="fas fa-new text-primary me-2"></i>Multi-format Responses</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Navigation -->
            <div class="row">
                <div class="col-md-2 mb-3">
                    <div class="card h-100 border-success">
                        <div class="card-body text-center">
                            <i class="fas fa-download fa-3x text-success mb-3"></i>
                            <h5>API Receivers</h5>
                            <p class="text-muted">Receive data from external APIs</p>
                            <a href="{{ route('api-receivers.index') }}" class="btn btn-success">
                                <i class="fas fa-arrow-right me-2"></i>Manage
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-2 mb-3">
                    <div class="card h-100 border-info">
                        <div class="card-body text-center">
                            <i class="fas fa-upload fa-3x text-info mb-3"></i>
                            <h5>API Sources</h5>
                            <p class="text-muted">Fetch data from external sources</p>
                            <a href="{{ route('api-sources.index') }}" class="btn btn-info">
                                <i class="fas fa-arrow-right me-2"></i>Manage
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-2 mb-3">
                    <div class="card h-100 border-warning">
                        <div class="card-body text-center">
                            <i class="fas fa-paper-plane fa-3x text-warning mb-3"></i>
                            <h5>API Targets</h5>
                            <p class="text-muted">Send data to external systems</p>
                            <a href="{{ route('api-targets.index') }}" class="btn btn-warning">
                                <i class="fas fa-arrow-right me-2"></i>Manage
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-2 mb-3">
                    <div class="card h-100 border-secondary">
                        <div class="card-body text-center">
                            <i class="fas fa-chart-line fa-3x text-secondary mb-3"></i>
                            <h5>Monitoring</h5>
                            <p class="text-muted">Track API performance</p>
                            <a href="{{ route('monitoring.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-right me-2"></i>View
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- System Status -->
            <div class="card border-dark">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-server me-2"></i>
                        System Status
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-circle text-success me-2"></i>
                                <span>API System: <strong>Online</strong></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-circle text-success me-2"></i>
                                <span>Database: <strong>Connected</strong></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-circle text-success me-2"></i>
                                <span>Authentication: <strong>Disabled</strong></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Show welcome message
    @if(session('info'))
        Swal.fire({
            icon: 'info',
            title: 'Information',
            text: '{{ session('info') }}',
            confirmButtonText: 'Got it!'
        });
    @endif
    
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Welcome!',
            text: '{{ session('success') }}',
            confirmButtonText: 'Let\'s Go!'
        });
    @endif
});
</script>
@endsection
