<?php
// Execute SQL script to create POST-Only Receivers tables
echo "<h2>🗄️ Creating POST-Only Receivers Database Tables</h2>";

try {
    // Database configuration
    $host = 'localhost';
    $database = 'copg1493_api';
    $username = 'copg1493';
    $password = 'wPD6DDSegDHd56'; // Use the actual password from your hosting
    
    echo "<h3>Step 1: Database Connection</h3>";
    echo "<p><strong>Host:</strong> $host</p>";
    echo "<p><strong>Database:</strong> $database</p>";
    echo "<p><strong>Username:</strong> $username</p>";
    
    // Create PDO connection
    $dsn = "mysql:host=$host;dbname=$database;charset=utf8mb4";
    $pdo = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    
    echo "<p style='color: green;'>✅ Database connection successful</p>";
    
    // Step 2: Create post_only_receivers table
    echo "<h3>Step 2: Creating post_only_receivers Table</h3>";
    
    $createPostOnlyReceiversSQL = "
    CREATE TABLE IF NOT EXISTS `post_only_receivers` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL COMMENT 'Nama receiver yang mudah dibaca',
        `endpoint` varchar(255) NOT NULL COMMENT 'URL path endpoint (contoh: webhook-data)',
        `target_table` varchar(255) NOT NULL COMMENT 'Nama tabel tujuan penyimpanan data',
        `description` text DEFAULT NULL COMMENT 'Deskripsi receiver',
        `api_client_id` bigint(20) unsigned DEFAULT NULL COMMENT 'ID API client yang terkait',
        `require_token` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Apakah memerlukan token untuk akses',
        `field_mapping` json DEFAULT NULL COMMENT 'Mapping field dari request ke database',
        `validation_rules` json DEFAULT NULL COMMENT 'Aturan validasi untuk data POST',
        `auto_create_table` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Auto create table dari sample data',
        `allowed_ips` json DEFAULT NULL COMMENT 'IP whitelist (JSON array)',
        `rate_limit` int(11) NOT NULL DEFAULT 1000 COMMENT 'Requests per hour limit',
        `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Status aktif receiver',
        `last_received_at` timestamp NULL DEFAULT NULL COMMENT 'Waktu terakhir menerima data',
        `total_received` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data yang diterima',
        `total_success` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data berhasil diproses',
        `total_failed` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data gagal diproses',
        `sample_data` json DEFAULT NULL COMMENT 'Contoh data untuk dokumentasi',
        `created_at` timestamp NULL DEFAULT NULL,
        `updated_at` timestamp NULL DEFAULT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `post_only_receivers_endpoint_unique` (`endpoint`),
        KEY `post_only_receivers_endpoint_is_active_index` (`endpoint`,`is_active`),
        KEY `post_only_receivers_api_client_id_index` (`api_client_id`),
        KEY `post_only_receivers_target_table_index` (`target_table`),
        KEY `post_only_receivers_require_token_index` (`require_token`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $pdo->exec($createPostOnlyReceiversSQL);
    echo "<p style='color: green;'>✅ post_only_receivers table created successfully</p>";
    
    // Step 3: Create post_only_receive_logs table
    echo "<h3>Step 3: Creating post_only_receive_logs Table</h3>";
    
    $createPostOnlyReceiveLogsSQL = "
    CREATE TABLE IF NOT EXISTS `post_only_receive_logs` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `receiver_id` bigint(20) unsigned NOT NULL,
        `ip_address` varchar(45) DEFAULT NULL,
        `user_agent` text DEFAULT NULL,
        `headers` json DEFAULT NULL,
        `body` longtext DEFAULT NULL,
        `status_code` int(11) NOT NULL,
        `response_message` text DEFAULT NULL,
        `response_time` decimal(8,3) DEFAULT NULL COMMENT 'Response time in seconds',
        `payload_size` int(11) DEFAULT NULL COMMENT 'Payload size in bytes',
        `token_valid` tinyint(1) NOT NULL DEFAULT 0,
        `validation_success` tinyint(1) NOT NULL DEFAULT 0,
        `validation_errors` json DEFAULT NULL,
        `saved_to_table` tinyint(1) NOT NULL DEFAULT 0,
        `save_error` text DEFAULT NULL,
        `client_id` bigint(20) unsigned DEFAULT NULL,
        `token_id` bigint(20) unsigned DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT NULL,
        `updated_at` timestamp NULL DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `post_only_receive_logs_receiver_id_created_at_index` (`receiver_id`,`created_at`),
        KEY `post_only_receive_logs_status_code_index` (`status_code`),
        KEY `post_only_receive_logs_token_valid_index` (`token_valid`),
        KEY `post_only_receive_logs_validation_success_index` (`validation_success`),
        KEY `post_only_receive_logs_saved_to_table_index` (`saved_to_table`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $pdo->exec($createPostOnlyReceiveLogsSQL);
    echo "<p style='color: green;'>✅ post_only_receive_logs table created successfully</p>";
    
    // Step 4: Insert sample data
    echo "<h3>Step 4: Inserting Sample Data</h3>";
    
    $insertSampleDataSQL = "
    INSERT IGNORE INTO `post_only_receivers` (`name`, `endpoint`, `target_table`, `description`, `require_token`, `is_active`, `created_at`, `updated_at`) VALUES
    ('Sample Webhook Receiver', 'sample-webhook', 'webhook_data', 'Sample receiver for testing webhook functionality', 0, 1, NOW(), NOW()),
    ('API Data Receiver', 'api-data-receiver', 'api_received_data', 'Receiver for general API data posting', 1, 1, NOW(), NOW())";
    
    $pdo->exec($insertSampleDataSQL);
    echo "<p style='color: green;'>✅ Sample data inserted successfully</p>";
    
    // Step 5: Verify tables
    echo "<h3>Step 5: Verifying Tables</h3>";
    
    // Check post_only_receivers
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM post_only_receivers");
    $result = $stmt->fetch();
    echo "<p style='color: green;'>✅ post_only_receivers table: {$result['count']} records</p>";
    
    // Show sample records
    $stmt = $pdo->query("SELECT id, name, endpoint, target_table FROM post_only_receivers LIMIT 5");
    $receivers = $stmt->fetchAll();
    
    if (!empty($receivers)) {
        echo "<p><strong>Sample receivers:</strong></p>";
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Name</th><th>Endpoint</th><th>Target Table</th></tr>";
        foreach ($receivers as $receiver) {
            echo "<tr>";
            echo "<td>{$receiver['id']}</td>";
            echo "<td>{$receiver['name']}</td>";
            echo "<td>{$receiver['endpoint']}</td>";
            echo "<td>{$receiver['target_table']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Check post_only_receive_logs
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM post_only_receive_logs");
    $result = $stmt->fetch();
    echo "<p style='color: green;'>✅ post_only_receive_logs table: {$result['count']} records</p>";
    
    // Step 6: Show table structures
    echo "<h3>Step 6: Table Structures</h3>";
    
    echo "<p><strong>post_only_receivers structure:</strong></p>";
    $stmt = $pdo->query("DESCRIBE post_only_receivers");
    $columns = $stmt->fetchAll();
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>{$column['Field']}</td>";
        echo "<td>{$column['Type']}</td>";
        echo "<td>{$column['Null']}</td>";
        echo "<td>{$column['Key']}</td>";
        echo "<td>{$column['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<hr>";
    echo "<h3 style='color: blue;'>🎯 Success!</h3>";
    echo "<p>All tables have been created successfully in database: <strong>$database</strong></p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database Error: " . $e->getMessage() . "</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>Try accessing: <a href='/post-only-receivers'>POST-Only Receivers</a></li>";
echo "<li>The application should now work without table errors</li>";
echo "<li>You can create new receivers and test the functionality</li>";
echo "</ol>";

echo "<p><strong>Database setup completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 