<?php

echo "Fetching data from https://logam-mulia-api.vercel.app/\n";

// Fetch data from API
$url = 'https://logam-mulia-api.vercel.app/';
$context = stream_context_create([
    'http' => [
        'timeout' => 30,
        'user_agent' => 'API8-Import-Script/1.0'
    ]
]);

$response = file_get_contents($url, false, $context);

if ($response !== false) {
    $data = json_decode($response, true);
    
    if ($data) {
        echo "Successfully fetched data from API\n";
        echo "Number of records: " . (is_array($data) ? count($data) : 1) . "\n";
        
        // Display sample data
        if (is_array($data) && !empty($data)) {
            echo "\nSample data structure:\n";
            $sample = $data[0];
            foreach ($sample as $key => $value) {
                echo "  $key: " . (is_string($value) ? $value : json_encode($value)) . "\n";
            }
        } else {
            echo "\nData structure:\n";
            foreach ($data as $key => $value) {
                echo "  $key: " . (is_string($value) ? $value : json_encode($value)) . "\n";
            }
        }
        
        // Save to file for manual import
        $filename = 'imported_data_' . date('Y-m-d_H-i-s') . '.json';
        file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
        echo "\nData saved to: $filename\n";
        
    } else {
        echo "Failed to decode JSON response\n";
        echo "Raw response: " . substr($response, 0, 500) . "...\n";
    }
} else {
    echo "Failed to fetch data from API\n";
    $error = error_get_last();
    if ($error) {
        echo "Error: " . $error['message'] . "\n";
    }
}

echo "\nImport process completed.\n"; 