<?php
/**
 * Simple Test untuk GET Request Customer Data
 * 
 * Request: {"data": "customer"}
 * Response: {"sukses": true, "datas": [...]}
 */

// Konfigurasi
$url = 'https://your-domain.com/api/in/test-receiver'; // Ganti dengan URL Anda

// Test case
$body = [
    'data' => 'customer'
];

echo "🚀 Testing GET Request untuk Customer Data\n";
echo "URL: {$url}\n";
echo "Request Body: " . json_encode($body, JSON_PRETTY_PRINT) . "\n\n";

// Lakukan request
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

// Tampilkan hasil
echo "📡 HTTP Code: {$httpCode}\n";

if ($error) {
    echo "❌ Error: {$error}\n";
} else {
    echo "✅ Response:\n";
    $responseData = json_decode($response, true);
    if ($responseData) {
        echo json_encode($responseData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        
        // Tampilkan data customer jika sukses
        if (isset($responseData['sukses']) && $responseData['sukses']) {
            echo "\n\n📋 Data Customer:\n";
            if (isset($responseData['datas']) && is_array($responseData['datas'])) {
                foreach ($responseData['datas'] as $index => $customer) {
                    echo ($index + 1) . ". {$customer['nama']} - {$customer['Alamat']} ({$customer['Gender']})\n";
                }
            } else {
                echo "Tidak ada data customer\n";
            }
        }
    } else {
        echo $response;
    }
}

echo "\n\n";

// Contoh curl command
echo "📋 Curl Command:\n";
echo "curl -X GET '{$url}' \\\n";
echo "  -H 'Content-Type: application/json' \\\n";
echo "  -H 'Accept: application/json' \\\n";
echo "  -d '" . json_encode($body) . "'\n";

echo "\n";

// Contoh JavaScript
echo "📋 JavaScript Example:\n";
echo "fetch('{$url}', {\n";
echo "  method: 'GET',\n";
echo "  headers: {\n";
echo "    'Content-Type': 'application/json',\n";
echo "    'Accept': 'application/json'\n";
echo "  },\n";
echo "  body: JSON.stringify({\n";
echo "    data: 'customer'\n";
echo "  })\n";
echo "})\n";
echo ".then(response => response.json())\n";
echo ".then(data => {\n";
echo "  if (data.sukses) {\n";
echo "    console.log('Customer data:', data.datas);\n";
echo "    data.datas.forEach(customer => {\n";
echo "      console.log(customer.nama + ' - ' + customer.Alamat);\n";
echo "    });\n";
echo "  }\n";
echo "});\n";
?>
