

<?php $__env->startSection('title', 'API Client Details'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('api-clients.index')); ?>">API Clients</a>
    </li>
    <li class="breadcrumb-item active"><?php echo e($apiClient->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Alert Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-user-cog me-2"></i><?php echo e($apiClient->name); ?>

                </h1>
                <div>
                    <a href="<?php echo e(route('api-clients.edit', $apiClient)); ?>" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <a href="<?php echo e(route('api-clients.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Client Information -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-info-circle me-2"></i>Client Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Client Name:</label>
                                <p class="text-gray-800"><?php echo e($apiClient->name); ?></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Status:</label>
                                <p>
                                    <?php if($apiClient->is_active): ?>
                                        <span class="badge bg-success">
                                            <i class="fas fa-check me-1"></i>Active
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">
                                            <i class="fas fa-times me-1"></i>Inactive
                                        </span>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>

                    <?php if($apiClient->description): ?>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description:</label>
                            <p class="text-gray-800"><?php echo e($apiClient->description); ?></p>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Rate Limit:</label>
                                <p class="text-gray-800">
                                    <?php echo e($apiClient->rate_limit ?? 'Unlimited'); ?> 
                                    <?php if($apiClient->rate_limit): ?>
                                        requests/minute
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Last Used:</label>
                                <p class="text-gray-800">
                                    <?php echo e($apiClient->last_used_at ? $apiClient->last_used_at->format('M d, Y H:i:s') : 'Never'); ?>

                                </p>
                            </div>
                        </div>
                    </div>

                    <?php if($apiClient->allowed_ips): ?>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Allowed IP Addresses:</label>
                            <div>
                                <?php $__currentLoopData = $apiClient->allowed_ips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-info me-1"><?php echo e($ip); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Created:</label>
                                <p class="text-gray-800"><?php echo e($apiClient->created_at->format('M d, Y H:i:s')); ?></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Updated:</label>
                                <p class="text-gray-800"><?php echo e($apiClient->updated_at->format('M d, Y H:i:s')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- API Credentials -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-key me-2"></i>API Credentials
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Client ID:</label>
                        <div class="input-group">
                            <input type="text" class="form-control font-monospace" value="<?php echo e($apiClient->client_id); ?>" 
                                   id="clientId" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('clientId')">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Client Secret:</label>
                        <div class="input-group">
                            <input type="password" class="form-control font-monospace" value="<?php echo e($apiClient->client_secret); ?>" 
                                   id="clientSecret" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="toggleSecret()">
                                <i class="fas fa-eye" id="secretIcon"></i>
                            </button>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('clientSecret')">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                        <small class="text-danger">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            Keep this secret secure and never share it publicly.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Usage Statistics -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-chart-bar me-2"></i>Usage Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Total Tokens:</label>
                        <p class="text-gray-800"><?php echo e($apiClient->tokens()->count()); ?></p>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Active Tokens:</label>
                        <p class="text-gray-800"><?php echo e($apiClient->tokens()->where('is_revoked', false)->count()); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(element.value);
    
    // Show feedback
    const button = event.target.closest('button');
    const originalIcon = button.innerHTML;
    button.innerHTML = '<i class="fas fa-check text-success"></i>';
    
    setTimeout(() => {
        button.innerHTML = originalIcon;
    }, 2000);
}

function toggleSecret() {
    const secretField = document.getElementById('clientSecret');
    const icon = document.getElementById('secretIcon');
    
    if (secretField.type === 'password') {
        secretField.type = 'text';
        icon.className = 'fas fa-eye-slash';
    } else {
        secretField.type = 'password';
        icon.className = 'fas fa-eye';
    }
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-clients/show.blade.php ENDPATH**/ ?>