<?php $__env->startSection('title', 'Create API Client'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('api-clients.index')); ?>">API Clients</a>
    </li>
    <li class="breadcrumb-item active">Create</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Alert Messages -->
    <div id="alert-container">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0 mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-plus me-2"></i>Create API Client
                </h1>
                <a href="<?php echo e(route('api-clients.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to List
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-user-cog me-2"></i>API Client Information
                    </h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('api-clients.store')); ?>" method="POST" id="createForm" novalidate>
                        <?php echo csrf_field(); ?>
                        
                        <!-- Debug info -->
                        <?php if(config('app.debug')): ?>
                            <div class="alert alert-info">
                                <small>
                                    <strong>Debug Info:</strong><br>
                                    Action: <?php echo e(route('api-clients.store')); ?><br>
                                    CSRF Token: <?php echo e(csrf_token()); ?><br>
                                    Session ID: <?php echo e(session()->getId()); ?><br>
                                </small>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Basic Information -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label">Client Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="name" name="name" value="<?php echo e(old('name')); ?>" required
                                           placeholder="Enter a descriptive name for this API client">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" name="description" rows="3" 
                                      placeholder="Brief description of this API client and its purpose"><?php echo e(old('description')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Configuration -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-cog me-2"></i>Client Configuration
                        </h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="rate_limit" class="form-label">Rate Limit (requests per minute)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['rate_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="rate_limit" name="rate_limit" value="<?php echo e(old('rate_limit', 100)); ?>" 
                                           min="1" placeholder="100">
                                    <small class="form-text text-muted">Maximum number of requests per minute allowed for this client</small>
                                    <?php $__errorArgs = ['rate_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                                               value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">
                                            Active Client
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">Inactive clients cannot make API requests</small>
                                </div>
                            </div>
                        </div>

                        <!-- Security -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-shield-alt me-2"></i>Security Settings
                        </h5>

                        <div class="form-group mb-3">
                            <label for="allowed_ips" class="form-label">Allowed IP Addresses</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['allowed_ips'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="allowed_ips" name="allowed_ips" value="<?php echo e(old('allowed_ips')); ?>" 
                                   placeholder="192.168.1.1, 10.0.0.1, 203.0.113.0/24">
                            <small class="form-text text-muted">
                                Comma-separated list of IP addresses or CIDR blocks. Leave empty to allow all IPs.
                            </small>
                            <?php $__errorArgs = ['allowed_ips'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Generated Credentials Info -->
                        <hr class="my-4">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Note:</strong> Client ID and Client Secret will be automatically generated when you create this client. 
                            Make sure to save them securely as the Client Secret will only be displayed once.
                        </div>

                        <!-- Form Actions -->
                        <div class="form-group mt-4">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-primary btn-lg me-2" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>SUBMIT NOW
                                    </button>
                                </div>
                                <div class="col-12 mb-3">
                                    <button type="submit" class="btn btn-info me-2" name="action" value="save_and_continue" id="simpleSubmitBtn">
                                        <i class="fas fa-eye me-2"></i>SAVE & VIEW CREDENTIALS
                                    </button>
                                    <a href="<?php echo e(route('api-clients.index')); ?>" class="btn btn-secondary me-2">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Help Card -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-question-circle me-2"></i>Help & Information
                    </h6>
                </div>
                <div class="card-body">
                    <h6><i class="fas fa-user me-2"></i>Client Name</h6>
                    <p class="small text-muted mb-3">
                        A descriptive name to identify this API client. Choose something meaningful like "Mobile App v2" or "Partner Integration".
                    </p>

                    <h6><i class="fas fa-tachometer-alt me-2"></i>Rate Limiting</h6>
                    <p class="small text-muted mb-3">
                        Controls how many API requests this client can make per minute. Higher limits for trusted clients, lower for public APIs.
                    </p>

                    <h6><i class="fas fa-network-wired me-2"></i>IP Restrictions</h6>
                    <p class="small text-muted mb-3">
                        Restrict API access to specific IP addresses or networks for enhanced security. Supports both individual IPs and CIDR notation.
                    </p>

                    <h6><i class="fas fa-key me-2"></i>Authentication</h6>
                    <p class="small text-muted mb-0">
                        Each client receives a unique Client ID and Client Secret for API authentication. The secret is only shown once, so save it securely.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Show alert function
function showAlert(message, type = 'info') {
    const alertContainer = document.getElementById('alert-container');
    if (!alertContainer) return;
    
    const alert = document.createElement('div');
    alert.className = `alert alert-${type} alert-dismissible fade show`;
    alert.innerHTML = `
        <strong>${type === 'success' ? 'Success!' : type === 'danger' ? 'Error!' : 'Info:'}</strong> ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    alertContainer.appendChild(alert);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alert.parentNode) {
            alert.remove();
        }
    }, 5000);
}

// Alternative submit function - using regular form submission
function submitFormDirectly() {
    console.log('Alternative submit triggered');
    
    const form = document.getElementById('createForm');
    const saveBtn = document.getElementById('saveBtn');
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    
    if (!form) return;
    
    // Validate required fields manually
    const name = document.getElementById('name').value.trim();
    
    if (!name) {
        showAlert('Please enter a client name!', 'danger');
        document.getElementById('name').focus();
        return;
    }
    
    // Validate IP addresses if provided
    const allowedIps = document.getElementById('allowed_ips').value.trim();
    if (allowedIps) {
        const ips = allowedIps.split(',').map(ip => ip.trim());
        const ipPattern = /^(\d{1,3}\.){3}\d{1,3}(\/\d{1,2})?$/;
        
        for (let ip of ips) {
            if (!ipPattern.test(ip)) {
                showAlert('Invalid IP address format: ' + ip, 'danger');
                document.getElementById('allowed_ips').focus();
                return;
            }
        }
    }
    
    // Show loading state
    if (altSubmitBtn) {
        altSubmitBtn.disabled = true;
        altSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
    }
    if (saveBtn) {
        saveBtn.disabled = true;
    }
    
    // Add a hidden input for action
    let actionInput = form.querySelector('input[name="alt_action"]');
    if (!actionInput) {
        actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'action';
        actionInput.value = 'save_and_return';
        form.appendChild(actionInput);
    }
    
    // Submit the form normally
    form.submit();
}

document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, setting up event listeners...');
    
    // Form validation
    const form = document.getElementById('createForm');
    const saveBtn = document.getElementById('saveBtn');
    const simpleSubmitBtn = document.getElementById('simpleSubmitBtn');
    
    // Alternative submit button
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    if (altSubmitBtn) {
        altSubmitBtn.addEventListener('click', submitFormDirectly);
    }
    
    // Form submit handler
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('Form submitted via primary button');
            
            // Get the clicked button
            const clickedButton = e.submitter;
            
            // Disable buttons during submission
            if (saveBtn) {
                saveBtn.disabled = true;
                saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SAVING...';
            }
            if (simpleSubmitBtn && clickedButton === simpleSubmitBtn) {
                simpleSubmitBtn.disabled = true;
                simpleSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>CREATING & PREPARING CREDENTIALS...';
            }
            
            // Basic validation
            const name = document.getElementById('name').value.trim();
            
            if (!name) {
                e.preventDefault();
                alert('Please enter a client name.');
                document.getElementById('name').focus();
                // Reset button state
                if (saveBtn) {
                    saveBtn.disabled = false;
                    saveBtn.innerHTML = '<i class="fas fa-save me-2"></i>SAVE API CLIENT';
                }
                if (simpleSubmitBtn) {
                    simpleSubmitBtn.disabled = false;
                    simpleSubmitBtn.innerHTML = '<i class="fas fa-eye me-2"></i>SAVE & VIEW CREDENTIALS';
                }
                return false;
            }
            
            // Validate IP addresses if provided
            const allowedIps = document.getElementById('allowed_ips').value.trim();
            if (allowedIps) {
                const ips = allowedIps.split(',').map(ip => ip.trim());
                const ipPattern = /^(\d{1,3}\.){3}\d{1,3}(\/\d{1,2})?$/;
                
                for (let ip of ips) {
                    if (!ipPattern.test(ip)) {
                        e.preventDefault();
                        alert('Invalid IP address format: ' + ip);
                        document.getElementById('allowed_ips').focus();
                        // Reset button state
                        if (saveBtn) {
                            saveBtn.disabled = false;
                            saveBtn.innerHTML = '<i class="fas fa-save me-2"></i>SAVE API CLIENT';
                        }
                        if (simpleSubmitBtn) {
                            simpleSubmitBtn.disabled = false;
                            simpleSubmitBtn.innerHTML = '<i class="fas fa-eye me-2"></i>SAVE & VIEW CREDENTIALS';
                        }
                        return false;
                    }
                }
            }
        });
    }
    
    // Monitor form state
    console.log('Form initialized:', form);
    console.log('Form elements:', form.elements);
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-clients/create.blade.php ENDPATH**/ ?>