

<?php $__env->startSection('title', 'PDF Preview - ' . $apiReceiver->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-eye me-2"></i>PDF Preview - <?php echo e($apiReceiver->name); ?>

        </h1>
        <div>
            <a href="<?php echo e(route('api-receivers.export-pdf', $apiReceiver)); ?>" class="btn btn-success">
                <i class="fas fa-download me-2"></i>Download PDF
            </a>
            <a href="<?php echo e(route('api-receivers.index')); ?>" class="btn btn-secondary ms-2">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>
    </div>

    <!-- PDF Preview Container -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-file-pdf me-2"></i>Documentation Preview
            </h6>
        </div>
        <div class="card-body">
            <!-- Basic Information -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-info-circle me-2"></i>Basic Information
                    </h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th width="200" class="bg-light">Name</th>
                                <td><?php echo e($apiReceiver->name); ?></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Description</th>
                                <td><?php echo e($apiReceiver->description ?? 'No description provided'); ?></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Endpoint URL</th>
                                <td><code><?php echo e(url('/api/in/' . ltrim($apiReceiver->endpoint, '/'))); ?></code></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Allowed Methods</th>
                                <td><span class="badge bg-primary"><?php echo e($apiReceiver->allowed_methods); ?></span></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Target Table</th>
                                <td><code><?php echo e($apiReceiver->target_table); ?></code></td>
                            </tr>
                            <tr>
                                <th class="bg-light">Status</th>
                                <td>
                                    <?php if($apiReceiver->is_active): ?>
                                        <span class="badge bg-success">🟢 Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">🔴 Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Authentication -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-lock me-2"></i>Authentication
                    </h4>
                    <div class="alert alert-info">
                        <strong>Authentication Type:</strong> <?php echo e(ucfirst(str_replace('_', ' ', $apiReceiver->auth_type))); ?>

                        
                        <?php if($apiReceiver->auth_type === 'basic_auth'): ?>
                            <br><strong>Username:</strong> <?php echo e($apiReceiver->auth_username); ?>

                            <br><strong>Password:</strong> <?php echo e($apiReceiver->auth_password); ?>

                            <br><strong>Encoded:</strong> <code><?php echo e(base64_encode($apiReceiver->auth_username . ':' . $apiReceiver->auth_password)); ?></code>
                        <?php elseif($apiReceiver->auth_type === 'api_key'): ?>
                            <br><strong>API Key:</strong> <code><?php echo e($apiReceiver->auth_token ?? 'Not configured'); ?></code>
                        <?php elseif($apiReceiver->auth_type === 'bearer_token'): ?>
                            <br><strong>Bearer Token:</strong> <code><?php echo e($apiReceiver->auth_token ?? 'Not configured'); ?></code>
                        <?php else: ?>
                            <br><strong>No Authentication Required</strong>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-chart-bar me-2"></i>Statistics
                    </h4>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body text-center">
                                    <h3><?php echo e($stats['total_requests'] ?? 0); ?></h3>
                                    <p class="mb-0">Total Requests</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-success text-white">
                                <div class="card-body text-center">
                                    <h3><?php echo e($stats['successful_requests'] ?? 0); ?></h3>
                                    <p class="mb-0">Successful</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body text-center">
                                    <h3><?php echo e($stats['error_requests'] ?? 0); ?></h3>
                                    <p class="mb-0">Errors</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-info text-white">
                                <div class="card-body text-center">
                                    <h3><?php echo e(round($stats['avg_response_time'] ?? 0, 2)); ?>ms</h3>
                                    <p class="mb-0">Avg Response Time</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Request Examples -->
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-paper-plane me-2"></i>Request Examples</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>🌐 Base URL:</strong> <?php echo e(url('/')); ?><br>
                        <strong>📡 Endpoint:</strong> /api/in/<?php echo e($apiReceiver->endpoint); ?><br>
                        <strong>🔧 Method:</strong> <?php echo e($apiReceiver->allowed_methods); ?>

                    </div>

                    <div class="mb-3">
                        <strong>📋 Request Headers:</strong>
                        <pre><code>Content-Type: application/json
Accept: application/json
<?php if($apiReceiver->auth_type === 'basic_auth'): ?>
Authorization: Basic <?php echo e(base64_encode($apiReceiver->auth_username . ':' . $apiReceiver->auth_password)); ?>

<?php elseif($apiReceiver->auth_type === 'bearer_token'): ?>
Authorization: Bearer <?php echo e($apiReceiver->auth_token); ?>

<?php elseif($apiReceiver->auth_type === 'api_key'): ?>
X-API-Key: <?php echo e($apiReceiver->auth_token); ?>

<?php endif; ?></code></pre>
                    </div>

                    <div class="card mb-3">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="fas fa-database me-2"></i>Request Body Example (Based on <?php echo e($apiReceiver->target_table); ?> table)</h6>
                        </div>
                        <div class="card-body">
                            <?php if($sampleData && count($sampleData) > 0): ?>
                                <p class="text-muted mb-2">Example data based on table structure:</p>
                                <pre><code>{
<?php $__currentLoopData = $sampleData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if(is_string($value)): ?>
    "<?php echo e($key); ?>": "<?php echo e($value); ?>"
<?php elseif(is_bool($value)): ?>
    "<?php echo e($key); ?>": <?php echo e($value ? 'true' : 'false'); ?>

<?php elseif(is_array($value)): ?>
    "<?php echo e($key); ?>": <?php echo e(json_encode($value)); ?>

<?php else: ?>
    "<?php echo e($key); ?>": <?php echo e($value); ?>

<?php endif; ?>
<?php if(!$loop->last): ?>,<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
}</code></pre>
                            <?php else: ?>
                                <p class="text-muted mb-2">No table structure available. Here's a generic example:</p>
                                <pre><code>{
    "name": "John Doe",
    "email": "john.doe@example.com",
    "phone": "+62812345678",
    "address": "Jl. Contoh No. 123, Jakarta",
    "created_at": "<?php echo e(now()->toISOString()); ?>",
    "status": "active"
}</code></pre>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Response Examples -->
            <div class="row mb-4">
                <div class="col-12">
                    <h4 class="text-primary mb-3">
                        <i class="fas fa-reply me-2"></i>Response Examples
                    </h4>
                    
                    <!-- Success Response -->
                    <div class="card mb-3">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-check me-2"></i>Success Response (200)</h6>
                        </div>
                        <div class="card-body">
                            <pre><code>{
    "success": true,
    "message": "Data received successfully",
    "data": {
        "received_at": "<?php echo e(now()->toISOString()); ?>",
        "endpoint": "<?php echo e($apiReceiver->endpoint); ?>",
        "records_processed": 1,
        "target_table": "<?php echo e($apiReceiver->target_table); ?>"
    },
    "meta": {
        "receiver_id": <?php echo e($apiReceiver->id); ?>,
        "timestamp": "<?php echo e(now()->toISOString()); ?>"
    }
}</code></pre>
                        </div>
                    </div>

                    <!-- Error Response -->
                    <div class="card mb-3">
                        <div class="card-header bg-danger text-white">
                            <h6 class="mb-0"><i class="fas fa-times me-2"></i>Error Response (400/500)</h6>
                        </div>
                        <div class="card-body">
                            <pre><code>{
    "success": false,
    "message": "Validation failed",
    "errors": {
        "field_name": ["The field is required"],
        "email": ["The email field must be a valid email address"]
    },
    "meta": {
        "receiver_id": <?php echo e($apiReceiver->id); ?>,
        "timestamp": "<?php echo e(now()->toISOString()); ?>"
    }
}</code></pre>
                        </div>
                    </div>

                    <!-- Authentication Error -->
                    <div class="card mb-3">
                        <div class="card-header bg-warning text-dark">
                            <h6 class="mb-0"><i class="fas fa-lock me-2"></i>Authentication Error (401)</h6>
                        </div>
                        <div class="card-body">
                            <pre><code>{
    "success": false,
    "message": "Authentication failed",
    "error": "Invalid credentials",
    "meta": {
        "receiver_id": <?php echo e($apiReceiver->id); ?>,
        "timestamp": "<?php echo e(now()->toISOString()); ?>"
    }
}</code></pre>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Success Message -->
            <div class="alert alert-success">
                <strong>✅ Preview Working!</strong> This preview shows the basic information. Click "Download PDF" to get the complete documentation.
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-receivers/preview-pdf.blade.php ENDPATH**/ ?>