<?php $__env->startSection('title', 'Edit API Receiver'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Error Messages -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-edit me-2 text-primary"></i>Edit API Receiver
            </h1>
            <p class="text-muted mt-2">Update configuration for this API receiver</p>
        </div>
        <a href="<?php echo e(route('api-receivers.show', $apiReceiver)); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Details
        </a>
    </div>

    <div class="row">
        <!-- Main Form -->
        <div class="col-12">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-gradient-primary text-white py-3">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-cog me-2"></i>Receiver Configuration
                    </h6>
                </div>
                <div class="card-body p-4">
                    <form action="<?php echo e(route('api-receivers.update', $apiReceiver)); ?>" method="POST" id="receiverForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- Basic Information Section -->
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-info-circle me-2"></i>Basic Information
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name" class="form-label fw-bold">
                                        Receiver Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control form-control-lg <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="name" name="name" value="<?php echo e(old('name', $apiReceiver->name)); ?>" required 
                                           placeholder="e.g., Customer Data Receiver" autocomplete="off">
                                    <div class="form-text">Give your receiver a descriptive name</div>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="endpoint" class="form-label fw-bold">
                                        Endpoint <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group input-group-lg">
                                        <span class="input-group-text bg-light">/api/in/</span>
                                        <input type="text" class="form-control <?php $__errorArgs = ['endpoint'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="endpoint" name="endpoint" value="<?php echo e(old('endpoint', $apiReceiver->endpoint)); ?>" required
                                               placeholder="customer-data" autocomplete="off">
                                        <button type="button" class="btn btn-outline-primary" onclick="generateEndpoint()" title="Generate from name">
                                            <i class="fas fa-magic"></i>
                                        </button>
                                    </div>
                                    <div class="form-text">Unique identifier for this receiver endpoint</div>
                                    <?php $__errorArgs = ['endpoint'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="target_table" class="form-label fw-bold">
                                        Target Table <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select form-select-lg <?php $__errorArgs = ['target_table'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="target_table" name="target_table" required>
                                        <option value="">Select Target Table</option>
                                        <?php if(!empty($tables) && is_array($tables)): ?>
                                            <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($table); ?>" <?php echo e(old('target_table', $apiReceiver->target_table) == $table ? 'selected' : ''); ?>><?php echo e($table); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <option value="" disabled>No tables found</option>
                                        <?php endif; ?>
                                    </select>
                                    <div class="form-text">Database table to store received data</div>
                                    <?php $__errorArgs = ['target_table'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="allowed_methods" class="form-label fw-bold">
                                        Allowed Methods <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select form-select-lg <?php $__errorArgs = ['allowed_methods'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="allowed_methods" name="allowed_methods" required>
                                        <option value="">Select Methods</option>
                                        <option value="GET" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'GET' ? 'selected' : ''); ?>>GET Only</option>
                                        <option value="POST" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'POST' ? 'selected' : ''); ?>>POST Only</option>
                                        <option value="GET,POST" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'GET,POST' ? 'selected' : ''); ?>>GET + POST</option>
                                        <option value="PUT" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'PUT' ? 'selected' : ''); ?>>PUT Only</option>
                                        <option value="DELETE" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'DELETE' ? 'selected' : ''); ?>>DELETE Only</option>
                                        <option value="GET,POST,PUT,DELETE" <?php echo e(old('allowed_methods', $apiReceiver->allowed_methods) == 'GET,POST,PUT,DELETE' ? 'selected' : ''); ?>>All Methods</option>
                                    </select>
                                    <div class="form-text">HTTP methods this receiver will accept</div>
                                    <?php $__errorArgs = ['allowed_methods'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="api_client_id" class="form-label fw-bold">API Client (Optional)</label>
                                    <select class="form-select form-select-lg <?php $__errorArgs = ['api_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="api_client_id" name="api_client_id" onchange="syncAuthFromClient()">
                                        <option value="">No Client Association</option>
                                        <?php $__currentLoopData = $apiClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($client->id); ?>" <?php echo e(old('api_client_id', $apiReceiver->api_client_id) == $client->id ? 'selected' : ''); ?>>
                                                <?php echo e($client->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="form-text">Associate with an API client for tracking</div>
                                    <?php $__errorArgs = ['api_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="response_format" class="form-label fw-bold">Response Format</label>
                                    <select class="form-select form-select-lg <?php $__errorArgs = ['response_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="response_format" name="response_format">
                                        <option value="json" <?php echo e(old('response_format', $apiReceiver->response_format ?? 'json') == 'json' ? 'selected' : ''); ?>>JSON</option>
                                        <option value="xml" <?php echo e(old('response_format', $apiReceiver->response_format) == 'xml' ? 'selected' : ''); ?>>XML</option>
                                        <option value="plain" <?php echo e(old('response_format', $apiReceiver->response_format) == 'plain' ? 'selected' : ''); ?>>Plain Text</option>
                                    </select>
                                    <div class="form-text">Format for response data</div>
                                    <?php $__errorArgs = ['response_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Authentication Section -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-shield-alt me-2"></i>Authentication & Security
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="auth_type" class="form-label fw-bold">Authentication Type</label>
                                    <select class="form-select form-select-lg <?php $__errorArgs = ['auth_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="auth_type" name="auth_type" onchange="toggleAuthFields()">
                                        <option value="none" <?php echo e(old('auth_type', $apiReceiver->auth_type ?? 'none') == 'none' ? 'selected' : ''); ?>>No Authentication</option>
                                        <option value="api_key" <?php echo e(old('auth_type', $apiReceiver->auth_type) == 'api_key' ? 'selected' : ''); ?>>API Key</option>
                                        <option value="bearer_token" <?php echo e(old('auth_type', $apiReceiver->auth_type) == 'bearer_token' ? 'selected' : ''); ?>>Bearer Token</option>
                                        <option value="basic_auth" <?php echo e(old('auth_type', $apiReceiver->auth_type) == 'basic_auth' ? 'selected' : ''); ?>>Basic Auth</option>
                                    </select>
                                    <div class="form-text">Choose how to authenticate incoming requests</div>
                                    <?php $__errorArgs = ['auth_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group d-none" id="auth_token_field">
                                    <label for="auth_token" class="form-label fw-bold">Authentication Token</label>
                                    <div class="input-group input-group-lg">
                                        <input type="text" class="form-control <?php $__errorArgs = ['auth_token'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="auth_token" name="auth_token" value="<?php echo e(old('auth_token', $apiReceiver->auth_token)); ?>"
                                               placeholder="Enter your token" autocomplete="off">
                                        <button type="button" class="btn btn-outline-secondary" onclick="generateToken()" title="Generate Token">
                                            <i class="fas fa-key"></i>
                                        </button>
                                    </div>
                                    <div class="form-text">Token for API authentication</div>
                                    <?php $__errorArgs = ['auth_token'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2" id="basic_auth_fields" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="auth_username" class="form-label fw-bold">Username</label>
                                    <input type="text" class="form-control form-control-lg <?php $__errorArgs = ['auth_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="auth_username" name="auth_username" value="<?php echo e(old('auth_username', $apiReceiver->auth_username)); ?>"
                                           placeholder="Enter username" autocomplete="off">
                                    <div class="form-text">Username for Basic Authentication</div>
                                    <?php $__errorArgs = ['auth_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="auth_password" class="form-label fw-bold">Password</label>
                                    <div class="input-group input-group-lg">
                                        <input type="password" class="form-control <?php $__errorArgs = ['auth_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="auth_password" name="auth_password" value="<?php echo e(old('auth_password', $apiReceiver->auth_password)); ?>"
                                               placeholder="Enter password" autocomplete="off">
                                        <button type="button" class="btn btn-outline-secondary" onclick="togglePassword()" title="Show/Hide Password">
                                            <i class="fas fa-eye" id="password_toggle_icon"></i>
                                        </button>
                                    </div>
                                    <div class="form-text">Password for Basic Authentication</div>
                                    <?php $__errorArgs = ['auth_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="allowed_ips" class="form-label fw-bold">Allowed IP Addresses</label>
                                    <input type="text" class="form-control" id="allowed_ips" name="allowed_ips" 
                                           value="<?php echo e(old('allowed_ips', $apiReceiver->allowed_ips)); ?>" placeholder="192.168.1.1, 10.0.0.0/8, 172.16.0.0/12">
                                    <div class="form-text">Comma-separated list of allowed IP addresses or ranges (leave empty for all IPs)</div>
                                    <?php $__errorArgs = ['allowed_ips'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Data Processing Section -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-database me-2"></i>Data Processing
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="duplicate_handling" class="form-label fw-bold">Duplicate Handling</label>
                                    <select class="form-select" id="duplicate_handling" name="duplicate_handling">
                                        <option value="allow" <?php echo e(old('duplicate_handling', $apiReceiver->duplicate_handling) == 'allow' ? 'selected' : ''); ?>>Allow Duplicates</option>
                                        <option value="skip" <?php echo e(old('duplicate_handling', $apiReceiver->duplicate_handling ?? 'skip') == 'skip' ? 'selected' : ''); ?>>Skip Duplicates</option>
                                        <option value="update" <?php echo e(old('duplicate_handling', $apiReceiver->duplicate_handling) == 'update' ? 'selected' : ''); ?>>Update Existing</option>
                                        <option value="reject" <?php echo e(old('duplicate_handling', $apiReceiver->duplicate_handling) == 'reject' ? 'selected' : ''); ?>>Reject Duplicates</option>
                                    </select>
                                    <div class="form-text">How to handle duplicate data</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="unique_fields" class="form-label fw-bold">Unique Fields</label>
                                    <input type="text" class="form-control" id="unique_fields" name="unique_fields" 
                                           placeholder="id,email,phone" value="<?php echo e(old('unique_fields', $apiReceiver->unique_fields ?? 'id')); ?>">
                                    <div class="form-text">Fields to check for duplicates (comma-separated)</div>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="data_filter" class="form-label fw-bold">Data Filter</label>
                                    <select class="form-select" id="data_filter" name="data_filter">
                                        <option value="all" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'all' ? 'selected' : ''); ?>>All Data</option>
                                        <option value="latest_only" <?php echo e(old('data_filter', $apiReceiver->data_filter ?? 'latest_only') == 'latest_only' ? 'selected' : ''); ?>>Latest Only</option>
                                        <option value="today_only" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'today_only' ? 'selected' : ''); ?>>Today Only</option>
                                        <option value="last_24h" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'last_24h' ? 'selected' : ''); ?>>Last 24 Hours</option>
                                        <option value="last_week" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'last_week' ? 'selected' : ''); ?>>Last Week</option>
                                        <option value="new" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'new' ? 'selected' : ''); ?>>New Records Only</option>
                                        <option value="updated" <?php echo e(old('data_filter', $apiReceiver->data_filter) == 'updated' ? 'selected' : ''); ?>>Updated Records Only</option>
                                    </select>
                                    <div class="form-text">Filter data based on criteria</div>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_records_per_request" class="form-label fw-bold">Max Records Per Request</label>
                                    <select class="form-select" id="max_records_per_request" name="max_records_per_request">
                                        <option value="10" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request) == '10' ? 'selected' : ''); ?>>10 Records</option>
                                        <option value="25" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request) == '25' ? 'selected' : ''); ?>>25 Records</option>
                                        <option value="50" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request ?? '50') == '50' ? 'selected' : ''); ?>>50 Records</option>
                                        <option value="100" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request) == '100' ? 'selected' : ''); ?>>100 Records</option>
                                        <option value="500" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request) == '500' ? 'selected' : ''); ?>>500 Records</option>
                                        <option value="unlimited" <?php echo e(old('max_records_per_request', $apiReceiver->max_records_per_request) == 'unlimited' ? 'selected' : ''); ?>>Unlimited</option>
                                    </select>
                                    <div class="form-text">Maximum records allowed per request</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="rate_limit" class="form-label fw-bold">Rate Limit (requests/hour)</label>
                                    <select class="form-select" id="rate_limit" name="rate_limit">
                                        <option value="" <?php echo e(old('rate_limit', $apiReceiver->rate_limit) == '' ? 'selected' : ''); ?>>No Limit</option>
                                        <option value="10" <?php echo e(old('rate_limit', $apiReceiver->rate_limit) == '10' ? 'selected' : ''); ?>>10 requests/hour</option>
                                        <option value="60" <?php echo e(old('rate_limit', $apiReceiver->rate_limit ?? '60') == '60' ? 'selected' : ''); ?>>60 requests/hour</option>
                                        <option value="100" <?php echo e(old('rate_limit', $apiReceiver->rate_limit) == '100' ? 'selected' : ''); ?>>100 requests/hour</option>
                                        <option value="500" <?php echo e(old('rate_limit', $apiReceiver->rate_limit) == '500' ? 'selected' : ''); ?>>500 requests/hour</option>
                                        <option value="1000" <?php echo e(old('rate_limit', $apiReceiver->rate_limit) == '1000' ? 'selected' : ''); ?>>1000 requests/hour</option>
                                    </select>
                                    <div class="form-text">Limit requests per hour to prevent abuse</div>
                                </div>
                            </div>
                        </div>

                        <!-- Field Mapping Section -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-exchange-alt me-2"></i>Field Mapping
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="field_mapping" class="form-label fw-bold">Field Mapping (JSON)</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="field_mapping" name="field_mapping" rows="4" 
                                                 placeholder='{"request_field": "database_column", "user_name": "name", "user_email": "email"}'><?php echo e(old('field_mapping', $apiReceiver->field_mapping)); ?></textarea>
                                        <button type="button" class="btn btn-outline-secondary" onclick="generateFieldMapping()">
                                            <i class="fas fa-magic"></i> Sample
                                        </button>
                                    </div>
                                    <div class="form-text">Map incoming request fields to database columns (leave empty for direct mapping)</div>
                                    <?php $__errorArgs = ['field_mapping'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Sample Data Section -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-file-code me-2"></i>Sample Data & Documentation
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sample_data" class="form-label fw-bold">Sample Data (JSON)</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="sample_data" name="sample_data" rows="6" 
                                                 placeholder='{"name": "John Doe", "email": "john@example.com", "age": 30}'><?php echo e(old('sample_data', $apiReceiver->sample_data)); ?></textarea>
                                        <button type="button" class="btn btn-outline-secondary" onclick="generateSampleData()">
                                            <i class="fas fa-magic"></i> Sample
                                        </button>
                                    </div>
                                    <div class="form-text">Example data structure for documentation purposes</div>
                                    <?php $__errorArgs = ['sample_data'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Settings Section -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-cogs me-2"></i>Settings & Options
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-check form-switch mb-3">
                                    <input type="hidden" name="auto_create_table" value="0">
                                    <input type="checkbox" class="form-check-input" id="auto_create_table" name="auto_create_table" value="1"
                                           <?php echo e(old('auto_create_table', $apiReceiver->auto_create_table) ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="auto_create_table">
                                        Auto Create Table
                                    </label>
                                    <div class="form-text">Automatically create table if it doesn't exist</div>
                                </div>

                                <div class="form-check form-switch mb-3">
                                    <input type="hidden" name="is_active" value="0">
                                    <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1"
                                           <?php echo e(old('is_active', $apiReceiver->is_active ?? true) ? 'checked' : ''); ?>>
                                    <label class="form-check-label fw-bold" for="is_active">
                                        Active Receiver
                                    </label>
                                    <div class="form-text">Enable this receiver to accept incoming data</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch mb-3">
                                    <input type="hidden" name="is_bidirectional" value="0">
                                    <input type="checkbox" class="form-check-input" id="is_bidirectional" name="is_bidirectional" value="1"
                                           <?php echo e(old('is_bidirectional', $apiReceiver->is_bidirectional) ? 'checked' : ''); ?> onchange="toggleBidirectionalFields()">
                                    <label class="form-check-label fw-bold" for="is_bidirectional">
                                        Enable Bidirectional
                                    </label>
                                    <div class="form-text">Enable two-way communication support</div>
                                </div>
                            </div>
                        </div>

                        <!-- Bidirectional Settings -->
                        <div id="bidirectionalSettings" style="display: none;" class="mt-4">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h6 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Bidirectional Settings</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="callback_url" class="form-label fw-bold">Callback URL</label>
                                                <input type="url" class="form-control" id="callback_url" name="callback_url" 
                                                       value="<?php echo e(old('callback_url', $apiReceiver->callback_url)); ?>" placeholder="https://example.com/callback">
                                                <div class="form-text">URL to send callbacks to</div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="callback_method" class="form-label fw-bold">Callback Method</label>
                                                <select class="form-select" id="callback_method" name="callback_method">
                                                    <option value="POST" <?php echo e(old('callback_method', $apiReceiver->callback_method ?? 'POST') == 'POST' ? 'selected' : ''); ?>>POST</option>
                                                    <option value="PUT" <?php echo e(old('callback_method', $apiReceiver->callback_method) == 'PUT' ? 'selected' : ''); ?>>PUT</option>
                                                    <option value="PATCH" <?php echo e(old('callback_method', $apiReceiver->callback_method) == 'PATCH' ? 'selected' : ''); ?>>PATCH</option>
                                                </select>
                                                <div class="form-text">HTTP method for callbacks</div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="response_format_bidirectional" class="form-label fw-bold">Response Format</label>
                                                <select class="form-select" id="response_format_bidirectional" name="response_format_bidirectional">
                                                    <option value="json" <?php echo e(old('response_format_bidirectional', $apiReceiver->response_format ?? 'json') == 'json' ? 'selected' : ''); ?>>JSON</option>
                                                    <option value="xml" <?php echo e(old('response_format_bidirectional', $apiReceiver->response_format) == 'xml' ? 'selected' : ''); ?>>XML</option>
                                                    <option value="plain" <?php echo e(old('response_format_bidirectional', $apiReceiver->response_format) == 'plain' ? 'selected' : ''); ?>>Plain Text</option>
                                                </select>
                                                <div class="form-text">Format for response data</div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="retry_attempts" class="form-label fw-bold">Retry Attempts</label>
                                                <input type="number" class="form-control" id="retry_attempts" name="retry_attempts" 
                                                       value="<?php echo e(old('retry_attempts', $apiReceiver->retry_attempts ?? 3)); ?>" min="0" max="10">
                                                <div class="form-text">Number of retry attempts (0-10)</div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="retry_delay" class="form-label fw-bold">Retry Delay (seconds)</label>
                                                <input type="number" class="form-control" id="retry_delay" name="retry_delay" 
                                                       value="<?php echo e(old('retry_delay', $apiReceiver->retry_delay ?? 60)); ?>" min="5" max="3600">
                                                <div class="form-text">Delay between retry attempts (5-3600 seconds)</div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-check form-switch">
                                                <input type="hidden" name="auto_acknowledge" value="0">
                                                <input type="checkbox" class="form-check-input" id="auto_acknowledge" name="auto_acknowledge" value="1"
                                                       <?php echo e(old('auto_acknowledge', $apiReceiver->auto_acknowledge ?? true) ? 'checked' : ''); ?>>
                                                <label class="form-check-label fw-bold" for="auto_acknowledge">
                                                    Auto Acknowledge
                                                </label>
                                                <div class="form-text">Automatically acknowledge received data</div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="success_response_template" class="form-label fw-bold">Success Response Template</label>
                                                <textarea class="form-control" id="success_response_template" name="success_response_template" rows="3" 
                                                         placeholder='{"status": "success", "message": "Data received successfully", "data": {data}}'><?php echo e(old('success_response_template', $apiReceiver->success_response_template)); ?></textarea>
                                                <div class="form-text">Template for success response (use {data} for dynamic content)</div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="error_response_template" class="form-label fw-bold">Error Response Template</label>
                                                <textarea class="form-control" id="error_response_template" name="error_response_template" rows="3" 
                                                         placeholder='{"status": "error", "message": "{message}", "code": {code}}'><?php echo e(old('error_response_template', $apiReceiver->error_response_template)); ?></textarea>
                                                <div class="form-text">Template for error response (use {message} and {code} for dynamic content)</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Scheduling Configuration -->
                        <hr class="my-4">
                        <div class="section-header mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-clock me-2"></i>Scheduling & Processing
                            </h5>
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-check form-switch mb-3">
                                    <input type="hidden" name="enable_scheduling" value="0">
                                    <input type="checkbox" class="form-check-input" id="enable_scheduling" name="enable_scheduling" value="1"
                                           <?php echo e(old('enable_scheduling', $apiReceiver->enable_scheduling) ? 'checked' : ''); ?> onchange="toggleSchedulingFields()">
                                    <label class="form-check-label fw-bold" for="enable_scheduling">
                                        Enable Scheduling
                                    </label>
                                    <div class="form-text">Enable automated data processing</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group" id="schedule_type_field" style="display: none;">
                                    <label for="schedule_type" class="form-label fw-bold">Schedule Type</label>
                                    <select class="form-select" id="schedule_type" name="schedule_type">
                                        <option value="manual" <?php echo e(old('schedule_type', $apiReceiver->schedule_type ?? 'manual') == 'manual' ? 'selected' : ''); ?>>Manual</option>
                                        <option value="interval" <?php echo e(old('schedule_type', $apiReceiver->schedule_type) == 'interval' ? 'selected' : ''); ?>>Interval</option>
                                        <option value="cron" <?php echo e(old('schedule_type', $apiReceiver->schedule_type) == 'cron' ? 'selected' : ''); ?>>Cron Expression</option>
                                    </select>
                                    <div class="form-text">How to schedule data processing</div>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mt-2" id="scheduling_details" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group" id="schedule_interval_field" style="display: none;">
                                    <label for="schedule_interval" class="form-label fw-bold">Schedule Interval (minutes)</label>
                                    <input type="number" class="form-control" id="schedule_interval" name="schedule_interval" 
                                           value="<?php echo e(old('schedule_interval', $apiReceiver->schedule_interval ?? 60)); ?>" min="1" max="1440">
                                    <div class="form-text">Interval between processing runs (1-1440 minutes)</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group" id="schedule_time_field" style="display: none;">
                                    <label for="schedule_time" class="form-label fw-bold">Schedule Time</label>
                                    <input type="time" class="form-control" id="schedule_time" name="schedule_time" 
                                           value="<?php echo e(old('schedule_time', $apiReceiver->schedule_time ?? '00:00')); ?>">
                                    <div class="form-text">Time to run scheduled processing</div>
                                </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <hr class="my-4">
                        <div class="form-group">
                            <label for="description" class="form-label fw-bold">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3" 
                                     placeholder="Optional description for this receiver"><?php echo e(old('description', $apiReceiver->description)); ?></textarea>
                            <div class="form-text">Add a description to help identify this receiver</div>
                        </div>

                        <!-- Alert Messages -->
                        <div id="alert-container">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(session('error')): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>Please fix the following errors:</strong>
                                    <ul class="mb-0 mt-2">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Submit Buttons -->
                        <hr class="my-4">
                        <div class="text-center">
                            <div class="row justify-content-center g-3">
                                <div class="col-12">
                                    <button type="submit" class="btn btn-success btn-lg me-3" id="saveBtn">
                                        <i class="fas fa-save me-2"></i>Save API Receiver
                                    </button>
                                    <button type="button" class="btn btn-primary btn-lg me-3" id="altSubmitBtn">
                                        <i class="fas fa-rocket me-2"></i>Submit Now
                                    </button>
                                    <button type="button" class="btn btn-info btn-lg me-3" id="simpleSubmitBtn">
                                        <i class="fas fa-paper-plane me-2"></i>Simple Submit
                                    </button>
                                </div>
                                <div class="col-12">
                                    <a href="<?php echo e(route('api-receivers.show', $apiReceiver)); ?>" class="btn btn-secondary btn-lg me-3">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </a>
                                    <button type="button" class="btn btn-warning btn-lg me-3" onclick="testReceiver()">
                                        <i class="fas fa-vial me-2"></i>Test Receiver
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Seluruh script dan style dari create.blade.php juga disamakan di sini -->
<script>
function toggleAuthFields() {
    const authType = document.getElementById('auth_type');
    const authTokenField = document.getElementById('auth_token_field');
    const basicAuthFields = document.getElementById('basic_auth_fields');
    
    if (!authType || !authTokenField || !basicAuthFields) return;
    
    // Hide all auth fields first
    authTokenField.classList.add('d-none');
    basicAuthFields.style.display = 'none';
    
    // Show relevant fields based on auth type
    if (authType.value === 'api_key' || authType.value === 'bearer_token') {
        authTokenField.classList.remove('d-none');
    } else if (authType.value === 'basic_auth') {
        basicAuthFields.style.display = 'block';
    }
}

function toggleBidirectionalFields() {
    const isBidirectional = document.getElementById('is_bidirectional').checked;
    const bidirectionalSettings = document.getElementById('bidirectionalSettings');
    
    if (isBidirectional) {
        bidirectionalSettings.style.display = 'block';
    } else {
        bidirectionalSettings.style.display = 'none';
    }
}

function generateEndpoint() {
    const nameInput = document.getElementById('name');
    const endpointInput = document.getElementById('endpoint');
    const name = nameInput.value.toLowerCase().replace(/\s+/g, '-');
    endpointInput.value = name;
}

// Generate authentication token
function generateToken() {
    const authToken = document.getElementById('auth_token');
    if (authToken) {
        const token = 'token_' + Math.random().toString(36).substr(2, 9) + '_' + Date.now();
        authToken.value = token;
    }
}

// Toggle password visibility
function togglePassword() {
    const passwordField = document.getElementById('auth_password');
    const toggleIcon = document.getElementById('password_toggle_icon');
    
    if (!passwordField || !toggleIcon) return;
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordField.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
}

// Toggle scheduling fields
function toggleSchedulingFields() {
    const enableScheduling = document.getElementById('enable_scheduling');
    const scheduleTypeField = document.getElementById('schedule_type_field');
    const schedulingDetails = document.getElementById('scheduling_details');
    
    if (!enableScheduling || !scheduleTypeField || !schedulingDetails) return;
    
    if (enableScheduling.checked) {
        scheduleTypeField.style.display = 'block';
        schedulingDetails.style.display = 'block';
        updateScheduleFields();
    } else {
        scheduleTypeField.style.display = 'none';
        schedulingDetails.style.display = 'none';
    }
}

// Update schedule fields based on schedule type
function updateScheduleFields() {
    const scheduleType = document.getElementById('schedule_type');
    const scheduleIntervalField = document.getElementById('schedule_interval_field');
    const scheduleTimeField = document.getElementById('schedule_time_field');
    
    if (!scheduleType || !scheduleIntervalField || !scheduleTimeField) return;
    
    // Hide all fields first
    scheduleIntervalField.style.display = 'none';
    scheduleTimeField.style.display = 'none';
    
    // Show relevant fields based on type
    if (scheduleType.value === 'interval') {
        scheduleIntervalField.style.display = 'block';
    } else if (scheduleType.value === 'cron') {
        scheduleTimeField.style.display = 'block';
    }
}

// Auto-sync auth from API Client
function syncAuthFromClient() {
    const apiClientId = document.getElementById('api_client_id');
    const authType = document.getElementById('auth_type');
    const authToken = document.getElementById('auth_token');
    const authUsername = document.getElementById('auth_username');
    const authPassword = document.getElementById('auth_password');
    
    if (!apiClientId || !apiClientId.value) {
        return;
    }
    
    const url = `/api-clients/${apiClientId.value}/credentials`;
    
    fetch(url, {
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
        }
    })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.client) {
                const client = data.client;
                if (authType.value === 'basic_auth') {
                    if (authUsername) authUsername.value = client.usertoken || '';
                    if (authPassword) authPassword.value = client.passtoken || '';
                } else if (authType.value === 'bearer_token') {
                    if (authToken) authToken.value = client.client_secret || '';
                } else if (authType.value === 'api_key') {
                    if (authToken) authToken.value = client.client_id || '';
                }
            }
        })
        .catch(() => {});
}


function showAlert(message, type = 'info') {
    const alertContainer = document.getElementById('alert-container');
    if (!alertContainer) return;
    
    const alert = document.createElement('div');
    alert.className = `alert alert-${type} alert-dismissible fade show`;
    alert.innerHTML = `
        <strong>${type === 'success' ? 'Success!' : type === 'danger' ? 'Error!' : 'Info:'}</strong> ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    alertContainer.appendChild(alert);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alert.parentNode) {
            alert.remove();
        }
    }, 5000);
}

function submitFormDirectly() {
    console.log('Alternative submit triggered');
    
    const form = document.getElementById('receiverForm');
    const saveBtn = document.getElementById('saveBtn');
    const altSubmitBtn = document.getElementById('altSubmitBtn');
    
    if (!form) return;
    
    // Validate required fields manually
    const requiredFields = form.querySelectorAll('[required]');
    let isValid = true;
    let firstInvalidField = null;
    
    requiredFields.forEach(field => {
        if (!field.value.trim()) {
            isValid = false;
            field.classList.add('is-invalid');
            if (!firstInvalidField) {
                firstInvalidField = field;
            }
        } else {
            field.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        showAlert('Please fill in all required fields!', 'danger');
        if (firstInvalidField) {
            firstInvalidField.focus();
        }
        return;
    }
    
    // Show loading state
    if (altSubmitBtn) {
        altSubmitBtn.disabled = true;
        altSubmitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
    }
    if (saveBtn) {
        saveBtn.disabled = true;
    }
    
    showAlert('Submitting receiver data...', 'info');
    
    // Submit using fetch API
    const formData = new FormData(form);
    formData.append('_method', 'PUT'); // For Laravel PUT method
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json, text/html',
        }
    })
    .then(response => {
        console.log('Response received:', response.status);
        
        if (response.ok) {
            showAlert('Receiver updated successfully! Redirecting...', 'success');
            setTimeout(() => {
                window.location.href = '<?php echo e(route("api-receivers.show", $apiReceiver)); ?>';
            }, 1500);
        } else {
            return response.text().then(text => {
                showAlert('Update failed: ' + response.statusText, 'danger');
                console.error('Error response:', text);
            });
        }
    })
    .catch(error => {
        console.error('Submit error:', error);
        showAlert('Network error: ' + error.message, 'danger');
    })
    .finally(() => {
        // Re-enable buttons
        if (altSubmitBtn) {
            altSubmitBtn.disabled = false;
            altSubmitBtn.innerHTML = '<i class="fas fa-rocket me-2"></i>SUBMIT NOW';
        }
        if (saveBtn) {
            saveBtn.disabled = false;
        }
    });
}

function submitSimple() {
    console.log('Simple submit triggered');
    
    const form = document.getElementById('receiverForm');
    if (!form) return;
    
    // Simple validation check
    const name = document.getElementById('name')?.value;
    const endpoint = document.getElementById('endpoint')?.value;
    const targetTable = document.getElementById('target_table')?.value;
    const allowedMethods = document.getElementById('allowed_methods')?.value;
    
    if (!name || !endpoint || !targetTable || !allowedMethods) {
        alert('Please fill in all required fields!');
        return;
    }
    
    // Show confirmation
    const confirmed = confirm(`Ready to update this API Receiver?\n\nName: ${name}\nEndpoint: ${endpoint}\nTarget Table: ${targetTable}\nMethods: ${allowedMethods}\n\nClick OK to proceed.`);
    
    if (confirmed) {
        // Create a simple loading message
        const simpleBtn = document.getElementById('simpleSubmitBtn');
        if (simpleBtn) {
            simpleBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SUBMITTING...';
            simpleBtn.disabled = true;
        }
        
        // Add a hidden field to identify this submission method
        const hiddenField = document.createElement('input');
        hiddenField.type = 'hidden';
        hiddenField.name = 'submit_method';
        hiddenField.value = 'simple';
        form.appendChild(hiddenField);
        
        // Submit the form normally
        form.submit();
    }
}

function testReceiver() {
    const endpoint = document.getElementById('endpoint')?.value;
    const allowedMethods = document.getElementById('allowed_methods')?.value;
    const authType = document.getElementById('auth_type')?.value;
    const authToken = document.getElementById('auth_token')?.value;
    
    if (!endpoint) {
        showAlert('Please enter an endpoint first!', 'warning');
        return;
    }
    
    const testUrl = '<?php echo e(url("/api/in/")); ?>/' + endpoint;
    const methods = allowedMethods ? allowedMethods.split(',') : ['GET'];
    
    let testInfo = `Endpoint Test Information:\n\n`;
    testInfo += `URL: ${testUrl}\n`;
    testInfo += `Allowed Methods: ${methods.join(', ')}\n`;
    testInfo += `Authentication: ${authType || 'none'}\n`;
    
    if (authType !== 'none' && authToken) {
        testInfo += `Token: ${authToken.substring(0, 8)}...\n`;
    }
    
    testInfo += `\nNote: Changes must be saved before testing!`;
    
    alert(testInfo);
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    try {
        // Event listeners
        const allowedMethodsEl = document.getElementById('allowed_methods');
        const authTypeEl = document.getElementById('auth_type');
        const apiClientIdEl = document.getElementById('api_client_id');
        const formEl = document.getElementById('receiverForm');
        const altSubmitBtn = document.getElementById('altSubmitBtn');
        const simpleSubmitBtn = document.getElementById('simpleSubmitBtn');
        const scheduleTypeEl = document.getElementById('schedule_type');

        if (allowedMethodsEl) {
            allowedMethodsEl.addEventListener('change', function() {
                updateFormStatus();
            });
        }

        if (authTypeEl) {
            authTypeEl.addEventListener('change', function() {
                toggleAuthFields();
                updateFormStatus();
            });
        }

        if (apiClientIdEl) {
            apiClientIdEl.addEventListener('change', function() {
                updateFormStatus();
            });
        }

        if (scheduleTypeEl) {
            scheduleTypeEl.addEventListener('change', function() {
                updateScheduleFields();
            });
        }

        if (altSubmitBtn) {
            altSubmitBtn.addEventListener('click', submitFormDirectly);
        }
        if (simpleSubmitBtn) {
            simpleSubmitBtn.addEventListener('click', submitSimple);
        }

        if (formEl) {
            formEl.addEventListener('submit', function() {
                const saveBtn = document.getElementById('saveBtn');
                if (saveBtn) {
                    saveBtn.disabled = true;
                    saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>SAVING...';
                }
                setTimeout(() => {
                    if (saveBtn && saveBtn.disabled) {
                        saveBtn.disabled = false;
                        saveBtn.innerHTML = '<i class="fas fa-save me-2"></i>SAVE API RECEIVER';
                    }
                }, 15000);
            });
        }

        // Real-time validation
        const requiredInputs = ['name', 'endpoint', 'target_table', 'allowed_methods'];
        requiredInputs.forEach(inputId => {
            const input = document.getElementById(inputId);
            if (input) {
                input.addEventListener('input', updateFormStatus);
                input.addEventListener('blur', updateFormStatus);
            }
        });

        // Initialize
        toggleAuthFields();
        toggleBidirectionalFields();
        toggleSchedulingFields();
        updateFormStatus();
    } catch (e) {
        console.error('Error initializing edit form:', e);
    }
});

// Update form status
function updateFormStatus() {
    const statusContainer = document.getElementById('form-status');
    if (!statusContainer) return;
    
    const name = document.getElementById('name')?.value || '';
    const endpoint = document.getElementById('endpoint')?.value || '';
    const targetTable = document.getElementById('target_table')?.value || '';
    const allowedMethods = document.getElementById('allowed_methods')?.value || '';
    
    const requiredFields = [name, endpoint, targetTable, allowedMethods];
    const filledFields = requiredFields.filter(field => field.trim() !== '').length;
    
    let statusHtml = '';
    if (filledFields === 4) {
        statusHtml += '<div class="d-flex align-items-center mb-2">';
        statusHtml += '<i class="fas fa-check-circle text-success me-2"></i>';
        statusHtml += '<span class="text-success fw-bold">Form is ready to submit</span>';
        statusHtml += '</div>';
    } else {
        statusHtml += '<div class="d-flex align-items-center mb-2">';
        statusHtml += '<i class="fas fa-circle text-muted me-2"></i>';
        statusHtml += '<span class="text-muted">Form is incomplete</span>';
        statusHtml += '</div>';
    }
    statusHtml += '<div class="d-flex align-items-center mb-2">';
    statusHtml += '<i class="fas fa-circle text-muted me-2"></i>';
    statusHtml += `
        <span class="text-muted">Required fields: ${filledFields}/4</span>`;
    statusHtml += '</div>';
    if (filledFields === 4) {
        statusHtml += '<div class="d-flex align-items-center">';
        statusHtml += '<i class="fas fa-check-circle text-success me-2"></i>';
        statusHtml += '<span class="text-success">Validation: Ready</span>';
        statusHtml += '</div>';
    } else {
        statusHtml += '<div class="d-flex align-items-center">';
        statusHtml += '<i class="fas fa-exclamation-circle text-warning me-2"></i>';
        statusHtml += '<span class="text-warning">Validation: Pending</span>';
        statusHtml += '</div>';
    }
    statusContainer.innerHTML = statusHtml;
}
</script>

<style>
.card {
    border: none;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.form-group label {
    font-weight: 600;
    color: #5a5c69;
}

.btn-lg {
    padding: 0.75rem 1.5rem;
    font-size: 1.1rem;
}

/* Button Text Colors */
.btn-success {
    color: #2b4a34 !important;
    background-color: #9de3bf;
    border-color: #9de3bf;
}

.btn-primary {
    color: #1a365d !important;
    background-color: #9ec5fe;
    border-color: #9ec5fe;
}

.btn-info {
    color: #1e4e8c !important;
    background-color: #a5d7f7;
    border-color: #a5d7f7;
}

.btn-warning {
    color: #603b00 !important;
    background-color: #ffd699;
    border-color: #ffd699;
}

.btn-secondary {
    color: #383d41 !important;
    background-color: #e2e6ea;
    border-color: #e2e6ea;
}

/* Hover States */
.btn-success:hover {
    color: #2b4a34 !important;
    background-color: #8ed1af;
    border-color: #8ed1af;
}

.btn-primary:hover {
    color: #1a365d !important;
    background-color: #8eb5ee;
    border-color: #8eb5ee;
}

.btn-info:hover {
    color: #1e4e8c !important;
    background-color: #95c7e7;
    border-color: #95c7e7;
}

.btn-warning:hover {
    color: #603b00 !important;
    background-color: #efc689;
    border-color: #efc689;
}

.btn-secondary:hover {
    color: #383d41 !important;
    background-color: #d2d6da;
    border-color: #d2d6da;
}

.alert {
    margin-top: 1rem;
}

.badge {
    font-size: 0.75em;
}

.text-gray-600 {
    color: #858796 !important;
}

.text-gray-700 {
    color: #6e707e !important;
}
</style>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-receivers/edit.blade.php ENDPATH**/ ?>