

<?php $__env->startSection('title', 'Edit API Client'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('api-clients.index')); ?>">API Clients</a>
    </li>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('api-clients.show', $apiClient)); ?>"><?php echo e($apiClient->name); ?></a>
    </li>
    <li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Alert Messages -->
    <div id="alert-container">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0 mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-edit me-2"></i>Edit API Client: <?php echo e($apiClient->name); ?>

                </h1>
                <div>
                    <a href="<?php echo e(route('api-clients.show', $apiClient)); ?>" class="btn btn-info">
                        <i class="fas fa-eye me-2"></i>View
                    </a>
                    <a href="<?php echo e(route('api-clients.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-user-cog me-2"></i>Update API Client Information
                    </h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('api-clients.update', $apiClient)); ?>" method="POST" id="editForm" novalidate>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- Basic Information -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label">Client Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="name" name="name" value="<?php echo e(old('name', $apiClient->name)); ?>" required
                                           placeholder="Enter a descriptive name for this API client">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" name="description" rows="3" 
                                      placeholder="Brief description of this API client and its purpose"><?php echo e(old('description', $apiClient->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Configuration -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-cog me-2"></i>Client Configuration
                        </h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="rate_limit" class="form-label">Rate Limit (requests per minute)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['rate_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="rate_limit" name="rate_limit" value="<?php echo e(old('rate_limit', $apiClient->rate_limit)); ?>" 
                                           min="1" placeholder="100">
                                    <small class="form-text text-muted">Maximum number of requests per minute allowed for this client</small>
                                    <?php $__errorArgs = ['rate_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                                               value="1" <?php echo e(old('is_active', $apiClient->is_active) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">
                                            Active Client
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">Inactive clients cannot make API requests</small>
                                </div>
                            </div>
                        </div>

                        <!-- Security -->
                        <hr class="my-4">
                        <h5 class="mb-3">
                            <i class="fas fa-shield-alt me-2"></i>Security Settings
                        </h5>

                        <div class="form-group mb-3">
                            <label for="allowed_ips" class="form-label">Allowed IP Addresses</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['allowed_ips'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="allowed_ips" name="allowed_ips" 
                                   value="<?php echo e(old('allowed_ips', $apiClient->allowed_ips ? implode(', ', $apiClient->allowed_ips) : '')); ?>" 
                                   placeholder="192.168.1.1, 10.0.0.1, 203.0.113.0/24">
                            <small class="form-text text-muted">
                                Comma-separated list of IP addresses or CIDR blocks. Leave empty to allow all IPs.
                            </small>
                            <?php $__errorArgs = ['allowed_ips'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Current Credentials Info -->
                        <hr class="my-4">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Note:</strong> Client ID and Client Secret cannot be changed after creation. 
                            If you need new credentials, you'll need to create a new API client.
                        </div>

                        <!-- Form Actions -->
                        <div class="d-flex justify-content-between">
                            <div>
                                <a href="<?php echo e(route('api-clients.show', $apiClient)); ?>" class="btn btn-secondary">
                                    <i class="fas fa-times me-2"></i>Cancel
                                </a>
                            </div>
                            <div>
                                <button type="button" class="btn btn-danger me-2" onclick="confirmDelete()">
                                    <i class="fas fa-trash me-2"></i>Delete Client
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-2"></i>Update API Client
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Hidden Delete Form -->
                    <form id="deleteForm" action="<?php echo e(route('api-clients.destroy', $apiClient)); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                    </form>
                </div>
            </div>
        </div>

        <!-- Current Client Info -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-info-circle me-2"></i>Current Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Client ID:</label>
                        <p class="font-monospace small text-gray-800"><?php echo e($apiClient->client_id); ?></p>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Created:</label>
                        <p class="text-gray-800"><?php echo e($apiClient->created_at->format('M d, Y H:i:s')); ?></p>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Last Used:</label>
                        <p class="text-gray-800">
                            <?php echo e($apiClient->last_used_at ? $apiClient->last_used_at->format('M d, Y H:i:s') : 'Never'); ?>

                        </p>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Total Tokens:</label>
                        <p class="text-gray-800"><?php echo e($apiClient->tokens()->count()); ?></p>
                    </div>
                </div>
            </div>

            <!-- Help Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>Important Notes
                    </h6>
                </div>
                <div class="card-body">
                    <p class="small text-muted mb-3">
                        <strong>Changing Status:</strong> Deactivating a client will immediately prevent all API requests using this client.
                    </p>

                    <p class="small text-muted mb-3">
                        <strong>Rate Limits:</strong> Changes to rate limits take effect immediately and apply to all active tokens.
                    </p>

                    <p class="small text-muted mb-0">
                        <strong>IP Restrictions:</strong> Adding IP restrictions will immediately block requests from non-allowed IPs.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form validation
    const form = document.getElementById('editForm');
    
    form.addEventListener('submit', function(e) {
        // Basic client-side validation
        const name = document.getElementById('name').value.trim();
        
        if (!name) {
            e.preventDefault();
            alert('Please enter a client name.');
            document.getElementById('name').focus();
            return false;
        }
        
        // Validate IP addresses if provided
        const allowedIps = document.getElementById('allowed_ips').value.trim();
        if (allowedIps) {
            const ips = allowedIps.split(',').map(ip => ip.trim());
            const ipPattern = /^(\d{1,3}\.){3}\d{1,3}(\/\d{1,2})?$/;
            
            for (let ip of ips) {
                if (!ipPattern.test(ip)) {
                    e.preventDefault();
                    alert('Invalid IP address format: ' + ip);
                    document.getElementById('allowed_ips').focus();
                    return false;
                }
            }
        }
    });
});

function confirmDelete() {
    if (confirm('Are you sure you want to delete this API client? This action cannot be undone and will revoke all associated tokens.')) {
        document.getElementById('deleteForm').submit();
    }
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-clients/edit.blade.php ENDPATH**/ ?>