

<?php $__env->startSection('title', 'API Clients'); ?>

<?php
use Illuminate\Support\Str;
?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">API Clients</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-users me-2"></i>API Clients
        </h1>
        <a href="<?php echo e(route('api-clients.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Add New Client
        </a>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-2"></i>API Clients List
            </h6>
        </div>
        <div class="card-body">
            <?php if($clients->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Rate Limit</th>
                                <th>Last Used</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div>
                                            <strong><?php echo e($client->name); ?></strong>
                                            <?php if($client->description): ?>
                                                <br><small class="text-muted"><?php echo e(Str::limit($client->description, 50)); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($client->is_active): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-check me-1"></i>Active
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">
                                                <i class="fas fa-times me-1"></i>Inactive
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($client->rate_limit ?? 'Unlimited'); ?>

                                        <?php if($client->rate_limit): ?>
                                            /min
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($client->last_used_at ? $client->last_used_at->format('M d, Y') : 'Never'); ?>

                                    </td>
                                    <td><?php echo e($client->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('api-clients.show', $client)); ?>" 
                                               class="btn btn-sm btn-info" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('api-clients.edit', $client)); ?>" 
                                               class="btn btn-sm btn-warning" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?php echo e(route('api-clients.delete', $client)); ?>" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Are you sure you want to delete <?php echo e($client->name); ?>? This action cannot be undone.')"
                                               title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($clients->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-users fa-3x text-gray-300 mb-3"></i>
                    <h4 class="text-gray-500">No API Clients Found</h4>
                    <p class="text-gray-400 mb-4">Get started by creating your first API client.</p>
                    <a href="<?php echo e(route('api-clients.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Create New API Client
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/api-clients/index.blade.php ENDPATH**/ ?>