<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'API Management System'); ?></title>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css']); ?>
    
    <!-- Bootstrap JS Bundle (includes Popper) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Wait for jQuery to be available
        document.addEventListener('DOMContentLoaded', function() {
            // Check if sidebar exists and apply appropriate styling
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.querySelector('.main-content');
            
            if (!sidebar && mainContent) {
                mainContent.classList.add('no-sidebar');
            }
            
            // Set up CSRF token for AJAX requests
            if (typeof $ !== 'undefined') {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                
                // Initialize tooltips and popovers
                $('[data-bs-toggle="tooltip"]').tooltip();
                $('[data-bs-toggle="popover"]').popover();
                
                // Copy to clipboard function
                $('.copy-btn').click(function() {
                    var text = $(this).data('copy');
                    navigator.clipboard.writeText(text).then(function() {
                        // Show success message
                        var btn = $(this);
                        btn.tooltip('hide')
                          .attr('data-bs-original-title', 'Copied!')
                          .tooltip('show');
                        
                        setTimeout(function() {
                            btn.attr('data-bs-original-title', 'Copy to clipboard');
                        }, 1000);
                    }).catch(function(err) {
                        console.error('Failed to copy text: ', err);
                    });
                });
            } else {
                console.error('jQuery is not available');
            }
        });
    </script>
    
    <style>
        /* ===== ENHANCED DESIGN SYSTEM ===== */
        :root {
            --sidebar-width: 280px;
            --topbar-height: 80px;
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --sidebar-bg: linear-gradient(180deg, #1e293b 0%, #0f172a 100%);
            --sidebar-hover: linear-gradient(90deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.2) 100%);
            --content-bg: #f8fafc;
            --card-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --card-shadow-hover: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            --border-radius: 12px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--content-bg);
            margin: 0;
            padding: 0;
            line-height: 1.6;
        }

        /* ===== LAYOUT STRUCTURE ===== */
        .app-wrapper {
            display: flex;
            min-height: 100vh;
            background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
            position: relative;
        }

        .app-wrapper::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.08) 0%, transparent 50%);
            pointer-events: none;
            z-index: -1;
        }

        /* ===== ENHANCED SIDEBAR ===== */
        .sidebar {
            width: var(--sidebar-width);
            background: var(--sidebar-bg);
            color: white;
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            transition: var(--transition);
            backdrop-filter: blur(20px);
        }

        .sidebar::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 20%, rgba(255,255,255,0.1) 0%, transparent 40%),
                radial-gradient(circle at 80% 80%, rgba(255,255,255,0.05) 0%, transparent 40%);
            pointer-events: none;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
            transition: background 0.3s ease;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
        }

        /* ===== SIDEBAR HEADER ===== */
        .sidebar-header {
            padding: 2rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent);
            transition: left 0.6s ease;
        }

        .sidebar-header:hover::before {
            left: 100%;
        }

        .sidebar-brand {
            display: flex;
            align-items: center;
            text-decoration: none;
            color: white;
            transition: var(--transition);
            position: relative;
            z-index: 2;
        }

        .sidebar-brand:hover {
            color: rgba(255, 255, 255, 0.9);
            transform: translateY(-2px) scale(1.02);
        }

        .brand-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0.1) 100%);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.75rem;
            box-shadow: 
                0 8px 32px rgba(0,0,0,0.3),
                inset 0 1px 0 rgba(255,255,255,0.2);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .brand-icon img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }

        .brand-icon::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
            transform: rotate(45deg);
            transition: all 0.6s ease;
            opacity: 0;
        }

        .sidebar-brand:hover .brand-icon::before {
            opacity: 1;
            transform: rotate(45deg) translate(50%, 50%);
        }

        .brand-text h4 {
            margin: 0;
            font-weight: 700;
            font-size: 1.5rem;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
            background: linear-gradient(135deg, #ffffff 0%, #e0e7ff 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .brand-subtitle {
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.8);
            margin: 0;
            font-weight: 400;
            letter-spacing: 0.5px;
        }

        /* ===== NAVIGATION STYLES ===== */
        .sidebar-nav {
            padding: 1.5rem 0;
            flex: 1;
            position: relative;
        }

        .nav-section {
            margin-bottom: 2rem;
            position: relative;
        }

        .nav-section-title {
            color: rgba(255, 255, 255, 0.6);
            font-size: 0.7rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            padding: 0 1.5rem;
            margin-bottom: 1rem;
            position: relative;
            display: flex;
            align-items: center;
        }

        .nav-section-title::after {
            content: '';
            flex: 1;
            height: 1px;
            background: linear-gradient(90deg, rgba(255,255,255,0.3), transparent);
            margin-left: 1rem;
        }

        .nav-link {
            color: rgba(255, 255, 255, 0.8) !important;
            border-radius: var(--border-radius);
            margin: 0.3rem 1rem;
            padding: 0.875rem 1.25rem;
            transition: var(--transition);
            font-weight: 500;
            display: flex;
            align-items: center;
            text-decoration: none;
            position: relative;
            overflow: hidden;
            font-size: 0.9rem;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: var(--sidebar-hover);
            transition: left 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: var(--border-radius);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            width: 0;
            height: 0;
            background: rgba(255,255,255,0.9);
            border-radius: 0 3px 3px 0;
            transition: var(--transition);
            transform: translateY(-50%);
        }

        .nav-link:hover::before {
            left: 0;
        }

        .nav-link:hover::after {
            width: 4px;
            height: 60%;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.15);
            color: white !important;
            transform: translateX(8px) scale(1.02);
            box-shadow: 
                0 8px 25px rgba(0, 0, 0, 0.15),
                inset 0 1px 0 rgba(255,255,255,0.1);
        }

        .nav-link.active {
            background: linear-gradient(135deg, rgba(255,255,255,0.25) 0%, rgba(255,255,255,0.15) 100%);
            color: white !important;
            font-weight: 600;
            box-shadow: 
                0 8px 25px rgba(0, 0, 0, 0.2),
                inset 0 1px 0 rgba(255,255,255,0.2);
            transform: translateX(8px);
        }

        .nav-link.active::after {
            width: 4px;
            height: 60%;
        }

        .nav-link i {
            width: 24px;
            margin-right: 1rem;
            font-size: 1.1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
        }

        .nav-link:hover i {
            transform: scale(1.1) rotate(5deg);
        }

        .nav-badge {
            margin-left: auto;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            font-size: 0.7rem;
            padding: 0.2rem 0.5rem;
            border-radius: 10px;
            font-weight: 600;
            min-width: 20px;
            text-align: center;
        }

        .nav-badge.bg-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
        }

        .nav-badge.bg-success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }

        .nav-badge.bg-warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }

        /* ===== SYSTEM INFO STYLES ===== */
        .system-info {
            display: flex;
            align-items: center;
            font-size: 0.85rem;
        }

        .system-info-panel {
            padding: 1rem;
            border-radius: var(--border-radius);
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .system-logo {
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        /* ===== MAIN CONTENT AREA ===== */
        .main-content {
            margin-left: var(--sidebar-width);
            flex: 1;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            position: relative;
        }

        /* When sidebar is not present (not authenticated) */
        .app-wrapper:not(:has(.sidebar)) .main-content,
        .app-wrapper .main-content:first-child {
            margin-left: 0;
        }

        /* Alternative approach for browsers that don't support :has() */
        .main-content.no-sidebar {
            margin-left: 0;
        }

        .topbar {
            height: var(--topbar-height);
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            padding: 0 2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .breadcrumb-nav {
            background: none;
            padding: 0;
            margin: 0;
        }

        .breadcrumb {
            background: none;
            padding: 0;
            margin: 0;
            font-size: 0.9rem;
        }

        .breadcrumb-item {
            color: #64748b;
        }

        .breadcrumb-item.active {
            color: #1e293b;
            font-weight: 600;
        }

        .topbar-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .action-btn {
            width: 40px;
            height: 40px;
            border: none;
            background: rgba(0, 0, 0, 0.05);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
            color: #64748b;
        }

        .action-btn:hover {
            background: rgba(0, 0, 0, 0.1);
            color: #1e293b;
            transform: translateY(-2px);
        }

        .content-area {
            flex: 1;
            padding: 2rem;
            position: relative;
        }

        /* ===== ENHANCED CARDS ===== */
        .modern-card {
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(0, 0, 0, 0.05);
            border-radius: var(--border-radius);
            box-shadow: var(--card-shadow);
            transition: var(--transition);
            backdrop-filter: blur(20px);
            overflow: hidden;
            position: relative;
        }

        .modern-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: var(--primary-gradient);
            opacity: 0;
            transition: var(--transition);
        }

        .modern-card:hover {
            box-shadow: var(--card-shadow-hover);
            transform: translateY(-4px);
        }

        .modern-card:hover::before {
            opacity: 1;
        }

        .modern-card-header {
            padding: 1.5rem 1.5rem 0;
            border-bottom: none;
            background: none;
        }

        .modern-card-body {
            padding: 1.5rem;
        }

        .modern-card-title {
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }

        /* ===== STATS CARDS ===== */
        .stats-card {
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(0, 0, 0, 0.05);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(20px);
        }

        .stats-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            transition: var(--transition);
        }

        .stats-card.primary::before {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        }

        .stats-card.success::before {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .stats-card.warning::before {
            background: linear-gradient(135deg, #f59e0b, #d97706);
        }

        .stats-card.info::before {
            background: linear-gradient(135deg, #06b6d4, #0891b2);
        }

        .stats-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--card-shadow-hover);
        }

        .stats-icon {
            width: 60px;
            height: 60px;
            border-radius: var(--border-radius);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
            transition: var(--transition);
        }

        .stats-icon.primary {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.1), rgba(29, 78, 216, 0.1));
            color: #3b82f6;
        }

        .stats-icon.success {
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(5, 150, 105, 0.1));
            color: #10b981;
        }

        .stats-icon.warning {
            background: linear-gradient(135deg, rgba(245, 158, 11, 0.1), rgba(217, 119, 6, 0.1));
            color: #f59e0b;
        }

        .stats-icon.info {
            background: linear-gradient(135deg, rgba(6, 182, 212, 0.1), rgba(8, 145, 178, 0.1));
            color: #06b6d4;
        }

        .stats-value {
            font-size: 2rem;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }

        .stats-label {
            color: #64748b;
            font-weight: 500;
            margin-bottom: 0.75rem;
        }

        .stats-change {
            display: flex;
            align-items: center;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .stats-change.positive {
            color: #10b981;
        }

        .stats-change.negative {
            color: #ef4444;
        }

        .stats-change i {
            margin-right: 0.25rem;
        }

        /* ===== BUTTONS ===== */
        .btn {
            border-radius: var(--border-radius);
            font-weight: 500;
            transition: var(--transition);
            border: none;
            position: relative;
            overflow: hidden;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.6s ease;
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn-primary {
            background: var(--primary-gradient);
            box-shadow: 0 4px 14px 0 rgba(103, 126, 234, 0.39);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px 0 rgba(103, 126, 234, 0.5);
        }

        /* ===== ANIMATIONS ===== */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }

        .slide-in-left {
            animation: slideInLeft 0.6s ease-out;
        }

        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .content-area {
                padding: 1rem;
            }

            .topbar {
                padding: 0 1rem;
            }
        }

        /* ===== LOADING OVERLAY ===== */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            backdrop-filter: blur(3px);
        }

        .loading-dots {
            display: flex;
            gap: 0.5rem;
        }

        .loading-dots div {
            width: 12px;
            height: 12px;
            background: #fff;
            border-radius: 50%;
            animation: loading-bounce 1.4s ease-in-out infinite both;
        }

        .loading-dots div:nth-child(1) { animation-delay: -0.32s; }
        .loading-dots div:nth-child(2) { animation-delay: -0.16s; }
        .loading-dots div:nth-child(3) { animation-delay: 0s; }
        .loading-dots div:nth-child(4) { animation-delay: 0.16s; }

        @keyframes loading-bounce {
            0%, 80%, 100% {
                transform: scale(0);
            }
            40% {
                transform: scale(1);
            }
        }

        /* ===== TOAST CONTAINER ===== */
        .toast-container {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 1055;
        }

        .toast {
            border-radius: var(--border-radius);
            box-shadow: var(--card-shadow);
            backdrop-filter: blur(20px);
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="app-wrapper">
        <?php if(auth()->guard()->check()): ?>
        <!-- Enhanced Sidebar -->
        <nav class="sidebar" id="sidebar">
            <!-- Sidebar Header -->
            <div class="sidebar-header">
                <a href="<?php echo e(route('dashboard.index')); ?>" class="sidebar-brand">
                    <div class="brand-icon">
                        <img src="<?php echo e(asset('logo1.png')); ?>" alt="Brand">
                    </div>
                    <div class="brand-text">
                        <h4>Integrasi Data</h4>
                        <p class="brand-subtitle">Management System</p>
                    </div>
                </a>
            </div>

            <!-- Navigation Menu -->
            <div class="sidebar-nav">
                <!-- Dashboard Section -->
                <div class="nav-section">
                    <div class="nav-section-title">
                        <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                    </div>
                    <a href="<?php echo e(route('dashboard.index')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard.*') ? 'active' : ''); ?>">
                        <i class="fas fa-home"></i>
                        <span>Overview</span>
                    </a>
                </div>

                <!-- API Management Section -->
                <div class="nav-section">
                    <div class="nav-section-title">
                        <i class="fas fa-cogs me-2"></i>API Management
                    </div>
                    <a href="<?php echo e(route('api-sources.index')); ?>" class="nav-link <?php echo e(request()->routeIs('api-sources.*') ? 'active' : ''); ?>">
                        <i class="fas fa-database"></i>
                        <span>API Sources</span>
                        <span class="nav-badge"><?php echo e(\App\Models\ApiSource::count() ?? 0); ?></span>
                    </a>
                    <a href="<?php echo e(route('api-targets.index')); ?>" class="nav-link <?php echo e(request()->routeIs('api-targets.*') ? 'active' : ''); ?>">
                        <i class="fas fa-bullseye"></i>
                        <span>API Targets</span>
                        <span class="nav-badge"><?php echo e(\App\Models\ApiTarget::count() ?? 0); ?></span>
                    </a>
                    <a href="<?php echo e(route('api-receivers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('api-receivers.*') ? 'active' : ''); ?>">
                        <i class="fas fa-inbox"></i>
                        <span>API Receivers</span>
                        <span class="nav-badge"><?php echo e(\App\Models\ApiReceiver::count() ?? 0); ?></span>
                    </a>
                    
                    
                </div>

                <!-- Client Management Section -->
                <div class="nav-section">
                    <div class="nav-section-title">
                        <i class="fas fa-users me-2"></i>Client Management
                    </div>
                    <a href="<?php echo e(route('api-clients.index')); ?>" class="nav-link <?php echo e(request()->routeIs('api-clients.*') ? 'active' : ''); ?>">
                        <i class="fas fa-user-tie"></i>
                        <span>API Clients</span>
                        <span class="nav-badge"><?php echo e(\App\Models\ApiClient::count() ?? 0); ?></span>
                    </a>
					
					
                </div>

				<!-- User Management Section -->
				<div class="nav-section">
					<div class="nav-section-title">
						<i class="fas fa-user-cog me-2"></i>User Management
					</div>
					<a href="<?php echo e(route('users.index')); ?>" class="nav-link <?php echo e(request()->routeIs('users.index') ? 'active' : ''); ?>">
						<i class="fas fa-users"></i>
						<span>Users</span>
						<span class="nav-badge"><?php echo e(\App\Models\User::count() ?? 0); ?></span>
					</a>
					<a href="<?php echo e(route('users.create')); ?>" class="nav-link <?php echo e(request()->routeIs('users.create') ? 'active' : ''); ?>">
						<i class="fas fa-user-plus"></i>
						<span>Buat User</span>
					</a>
				</div>

                <!-- Queue System Section -->
                <div class="nav-section">
                    <div class="nav-section-title">
                        <i class="fas fa-tasks me-2"></i>Queue System
                    </div>
                    <a href="<?php echo e(route('monitoring.index')); ?>" class="nav-link <?php echo e(request()->routeIs('monitoring.*') ? 'active' : ''); ?>">
                        <i class="fas fa-chart-line me-2"></i>
                        <span>Monitoring</span>
                    </a>
                    <a href="<?php echo e(route('analytics.index')); ?>" class="nav-link <?php echo e(request()->routeIs('analytics.*') ? 'active' : ''); ?>">
                        <i class="fas fa-chart-bar me-2"></i>
                        <span>Analytics</span>
                    </a>
                </div>


            </div>

            <!-- Sidebar Footer -->
            <div class="sidebar-footer">
                <div class="system-info-panel">
                    <div class="text-center mb-3">
                        <div class="system-logo">
                            <i class="fas fa-cogs fa-2x text-white-50"></i>
                        </div>
                        <h6 class="text-white mt-2">API Management</h6>
                    </div>
                </div>

                <div class="text-center">
                    <small class="text-muted" id="current-time"><?php echo e(now()->format('d M Y, H:i') ?? 'N/A'); ?></small>
                </div>
            </div>
        </nav>
        <?php endif; ?>

        <?php if(auth()->guard()->check()): ?>
        <!-- Main Content -->
        <main class="main-content">
            <!-- Enhanced Topbar -->
            <div class="topbar">
                <div class="d-flex align-items-center">
                    <button class="action-btn d-md-none me-3" id="sidebar-toggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    
                    <nav class="breadcrumb-nav">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('dashboard.index')); ?>">
                                    <i class="fas fa-home me-1"></i>Home
                                </a>
                            </li>
                            <?php echo $__env->yieldContent('breadcrumb'); ?>
                        </ol>
                    </nav>
                </div>

                <div class="topbar-actions">
                    <div class="system-info text-muted me-3">
                        <small>
                            <i class="fas fa-server me-1"></i>
                            System Status: <span class="text-success">Online</span>
                        </small>
                    </div>
                    <a href="<?php echo e(route('profile.edit')); ?>" class="action-btn" title="Edit Profil">
                        <i class="fas fa-user-cog"></i>
                    </a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="action-btn" title="Logout">
                            <i class="fas fa-sign-out-alt"></i>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Content Area -->
            <div class="content-area">
                <!-- Enhanced Flash Messages -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show modern-card mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle me-3 fs-4"></i>
                            <div>
                                <strong>Success!</strong>
                                <div><?php echo e(session('success')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show modern-card mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-3 fs-4"></i>
                            <div>
                                <strong>Error!</strong>
                                <div><?php echo e(session('error')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('warning')): ?>
                    <div class="alert alert-warning alert-dismissible fade show modern-card mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-triangle me-3 fs-4"></i>
                            <div>
                                <strong>Warning!</strong>
                                <div><?php echo e(session('warning')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('info')): ?>
                    <div class="alert alert-info alert-dismissible fade show modern-card mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-info-circle me-3 fs-4"></i>
                            <div>
                                <strong>Info!</strong>
                                <div><?php echo e(session('info')); ?></div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
        <?php else: ?>
        <!-- Login Required Message -->
        <div class="d-flex align-items-center justify-content-center min-vh-100">
            <div class="text-center">
                <div class="mb-4">
                    <i class="fas fa-lock fa-4x text-muted"></i>
                </div>
                <h2 class="mb-3">Login Required</h2>
                <p class="text-muted mb-4">You need to be logged in to access this application.</p>
                <a href="<?php echo e(route('login')); ?>" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt me-2"></i>Login
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Toast Container -->
    <div class="toast-container"></div>

    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loading-overlay" style="display: none;">
        <div class="text-center text-white">
            <div class="loading-dots mb-3">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
            <div class="loading-message">Loading...</div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Custom JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html> <?php /**PATH /home/copg1493/public_html/copilotproduction.site/resources/views/layouts/app.blade.php ENDPATH**/ ?>